/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput;

import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.GeneralIDAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenNodeDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewHiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewHiddenNodeDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewTextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.UniqueNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class NodeDataComboBoxModel
extends AbstractListModel<NodeBranchDataAdapter>
implements ComboBoxModel<NodeBranchDataAdapter> {
    private List<NodeBranchDataAdapter> adapters = new ArrayList<NodeBranchDataAdapter>();
    private NodeBranchDataAdapter selected = null;

    public void setAdapters(Tree tree) {
        this.setAdapters(tree, false, true, true, false, false, "");
    }

    private void addNewAdapters() {
        this.adapters.add(new NewTextLabelAdapter());
        this.adapters.add(new NewHiddenBranchDataAdapter());
        this.adapters.add(new NewHiddenNodeDataAdapter());
    }

    public void setOnlyNewAdapters() {
        this.adapters.clear();
        this.addNewAdapters();
    }

    private void countIDs(String id, Map<String, Integer> idMap) {
        if (idMap.get(id) != null) {
            idMap.put(id, idMap.get(id) + 1);
        } else {
            idMap.put(id, 1);
        }
    }

    public void setAdapters(Tree tree, boolean uniqueNamesSelectable, boolean nodeNamesSelectable, boolean branchLengthSelectable, boolean decimalOnly, boolean newIDSelectable, String voidAdapterText) {
        this.clear();
        if (voidAdapterText != null && !voidAdapterText.equals("")) {
            this.adapters.add(new VoidNodeBranchDataAdapter(voidAdapterText));
        }
        if (uniqueNamesSelectable) {
            this.adapters.add(UniqueNameAdapter.getSharedInstance());
        }
        if (nodeNamesSelectable) {
            this.adapters.add(NodeNameAdapter.getSharedInstance());
        }
        if (branchLengthSelectable) {
            this.adapters.add(BranchLengthAdapter.getSharedInstance());
        }
        if (tree != null) {
            String[] labelIDs = IDManager.getLabelIDs(tree.getPaintStart(), TextLabel.class);
            String[] hiddenBranchDataIDs = IDManager.getHiddenBranchDataIDs(tree.getPaintStart());
            String[] hiddenNodeDataIDs = IDManager.getHiddenNodeDataIDs(tree.getPaintStart());
            TreeMap<String, Integer> idDuplication = new TreeMap<String, Integer>();
            int i = 0;
            while (i < labelIDs.length) {
                this.countIDs(labelIDs[i], idDuplication);
                ++i;
            }
            i = 0;
            while (i < hiddenBranchDataIDs.length) {
                this.countIDs(hiddenBranchDataIDs[i], idDuplication);
                ++i;
            }
            i = 0;
            while (i < hiddenNodeDataIDs.length) {
                this.countIDs(hiddenNodeDataIDs[i], idDuplication);
                ++i;
            }
            for (String key : idDuplication.keySet()) {
                if ((Integer)idDuplication.get(key) <= 1) continue;
                this.adapters.add(new GeneralIDAdapter(key));
            }
            i = 0;
            while (i < labelIDs.length) {
                this.adapters.add(new TextLabelAdapter(labelIDs[i], ((TextLabel)IDManager.getFirstLabel(tree.getPaintStart(), TextLabel.class, labelIDs[i])).getFormats().getDecimalFormat()));
                ++i;
            }
            i = 0;
            while (i < hiddenBranchDataIDs.length) {
                this.adapters.add(new HiddenBranchDataAdapter(hiddenBranchDataIDs[i]));
                ++i;
            }
            i = 0;
            while (i < hiddenNodeDataIDs.length) {
                this.adapters.add(new HiddenNodeDataAdapter(hiddenNodeDataIDs[i]));
                ++i;
            }
        }
        if (decimalOnly && tree != null) {
            int i = this.getSize() - 1;
            while (i >= 0) {
                if (!tree.containsDecimal(this.adapters.get(i)) && !(this.adapters.get(i) instanceof VoidNodeBranchDataAdapter)) {
                    this.adapters.remove(i);
                }
                --i;
            }
        }
        if (newIDSelectable) {
            this.addNewAdapters();
        }
        if (this.getSize() > 0) {
            this.fireIntervalAdded(this, 0, this.adapters.size() - 1);
            this.setSelectedItem(this.adapters.get(0));
        }
    }

    public void addAdapter(int index, NodeBranchDataAdapter adapter) {
        this.adapters.add(index, adapter);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean addAdapter(NodeBranchDataAdapter adapter) {
        boolean result = this.adapters.add(adapter);
        this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        return result;
    }

    public void clear() {
        this.adapters.clear();
        this.fireIntervalRemoved(this, 0, 0);
    }

    public List<NodeBranchDataAdapter> getAdapters() {
        return Collections.unmodifiableList(this.adapters);
    }

    public boolean setSelectedAdapter(Class<? extends NodeBranchDataAdapter> adapterClass) {
        int i = 0;
        while (i < this.adapters.size()) {
            if (this.adapters.get(i).getClass().getName().equals(adapterClass.getName())) {
                this.setSelectedItem(this.adapters.get(i));
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean setSelectedAdapter(NodeBranchDataAdapter adapter) {
        int i = 0;
        while (i < this.adapters.size()) {
            if (this.adapters.get(i).equals(adapter)) {
                this.setSelectedItem(this.adapters.get(i));
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public NodeBranchDataAdapter getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.selected = null;
        } else if (item instanceof NodeBranchDataAdapter && this.adapters.contains(item)) {
            this.selected = (NodeBranchDataAdapter)item;
        } else {
            return;
        }
        this.fireContentsChanged(this, 0, this.adapters.size() - 1);
    }

    @Override
    public NodeBranchDataAdapter getElementAt(int pos) {
        return this.adapters.get(pos);
    }

    @Override
    public int getSize() {
        return this.adapters.size();
    }
}

