/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput;

import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeDataComboBoxModel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class NodeBranchDataInput {
    protected JComboBox<NodeBranchDataAdapter> comboBox = null;

    public NodeBranchDataInput(JPanel panel, int x, int y) {
        this(panel, x, y, 1);
    }

    public NodeBranchDataInput(JPanel panel, int x, int y, int gridWidth) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        gbc.gridwidth = gridWidth;
        panel.add(this.getComboBox(), gbc);
    }

    public NodeDataComboBoxModel getModel() {
        return (NodeDataComboBoxModel)this.getComboBox().getModel();
    }

    protected JComboBox<NodeBranchDataAdapter> getComboBox() {
        if (this.comboBox == null) {
            this.comboBox = new JComboBox<NodeBranchDataAdapter>(new NodeDataComboBoxModel());
        }
        return this.comboBox;
    }

    public void setEnabled(boolean enabled) {
        this.getComboBox().setEnabled(enabled);
    }

    public void setOnlyNewAdapters() {
        ((NodeDataComboBoxModel)this.getComboBox().getModel()).setOnlyNewAdapters();
    }

    public void setAdapters(Tree tree) {
        ((NodeDataComboBoxModel)this.getComboBox().getModel()).setAdapters(tree);
    }

    public void setAdapters(Tree tree, boolean uniqueNamesSelectable, boolean nodeNamesSelectable, boolean branchLengthSelectable, boolean decimalOnly, boolean newIDSelectable, String voidAdapterText) {
        ((NodeDataComboBoxModel)this.getComboBox().getModel()).setAdapters(tree, uniqueNamesSelectable, nodeNamesSelectable, branchLengthSelectable, decimalOnly, newIDSelectable, voidAdapterText);
    }

    public boolean setSelectedAdapter(Class<? extends NodeBranchDataAdapter> adapterClass) {
        return ((NodeDataComboBoxModel)this.getComboBox().getModel()).setSelectedAdapter(adapterClass);
    }

    public boolean setSelectedAdapter(NodeBranchDataAdapter adapter) {
        return ((NodeDataComboBoxModel)this.getComboBox().getModel()).setSelectedAdapter(adapter);
    }

    public NodeBranchDataAdapter getSelectedAdapter() {
        return ((NodeDataComboBoxModel)this.getComboBox().getModel()).getSelectedItem();
    }
}

