/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput;

import info.bioinfweb.treegraph.document.nodebranchdata.NewNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeDataInputListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewNodeBranchDataInput
extends NodeBranchDataInput {
    private JTextField textField = null;
    private List<NodeDataInputListener> inputListeners = new ArrayList<NodeDataInputListener>();

    public NewNodeBranchDataInput(JPanel panel, int x, int y, boolean horizontal) {
        super(panel, x, y);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        if (horizontal) {
            gbc.gridx = x + 1;
            gbc.gridy = y;
        } else {
            gbc.gridx = x;
            gbc.gridy = y + 1;
        }
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 2.0;
        panel.add((Component)this.getTextField(), gbc);
    }

    @Override
    public NodeBranchDataAdapter getSelectedAdapter() {
        NodeBranchDataAdapter result = super.getSelectedAdapter();
        if (result instanceof NewNodeBranchDataAdapter) {
            ((NewNodeBranchDataAdapter)result).setID(this.getTextField().getText());
        }
        return result;
    }

    @Override
    public boolean setSelectedAdapter(NodeBranchDataAdapter adapter) {
        boolean result = super.setSelectedAdapter(adapter);
        if (!result && adapter instanceof NewNodeBranchDataAdapter && (result = this.setSelectedAdapter(adapter.getClass()))) {
            this.setID(((NewNodeBranchDataAdapter)adapter).getID());
        }
        return result;
    }

    @Override
    protected JComboBox<NodeBranchDataAdapter> getComboBox() {
        if (this.comboBox == null) {
            super.getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        NodeBranchDataAdapter adapter = (NodeBranchDataAdapter)e.getItem();
                        boolean selected = adapter instanceof NewNodeBranchDataAdapter;
                        NewNodeBranchDataInput.this.getTextField().setEnabled(selected);
                        NewNodeBranchDataInput.this.fireNewIDSelected(selected);
                    }
                }
            });
        }
        return this.comboBox;
    }

    protected JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
        }
        return this.textField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTextField().setEnabled(enabled);
    }

    public void setID(String id) {
        this.getTextField().setText(id);
    }

    public boolean addInputListener(NodeDataInputListener listener) {
        return this.inputListeners.add(listener);
    }

    public boolean removeInputListener(NodeDataInputListener listener) {
        return this.inputListeners.remove(listener);
    }

    private void fireNewIDSelected(boolean selected) {
        int i = 0;
        while (i < this.inputListeners.size()) {
            this.inputListeners.get(i).newIDSelected(selected);
            ++i;
        }
    }
}

