/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.calculatecolumn;

import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.ErrorInfo;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ErrorsTableModel
extends AbstractTableModel
implements TableModel {
    public static final String VALUE_TEXT = "Value";
    public static final String TARGET_COLUMN_TEXT = "Target";
    private List<ErrorInfo> errors;

    public ErrorsTableModel() {
        this(null);
    }

    public ErrorsTableModel(List<ErrorInfo> errors) {
        this.errors = errors == null ? Collections.emptyList() : errors;
    }

    public List<ErrorInfo> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ErrorInfo> errors) {
        this.errors = errors;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.errors.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Node";
            }
            case 1: {
                return "Expression";
            }
            case 2: {
                return "Error";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ErrorInfo error = this.errors.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return error.getUniqueNodeName();
            }
            case 1: {
                if (error.isInValueExpression()) {
                    return VALUE_TEXT;
                }
                return TARGET_COLUMN_TEXT;
            }
            case 2: {
                return error.getMessage();
            }
        }
        return null;
    }
}

