/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.calculatecolumn;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.ErrorInfo;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.calculatecolumn.ErrorsTableModel;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class CalculateColumnErrorsDialog
extends OkCancelApplyWikiHelpDialog {
    private JPanel jContentPane = null;
    private JPanel messagesPanel = null;
    private JTable messagesTable;
    private JLabel headingLabel;

    public CalculateColumnErrorsDialog(Frame owner) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.setHelpCode(95);
        this.initialize();
    }

    public void execute(List<ErrorInfo> errors) {
        this.getTableModel().setErrors(errors);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.execute();
    }

    protected boolean apply() {
        return true;
    }

    private void selectNode(String uniqueName) {
        TreeViewPanel panel = MainFrame.getInstance().getActiveTreeFrame().getTreeViewPanel();
        panel.getSelection().set(panel.getDocument().getTree().getNodeByUniqueName(uniqueName));
    }

    private void initialize() {
        this.setTitle("Calculation errors");
        this.setContentPane(this.getJContentPane());
        this.getCancelButton().setVisible(false);
        this.getApplyButton().setVisible(false);
        this.getOkButton().setText("Close");
        this.setMinimumSize(new Dimension(500, 50));
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getMessagesPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getMessagesPanel() {
        if (this.messagesPanel == null) {
            this.messagesPanel = new JPanel();
            this.messagesPanel.setLayout(new BorderLayout(0, 0));
            this.messagesPanel.add((Component)new JScrollPane(this.getMessagesTable()), "Center");
            this.messagesPanel.add((Component)this.getHeadingLabel(), "North");
        }
        return this.messagesPanel;
    }

    private void fixColumnWidth(TableColumn column) {
        column.setMaxWidth(column.getPreferredWidth());
    }

    private JTable getMessagesTable() {
        if (this.messagesTable == null) {
            this.messagesTable = new JTable(new ErrorsTableModel());
            this.messagesTable.setAutoResizeMode(3);
            this.messagesTable.setFillsViewportHeight(true);
            this.fixColumnWidth(this.messagesTable.getColumnModel().getColumn(0));
            this.fixColumnWidth(this.messagesTable.getColumnModel().getColumn(1));
            this.messagesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int row = CalculateColumnErrorsDialog.this.getMessagesTable().rowAtPoint(e.getPoint());
                    if (row > -1) {
                        CalculateColumnErrorsDialog.this.selectNode(CalculateColumnErrorsDialog.this.getTableModel().getErrors().get(row).getUniqueNodeName());
                    }
                }
            });
        }
        return this.messagesTable;
    }

    private ErrorsTableModel getTableModel() {
        return (ErrorsTableModel)this.getMessagesTable().getModel();
    }

    private JLabel getHeadingLabel() {
        if (this.headingLabel == null) {
            this.headingLabel = new JLabel("<html> The following errors occurred during the calculation:<br> (Select a line to see the repective node in the tree.)</html>");
        }
        return this.headingLabel;
    }
}

