/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.calculatecolumn;

import info.bioinfweb.treegraph.document.nodebranchdata.NewHiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.CalculateColumnEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.editelement.TextElementDataInput;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.RecentlyUsedExpressionsListModel;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.TextIDElementTypeInput;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.calculatecolumn.CalculateColumnErrorsDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NewNodeBranchDataInput;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class CalculateColumnDialog
extends EditDialog {
    public static final int MIN_EXPRESSION_FIELD_WIDTH = 300;
    private static final long serialVersionUID = 1L;
    private CalculateColumnErrorsDialog errorDialog;
    private JPanel jContentPane = null;
    private JPanel expressionPanel = null;
    private JComboBox<String> valueExpressionComboBox = null;
    private JPanel columnPanel = null;
    private NewNodeBranchDataInput columnInput = null;
    private JRadioButton singleTargetRB;
    private JRadioButton calculatedTargetRB;
    private JComboBox<String> columnIDExpressionComboBox;
    private JLabel spacerLabel;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JLabel expressionStartLabel;
    private TextIDElementTypeInput columnIDTypeInput;
    private JLabel columnTypeLabel;
    private JPanel columnIDExpressionPanel;
    private JLabel columnIDExpressionLabel;
    private JCheckBox defaultValueCheckBox;
    private TextElementDataInput defaultValueInput;
    private JCheckBox clearTargetColumnsCheckBox;
    private JLabel columnTypeNoteLabel;

    public CalculateColumnDialog(Frame owner) {
        super(owner);
        this.setHelpCode(90);
        this.initialize();
        this.setLocationRelativeTo(owner);
        this.errorDialog = new CalculateColumnErrorsDialog(owner);
    }

    @Override
    protected boolean onExecute() {
        this.getColumnInput().setAdapters(this.getDocument().getTree(), false, true, true, false, true, "");
        this.getColumnInput().setSelectedAdapter(NewHiddenBranchDataAdapter.class);
        if (this.getSelectedAdapter() != null) {
            this.getColumnInput().setSelectedAdapter(this.getSelectedAdapter());
        }
        this.getColumnIDExpressionComboBox().setSelectedItem("");
        this.getValueExpressionComboBox().setSelectedItem("");
        this.pack();
        return true;
    }

    protected boolean apply() {
        CalculateColumnEdit edit;
        boolean result;
        NodeBranchDataAdapter singleSelectedAdapter = null;
        if (this.getSingleTargetRB().isSelected()) {
            singleSelectedAdapter = this.getColumnInput().getSelectedAdapter();
        }
        if (result = (edit = new CalculateColumnEdit(this.getDocument(), singleSelectedAdapter, (String)this.getColumnIDExpressionComboBox().getSelectedItem(), this.getColumnIDTypeInput().getSelectedType(), (String)this.getValueExpressionComboBox().getSelectedItem(), this.getClearTargetColumnsCheckBox().isSelected(), this.getDefaultValueCheckBox().isSelected() ? this.getDefaultValueInput().getValue() : null)).evaluate()) {
            this.getDocument().executeEdit(edit);
            if (edit.hasErrors()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalculateColumnDialog.this.errorDialog.execute(edit.getErrors());
                    }
                });
            }
            this.getValueExpressionsModel().addElement((String)this.getValueExpressionComboBox().getSelectedItem());
            this.getColumnIDExpressionsModel().addElement((String)this.getColumnIDExpressionComboBox().getSelectedItem());
            try {
                this.getValueExpressionsModel().saveList();
                this.getColumnIDExpressionsModel().saveList();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The error \"" + e.getLocalizedMessage() + "\" occured while " + "trying to write a configuration file.", "I/O Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), edit.getErrors(), "Erroneous expression", 0);
        }
        return result;
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("Calculate node/branch data");
        this.setMinimumSize(new Dimension(500, 50));
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getColumnPanel(), null);
            this.jContentPane.add((Component)this.getExpressionPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getExpressionPanel() {
        if (this.expressionPanel == null) {
            GridBagConstraints gbc_expressionComboBox = new GridBagConstraints();
            gbc_expressionComboBox.insets = new Insets(0, 0, 5, 0);
            gbc_expressionComboBox.weighty = 1.0;
            gbc_expressionComboBox.fill = 2;
            gbc_expressionComboBox.gridy = 0;
            gbc_expressionComboBox.weightx = 10.0;
            gbc_expressionComboBox.gridx = 1;
            this.expressionPanel = new JPanel();
            GridBagLayout gbl_expressionPanel = new GridBagLayout();
            gbl_expressionPanel.columnWeights = new double[]{0.0, 1.0};
            this.expressionPanel.setLayout(gbl_expressionPanel);
            this.expressionPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Calculate value", 4, 2, null, null));
            this.expressionPanel.add(this.getValueExpressionComboBox(), gbc_expressionComboBox);
            GridBagConstraints gbc_expressionStartLabel = new GridBagConstraints();
            gbc_expressionStartLabel.insets = new Insets(0, 2, 5, 5);
            gbc_expressionStartLabel.anchor = 17;
            gbc_expressionStartLabel.gridx = 0;
            gbc_expressionStartLabel.gridy = 0;
            this.expressionPanel.add((Component)this.getExpressionStartLabel(), gbc_expressionStartLabel);
            GridBagConstraints gbc_chckbxClearTargetColumns = new GridBagConstraints();
            gbc_chckbxClearTargetColumns.anchor = 17;
            gbc_chckbxClearTargetColumns.gridwidth = 2;
            gbc_chckbxClearTargetColumns.insets = new Insets(0, 0, 2, 2);
            gbc_chckbxClearTargetColumns.gridx = 0;
            gbc_chckbxClearTargetColumns.gridy = 1;
            this.expressionPanel.add((Component)this.getClearTargetColumnsCheckBox(), gbc_chckbxClearTargetColumns);
            GridBagConstraints gbc_defaultValueCheckBox = new GridBagConstraints();
            gbc_defaultValueCheckBox.anchor = 17;
            gbc_defaultValueCheckBox.gridwidth = 2;
            gbc_defaultValueCheckBox.insets = new Insets(0, 0, 2, 2);
            gbc_defaultValueCheckBox.gridx = 0;
            gbc_defaultValueCheckBox.gridy = 2;
            this.expressionPanel.add((Component)this.getDefaultValueCheckBox(), gbc_defaultValueCheckBox);
            GridBagConstraints gbc_defaultValueInput = new GridBagConstraints();
            gbc_defaultValueInput.gridwidth = 2;
            gbc_defaultValueInput.insets = new Insets(0, 24, 0, 2);
            gbc_defaultValueInput.fill = 1;
            gbc_defaultValueInput.gridx = 0;
            gbc_defaultValueInput.gridy = 3;
            this.expressionPanel.add((Component)this.getDefaultValueInput(), gbc_defaultValueInput);
        }
        return this.expressionPanel;
    }

    private JComboBox<String> createExpressionInput(String fileSuffix) {
        RecentlyUsedExpressionsListModel model = new RecentlyUsedExpressionsListModel(fileSuffix);
        try {
            model.loadList();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "An error occured while trying to read the configuration file.", "I/O Error", 0);
        }
        JComboBox<String> result = new JComboBox<String>(model);
        result.setEditable(true);
        result.setMinimumSize(new Dimension(300, 20));
        return result;
    }

    private JComboBox<String> getValueExpressionComboBox() {
        if (this.valueExpressionComboBox == null) {
            this.valueExpressionComboBox = this.createExpressionInput("Value");
        }
        return this.valueExpressionComboBox;
    }

    private RecentlyUsedExpressionsListModel getValueExpressionsModel() {
        return (RecentlyUsedExpressionsListModel)this.getValueExpressionComboBox().getModel();
    }

    private RecentlyUsedExpressionsListModel getColumnIDExpressionsModel() {
        return (RecentlyUsedExpressionsListModel)this.getColumnIDExpressionComboBox().getModel();
    }

    private JPanel getColumnPanel() {
        if (this.columnPanel == null) {
            this.columnPanel = new JPanel();
            this.columnPanel.setBorder(new TitledBorder(null, "Target column", 4, 2, null, null));
            GridBagLayout gbl_columnPanel = new GridBagLayout();
            gbl_columnPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0};
            gbl_columnPanel.columnWeights = new double[]{0.0, 1.0};
            this.columnPanel.setLayout(gbl_columnPanel);
            this.columnInput = new NewNodeBranchDataInput(this.columnPanel, 1, 1, true);
            GridBagConstraints gbc_singleTargetRB = new GridBagConstraints();
            gbc_singleTargetRB.gridwidth = 2;
            gbc_singleTargetRB.insets = new Insets(0, 0, 5, 5);
            gbc_singleTargetRB.anchor = 17;
            gbc_singleTargetRB.gridx = 0;
            gbc_singleTargetRB.gridy = 0;
            this.columnPanel.add((Component)this.getSingleTargetRB(), gbc_singleTargetRB);
            GridBagConstraints gbc_spacerLabel = new GridBagConstraints();
            gbc_spacerLabel.insets = new Insets(0, 0, 5, 5);
            gbc_spacerLabel.gridx = 0;
            gbc_spacerLabel.gridy = 1;
            this.columnPanel.add((Component)this.getSpacerLabel(), gbc_spacerLabel);
            GridBagConstraints gbc_calculatedTargetRB = new GridBagConstraints();
            gbc_calculatedTargetRB.gridwidth = 2;
            gbc_calculatedTargetRB.insets = new Insets(5, 0, 5, 5);
            gbc_calculatedTargetRB.anchor = 17;
            gbc_calculatedTargetRB.gridx = 0;
            gbc_calculatedTargetRB.gridy = 2;
            this.columnPanel.add((Component)this.getCalculatedTargetRB(), gbc_calculatedTargetRB);
            GridBagConstraints gbc_columnIDExpressionPanel = new GridBagConstraints();
            gbc_columnIDExpressionPanel.gridwidth = 2;
            gbc_columnIDExpressionPanel.fill = 1;
            gbc_columnIDExpressionPanel.insets = new Insets(0, 0, 5, 0);
            gbc_columnIDExpressionPanel.gridx = 1;
            gbc_columnIDExpressionPanel.gridy = 3;
            this.columnPanel.add((Component)this.getColumnIDExpressionPanel(), gbc_columnIDExpressionPanel);
            GridBagConstraints gbc_columnTypeLabel = new GridBagConstraints();
            gbc_columnTypeLabel.anchor = 17;
            gbc_columnTypeLabel.gridwidth = 2;
            gbc_columnTypeLabel.insets = new Insets(7, 0, 2, 0);
            gbc_columnTypeLabel.gridx = 1;
            gbc_columnTypeLabel.gridy = 4;
            this.columnPanel.add((Component)this.getColumnTypeLabel(), gbc_columnTypeLabel);
            GridBagConstraints gbc_columnIDTypeInput = new GridBagConstraints();
            gbc_columnIDTypeInput.insets = new Insets(0, 0, 5, 0);
            gbc_columnIDTypeInput.gridwidth = 2;
            gbc_columnIDTypeInput.fill = 1;
            gbc_columnIDTypeInput.gridx = 1;
            gbc_columnIDTypeInput.gridy = 5;
            this.columnPanel.add((Component)this.getColumnIDTypeInput(), gbc_columnIDTypeInput);
            GridBagConstraints gbc_lblnoteThatThe = new GridBagConstraints();
            gbc_lblnoteThatThe.anchor = 17;
            gbc_lblnoteThatThe.gridx = 1;
            gbc_lblnoteThatThe.gridy = 6;
            this.columnPanel.add((Component)this.getColumnTypeNoteLabel(), gbc_lblnoteThatThe);
        }
        return this.columnPanel;
    }

    private NewNodeBranchDataInput getColumnInput() {
        this.getColumnPanel();
        return this.columnInput;
    }

    private JRadioButton getSingleTargetRB() {
        if (this.singleTargetRB == null) {
            this.singleTargetRB = new JRadioButton("Define a single target column");
            this.singleTargetRB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CalculateColumnDialog.this.getColumnInput().setEnabled(CalculateColumnDialog.this.singleTargetRB.isSelected());
                }
            });
            this.buttonGroup.add(this.singleTargetRB);
            this.singleTargetRB.setSelected(true);
        }
        return this.singleTargetRB;
    }

    private JRadioButton getCalculatedTargetRB() {
        if (this.calculatedTargetRB == null) {
            this.calculatedTargetRB = new JRadioButton("Calculate (possibly different) target column ID for each line");
            this.calculatedTargetRB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CalculateColumnDialog.this.getColumnIDExpressionLabel().setEnabled(CalculateColumnDialog.this.calculatedTargetRB.isSelected());
                    CalculateColumnDialog.this.getColumnIDExpressionComboBox().setEnabled(CalculateColumnDialog.this.calculatedTargetRB.isSelected());
                    CalculateColumnDialog.this.getColumnIDTypeInput().setEnabled(CalculateColumnDialog.this.calculatedTargetRB.isSelected());
                    CalculateColumnDialog.this.getColumnTypeLabel().setEnabled(CalculateColumnDialog.this.calculatedTargetRB.isSelected());
                    CalculateColumnDialog.this.getColumnTypeNoteLabel().setEnabled(CalculateColumnDialog.this.calculatedTargetRB.isSelected());
                }
            });
            this.buttonGroup.add(this.calculatedTargetRB);
        }
        return this.calculatedTargetRB;
    }

    private JComboBox<String> getColumnIDExpressionComboBox() {
        if (this.columnIDExpressionComboBox == null) {
            this.columnIDExpressionComboBox = this.createExpressionInput("TargetColumn");
            this.columnIDExpressionComboBox.setEnabled(false);
        }
        return this.columnIDExpressionComboBox;
    }

    private JLabel getSpacerLabel() {
        if (this.spacerLabel == null) {
            this.spacerLabel = new JLabel("     ");
        }
        return this.spacerLabel;
    }

    private JLabel getExpressionStartLabel() {
        if (this.expressionStartLabel == null) {
            this.expressionStartLabel = new JLabel("value = ");
        }
        return this.expressionStartLabel;
    }

    private TextIDElementTypeInput getColumnIDTypeInput() {
        if (this.columnIDTypeInput == null) {
            this.columnIDTypeInput = new TextIDElementTypeInput();
            this.columnIDTypeInput.setEnabled(false);
        }
        return this.columnIDTypeInput;
    }

    private JLabel getColumnTypeLabel() {
        if (this.columnTypeLabel == null) {
            this.columnTypeLabel = new JLabel("Specify the type of element that shall be created if the expression results in a new column ID:");
            this.columnTypeLabel.setEnabled(false);
        }
        return this.columnTypeLabel;
    }

    private JPanel getColumnIDExpressionPanel() {
        if (this.columnIDExpressionPanel == null) {
            this.columnIDExpressionPanel = new JPanel();
            GridBagLayout gbl_columnIDExpressionPanel = new GridBagLayout();
            gbl_columnIDExpressionPanel.columnWeights = new double[]{0.0, 1.0};
            this.columnIDExpressionPanel.setLayout(gbl_columnIDExpressionPanel);
            GridBagConstraints gbc_columnIDExpressionLabel = new GridBagConstraints();
            gbc_columnIDExpressionLabel.insets = new Insets(0, 0, 0, 5);
            gbc_columnIDExpressionLabel.anchor = 17;
            gbc_columnIDExpressionLabel.gridx = 0;
            gbc_columnIDExpressionLabel.gridy = 0;
            this.columnIDExpressionPanel.add((Component)this.getColumnIDExpressionLabel(), gbc_columnIDExpressionLabel);
            GridBagConstraints gbc_columnIDExpressionTextField = new GridBagConstraints();
            gbc_columnIDExpressionTextField.fill = 2;
            gbc_columnIDExpressionTextField.weighty = 1.0;
            gbc_columnIDExpressionTextField.anchor = 11;
            gbc_columnIDExpressionTextField.gridx = 1;
            gbc_columnIDExpressionTextField.gridy = 0;
            this.columnIDExpressionPanel.add(this.getColumnIDExpressionComboBox(), gbc_columnIDExpressionTextField);
        }
        return this.columnIDExpressionPanel;
    }

    private JLabel getColumnIDExpressionLabel() {
        if (this.columnIDExpressionLabel == null) {
            this.columnIDExpressionLabel = new JLabel("target column = ");
            this.columnIDExpressionLabel.setEnabled(false);
        }
        return this.columnIDExpressionLabel;
    }

    private JCheckBox getDefaultValueCheckBox() {
        if (this.defaultValueCheckBox == null) {
            this.defaultValueCheckBox = new JCheckBox("Set the following value to all cells of the affected columns that contain no value after the calculation:");
            this.defaultValueCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CalculateColumnDialog.this.getDefaultValueInput().setEnabled(CalculateColumnDialog.this.defaultValueCheckBox.isSelected());
                }
            });
        }
        return this.defaultValueCheckBox;
    }

    private TextElementDataInput getDefaultValueInput() {
        if (this.defaultValueInput == null) {
            this.defaultValueInput = new TextElementDataInput(true);
            this.defaultValueInput.setEnabled(false);
        }
        return this.defaultValueInput;
    }

    private JCheckBox getClearTargetColumnsCheckBox() {
        if (this.clearTargetColumnsCheckBox == null) {
            this.clearTargetColumnsCheckBox = new JCheckBox("Clear target column(s) before calculation");
        }
        return this.clearTargetColumnsCheckBox;
    }

    private JLabel getColumnTypeNoteLabel() {
        if (this.columnTypeNoteLabel == null) {
            this.columnTypeNoteLabel = new JLabel("(Note that the selection made here will be ignored for columns that already exist.)");
            this.columnTypeNoteLabel.setEnabled(false);
        }
        return this.columnTypeNoteLabel;
    }
}

