/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.treegraph.document.nodebranchdata.TextIDElementType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TextIDElementTypeInput
extends JPanel {
    private JRadioButton labelRadioButton = null;
    private JRadioButton branchDataRadioButton = null;
    private JRadioButton nodeDataRadioButton = null;
    private ButtonGroup targetDataButtonGroup = null;

    public TextIDElementTypeInput() {
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.gridy = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridy = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getLabelRadioButton(), gridBagConstraints3);
        this.add((Component)this.getBranchDataRadioButton(), gridBagConstraints4);
        this.add((Component)this.getNodeDataRadioButton(), gridBagConstraints5);
        this.getTargetDataButtonGroup();
    }

    private JRadioButton getLabelRadioButton() {
        if (this.labelRadioButton == null) {
            this.labelRadioButton = new JRadioButton();
            this.labelRadioButton.setText("New text labels");
            this.labelRadioButton.setSelected(true);
        }
        return this.labelRadioButton;
    }

    private JRadioButton getBranchDataRadioButton() {
        if (this.branchDataRadioButton == null) {
            this.branchDataRadioButton = new JRadioButton();
            this.branchDataRadioButton.setText("New hidden branch data");
        }
        return this.branchDataRadioButton;
    }

    private JRadioButton getNodeDataRadioButton() {
        if (this.nodeDataRadioButton == null) {
            this.nodeDataRadioButton = new JRadioButton();
            this.nodeDataRadioButton.setText("New hidden node data");
        }
        return this.nodeDataRadioButton;
    }

    private ButtonGroup getTargetDataButtonGroup() {
        if (this.targetDataButtonGroup == null) {
            this.targetDataButtonGroup = new ButtonGroup();
            this.targetDataButtonGroup.add(this.getLabelRadioButton());
            this.targetDataButtonGroup.add(this.getBranchDataRadioButton());
            this.targetDataButtonGroup.add(this.getNodeDataRadioButton());
        }
        return this.targetDataButtonGroup;
    }

    public TextIDElementType getSelectedType() {
        if (this.getLabelRadioButton().isSelected()) {
            return TextIDElementType.TEXT_LABEL;
        }
        if (this.getBranchDataRadioButton().isSelected()) {
            return TextIDElementType.HIDDEN_BRANCH_DATA;
        }
        return TextIDElementType.HIDDEN_NODE_DATA;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getLabelRadioButton().setEnabled(enabled);
        this.getBranchDataRadioButton().setEnabled(enabled);
        this.getNodeDataRadioButton().setEnabled(enabled);
    }

    public void setSelectedType(TextIDElementType type) {
        switch (type) {
            case TEXT_LABEL: {
                this.getLabelRadioButton().setSelected(true);
                break;
            }
            case HIDDEN_BRANCH_DATA: {
                this.getBranchDataRadioButton().setSelected(true);
                break;
            }
            case HIDDEN_NODE_DATA: {
                this.getNodeDataRadioButton().setSelected(true);
                break;
            }
            default: {
                throw new InternalError("Unsupported target type " + (Object)((Object)type) + " encountered. " + "Please inform the TreeGraph developers on this bug.");
            }
        }
    }
}

