/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.undo.edit.RenameDataIDEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RenameIDDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private String[] oldNames = null;
    private JPanel jContentPane = null;
    private JPanel labelIDPanel = null;
    private JTextField newNameTextField = null;
    private JButton renameButton = null;
    private JList idList = null;

    public RenameIDDialog(Frame owner) {
        super(owner);
        this.setHelpCode(47);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    private void setNames() {
        Node root = this.getDocument().getTree().getPaintStart();
        if (root != null) {
            this.oldNames = IDManager.getIDs(root);
            DefaultListModel model = (DefaultListModel)this.getIdList().getModel();
            model.removeAllElements();
            if (this.oldNames.length > 0) {
                int i = 0;
                while (i < this.oldNames.length) {
                    model.addElement(this.oldNames[i]);
                    ++i;
                }
                this.getIdList().setSelectedIndex(0);
                this.getIdList().ensureIndexIsVisible(0);
            }
        }
    }

    @Override
    protected boolean onExecute() {
        this.setNames();
        return true;
    }

    protected boolean apply() {
        Vector<String> oldIDs = new Vector<String>();
        Vector<String> newIDs = new Vector<String>();
        int i = 0;
        while (i < this.oldNames.length) {
            String newName = (String)((DefaultListModel)this.getIdList().getModel()).elementAt(i);
            if (!this.oldNames[i].equals(newName)) {
                oldIDs.add(this.oldNames[i]);
                newIDs.add(newName);
            }
            ++i;
        }
        this.getDocument().executeEdit(new RenameDataIDEdit(this.getDocument(), newIDs.toArray(new String[newIDs.size()]), oldIDs.toArray(new String[oldIDs.size()])));
        return true;
    }

    private void initialize() {
        this.setTitle("Rename ID");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getLabelIDPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getLabelIDPanel() {
        if (this.labelIDPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            this.labelIDPanel = new JPanel();
            this.labelIDPanel.setLayout(new GridBagLayout());
            this.labelIDPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.labelIDPanel.add((Component)this.getNewNameTextField(), gridBagConstraints);
            this.labelIDPanel.add((Component)this.getRenameButton(), gridBagConstraints1);
            this.labelIDPanel.add((Component)new JScrollPane(this.getIdList()), gridBagConstraints2);
        }
        return this.labelIDPanel;
    }

    private JTextField getNewNameTextField() {
        if (this.newNameTextField == null) {
            this.newNameTextField = new JTextField();
        }
        return this.newNameTextField;
    }

    private JButton getRenameButton() {
        if (this.renameButton == null) {
            this.renameButton = new JButton();
            this.renameButton.setText("Rename");
            this.renameButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RenameIDDialog.this.getIdList().getSelectedIndex() != -1) {
                        ((DefaultListModel)RenameIDDialog.this.getIdList().getModel()).set(RenameIDDialog.this.getIdList().getSelectedIndex(), RenameIDDialog.this.getNewNameTextField().getText());
                    } else {
                        JOptionPane.showMessageDialog(null, "There is no ID selected.", "No ID selected", 0);
                    }
                }
            });
        }
        return this.renameButton;
    }

    private JList getIdList() {
        if (this.idList == null) {
            this.idList = new JList(new DefaultListModel());
            this.idList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (Math2.isBetween(e.getFirstIndex(), 0, RenameIDDialog.this.getIdList().getModel().getSize() - 1)) {
                        RenameIDDialog.this.getNewNameTextField().setText((String)RenameIDDialog.this.getIdList().getModel().getElementAt(e.getFirstIndex()));
                    }
                }
            });
        }
        return this.idList;
    }
}

