/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.commons.SystemUtils;
import info.bioinfweb.treegraph.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;

public class RecentlyUsedExpressionsListModel
extends DefaultComboBoxModel<String>
implements MutableComboBoxModel<String> {
    public static final String FILE_NAME_PREFIX = "RecentlyUsedExpressions";
    public static final String FILE_NAME_EXTENSION = ".txt";
    public static final int MAXIMAL_COUNT = 25;
    private String fileName = "RecentlyUsedExpressions.txt";

    public RecentlyUsedExpressionsListModel(String fileNameSuffix) {
        this.fileName = FILE_NAME_PREFIX + fileNameSuffix + FILE_NAME_EXTENSION;
    }

    public String getFileName() {
        return String.valueOf(Main.CONFIG_DIR) + System.getProperty("file.separator") + this.fileName;
    }

    private void cutToSize() {
        if (this.getSize() > 25) {
            int i = this.getSize() - 1;
            while (i >= 25) {
                this.removeElementAt(i);
                --i;
            }
        }
    }

    @Override
    public void addElement(String expression) {
        this.removeElement(expression);
        super.insertElementAt(expression, 0);
        this.cutToSize();
    }

    public void loadList() throws IOException {
        this.removeAllElements();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.getFileName()));){
            String line = reader.readLine();
            while (line != null) {
                this.addElement(line);
                line = reader.readLine();
            }
            this.cutToSize();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void saveList() throws IOException {
        File file = new File(this.getFileName());
        if (file.getParentFile().mkdirs() && SystemUtils.IS_OS_WINDOWS) {
            Path path = Paths.get(file.getParent(), new String[0]);
            try {
                Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        try (PrintWriter writer = new PrintWriter(file);){
            int i = 0;
            while (i < this.getSize()) {
                writer.println((String)this.getElementAt(i));
                ++i;
            }
        }
    }
}

