/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.AbstractNodeBranchDataColumnsDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NewNodeBranchDataInput;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NodeBranchDataColumnsDialog
extends AbstractNodeBranchDataColumnsDialog {
    private static final long serialVersionUID = 1L;
    private static final int USED_ROWS = 1;
    private JPanel jContentPane = null;
    private JLabel typeLabel = null;
    private JLabel idLabel = null;
    private List<NewNodeBranchDataInput> inputs = new ArrayList<NewNodeBranchDataInput>();
    private NodeBranchDataAdapter[] adapters = null;
    private boolean[] allowEdit;

    public NodeBranchDataColumnsDialog(Frame owner, String title, int helpCode) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.setHelpCode(helpCode);
        this.setTitle(title);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    private void createInputs(String voidAdapterText) {
        this.getImportPanel().removeAll();
        this.inputs.clear();
        GridBagConstraints idGBC = new GridBagConstraints();
        idGBC.gridx = 2;
        idGBC.gridy = 0;
        idGBC.anchor = 17;
        idGBC.insets = new Insets(0, 0, 8, 0);
        this.idLabel = new JLabel();
        this.idLabel.setText("ID:                ");
        GridBagConstraints typeGBC = new GridBagConstraints();
        typeGBC.gridx = 1;
        typeGBC.anchor = 17;
        typeGBC.gridy = 0;
        typeGBC.insets = new Insets(0, 0, 8, 0);
        this.typeLabel = new JLabel();
        this.typeLabel.setText("Node data type:");
        this.importPanel.add((Component)this.typeLabel, typeGBC);
        this.importPanel.add((Component)this.idLabel, idGBC);
        int i = 0;
        while (i < this.allowEdit.length) {
            int line = 1 + i;
            GridBagConstraints labelGBC = new GridBagConstraints();
            labelGBC.anchor = 13;
            labelGBC.gridx = 0;
            labelGBC.gridy = line;
            labelGBC.insets = new Insets(0, 8, 0, 8);
            this.getImportPanel().add((Component)new JLabel(line + ")"), labelGBC);
            NewNodeBranchDataInput input = new NewNodeBranchDataInput(this.getImportPanel(), 1, line, true);
            input.setAdapters(this.tree, false, true, true, false, true, voidAdapterText);
            input.setSelectedAdapter(this.adapters[i]);
            input.setEnabled(this.allowEdit[i]);
            this.inputs.add(input);
            ++i;
        }
        this.pack();
    }

    private void processPreselectedAdapters(NodeBranchDataAdapter defaultAdapter, String voidAdapterText) {
        if (defaultAdapter == null) {
            defaultAdapter = new VoidNodeBranchDataAdapter(voidAdapterText);
        }
        int i = 0;
        while (i < this.adapters.length) {
            if (this.adapters[i] == null) {
                this.adapters[i] = defaultAdapter;
            }
            ++i;
        }
    }

    public boolean execute(Tree tree, NodeBranchDataAdapter[] adapters, NodeBranchDataAdapter defaultAdapter, boolean[] allowEdit, String voidAdapterText) {
        if (adapters.length != allowEdit.length) {
            throw new IllegalArgumentException("Both specified array must have the same lengths.");
        }
        this.adapters = adapters;
        this.processPreselectedAdapters(defaultAdapter, voidAdapterText);
        this.allowEdit = allowEdit;
        this.tree = tree;
        this.createInputs(voidAdapterText);
        return this.execute();
    }

    protected boolean apply() {
        NodeBranchDataAdapter[] resultingAdapters = new NodeBranchDataAdapter[this.inputs.size()];
        Iterator<NewNodeBranchDataInput> iterator = this.inputs.iterator();
        int i = 0;
        while (i < resultingAdapters.length) {
            resultingAdapters[i] = iterator.next().getSelectedAdapter();
            ++i;
        }
        boolean result = this.checkSelectedAdapters(resultingAdapters, this.allowEdit);
        if (result) {
            int i2 = 0;
            while (i2 < this.adapters.length) {
                this.adapters[i2] = resultingAdapters[i2];
                ++i2;
            }
        }
        return result;
    }

    private void initialize() {
        this.setSize(300, 200);
        this.getApplyButton().setVisible(false);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getScrollPane(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }
}

