/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.commons.swing.DecimalInput;
import info.bioinfweb.treegraph.document.undo.edit.DeleteOutsideIntervalEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class IntervalDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_UPPER_BORDER = 100.0;
    public static final double DEFAULT_LOWER_BORDER = 50.0;
    private JPanel jContentPane = null;
    private JPanel intervalPanel = null;
    private DecimalInput upperInput = null;
    private DecimalInput lowerInput = null;
    private JPanel sourcePanel = null;
    private NodeBranchDataInput sourceInput = null;

    public IntervalDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private double getUpperBorder() {
        return this.upperInput.parseDouble();
    }

    private double getLowerBorder() {
        return this.lowerInput.parseDouble();
    }

    private void initialize() {
        this.setHelpCode(31);
        this.setTitle("Delte values outside interval");
        this.setMinimumSize(new Dimension(400, 50));
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    @Override
    protected boolean onExecute() {
        this.getSourceInput().setAdapters(this.getDocument().getTree());
        if (this.getSelectedAdapter() != null) {
            this.getSourceInput().setSelectedAdapter(this.getSelectedAdapter());
        }
        return true;
    }

    protected boolean apply() {
        this.getDocument().executeEdit(new DeleteOutsideIntervalEdit(this.getDocument(), this.getSourceInput().getSelectedAdapter(), this.getLowerBorder(), this.getUpperBorder()));
        return true;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getSourcePanel(), null);
            this.jContentPane.add((Component)this.getIntervalPanel(), null);
            this.getApplyButton().setVisible(false);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getIntervalPanel() {
        if (this.intervalPanel == null) {
            this.intervalPanel = new JPanel();
            this.intervalPanel.setLayout(new GridBagLayout());
            this.intervalPanel.setBorder(BorderFactory.createTitledBorder(null, "Borders", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.upperInput = new DecimalInput("Upper border", this.intervalPanel, 0, "#.##########");
            this.upperInput.setValue(100.0);
            this.lowerInput = new DecimalInput("Lower border", this.intervalPanel, 2, "#.##########");
            this.lowerInput.setValue(50.0);
        }
        return this.intervalPanel;
    }

    private JPanel getSourcePanel() {
        if (this.sourcePanel == null) {
            this.sourcePanel = new JPanel();
            this.sourcePanel.setLayout(new GridBagLayout());
            this.sourcePanel.setBorder(BorderFactory.createTitledBorder(null, "Source column", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.sourceInput = new NodeBranchDataInput(this.sourcePanel, 0, 0);
        }
        return this.sourcePanel;
    }

    private NodeBranchDataInput getSourceInput() {
        this.getSourcePanel();
        return this.sourceInput;
    }
}

