/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.treegraph.document.undo.edit.DefaultDocumentAdapterEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DefaultDocumentAdapterDialog
extends EditDialog {
    private JPanel jContentPane = null;
    private JPanel defaultDocumentAdaptersPanel = null;
    private JLabel defaultSupportAdapterLabel = null;
    private NodeBranchDataInput defaultLeafAdapterInput;
    private NodeBranchDataInput defaultSupportAdapterInput;

    public DefaultDocumentAdapterDialog(MainFrame mainFrame) {
        super(mainFrame);
        this.setHelpCode(79);
        this.initialize();
        this.setLocationRelativeTo(mainFrame);
    }

    @Override
    protected boolean onExecute() {
        this.defaultLeafAdapterInput.setAdapters(this.getDocument().getTree(), true, true, false, false, false, null);
        this.defaultSupportAdapterInput.setAdapters(this.getDocument().getTree(), false, true, true, false, false, "No support values available");
        this.defaultLeafAdapterInput.setSelectedAdapter(this.getDocument().getDefaultLeafAdapter());
        this.defaultSupportAdapterInput.setSelectedAdapter(this.getDocument().getDefaultSupportAdapter());
        return true;
    }

    protected boolean apply() {
        DefaultDocumentAdapterEdit edit = new DefaultDocumentAdapterEdit(this.getDocument(), this.defaultLeafAdapterInput.getSelectedAdapter(), this.defaultSupportAdapterInput.getSelectedAdapter());
        this.getDocument().executeEdit(edit);
        return true;
    }

    private void initialize() {
        this.setTitle("Set default node/branch data columns");
        this.setContentPane(this.getJContentPane());
        this.setMinimumSize(new Dimension(300, 150));
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getDefaultDocumentAdaptersPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
            this.getApplyButton().setVisible(false);
        }
        return this.jContentPane;
    }

    private JPanel getDefaultDocumentAdaptersPanel() {
        if (this.defaultDocumentAdaptersPanel == null) {
            this.defaultDocumentAdaptersPanel = new JPanel();
            this.defaultDocumentAdaptersPanel.setLayout(new GridBagLayout());
            GridBagConstraints defaultLeafAdapterLabelGBC = new GridBagConstraints();
            defaultLeafAdapterLabelGBC.gridx = 0;
            defaultLeafAdapterLabelGBC.anchor = 17;
            defaultLeafAdapterLabelGBC.gridy = 0;
            defaultLeafAdapterLabelGBC.insets = new Insets(4, 6, 4, 0);
            defaultLeafAdapterLabelGBC.gridwidth = -1;
            this.defaultSupportAdapterLabel = new JLabel();
            this.defaultSupportAdapterLabel.setText("Set default leaf column:");
            this.defaultDocumentAdaptersPanel.add((Component)this.defaultSupportAdapterLabel, defaultLeafAdapterLabelGBC);
            this.defaultLeafAdapterInput = new NodeBranchDataInput(this.defaultDocumentAdaptersPanel, 0, 1);
            GridBagConstraints defaultSupportAdapterLabelGBC = new GridBagConstraints();
            defaultSupportAdapterLabelGBC.gridx = 0;
            defaultSupportAdapterLabelGBC.anchor = 17;
            defaultSupportAdapterLabelGBC.gridy = 2;
            defaultSupportAdapterLabelGBC.insets = new Insets(4, 6, 4, 0);
            defaultSupportAdapterLabelGBC.gridwidth = -1;
            this.defaultSupportAdapterLabel = new JLabel();
            this.defaultSupportAdapterLabel.setText("Set default support column:");
            this.defaultDocumentAdaptersPanel.add((Component)this.defaultSupportAdapterLabel, defaultSupportAdapterLabelGBC);
            this.defaultSupportAdapterInput = new NodeBranchDataInput(this.defaultDocumentAdaptersPanel, 0, 3);
        }
        return this.defaultDocumentAdaptersPanel;
    }
}

