/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.nodebranchdata.NewNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewTextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.undo.edit.CopyColumnEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NewNodeBranchDataInput;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CopyColumnDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel copyPanel = null;
    private JLabel srcLabel = null;
    private NodeBranchDataInput srcInput = null;
    private JLabel destLabel = null;
    private JLabel labelIDLabel = null;
    private NewNodeBranchDataInput destInput = null;
    private JCheckBox includeLeavesCheckBox = null;

    public CopyColumnDialog(Frame owner) {
        super(owner);
        this.setHelpCode(19);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        this.getSrcInput().setAdapters(this.getDocument().getTree(), true, true, true, false, false, "");
        if (this.getSelectedAdapter() != null) {
            this.getSrcInput().setSelectedAdapter(this.getSelectedAdapter().getClass());
        }
        this.getDestInput().setAdapters(this.getDocument().getTree(), false, true, true, false, true, "");
        this.getDestInput().setSelectedAdapter(NewTextLabelAdapter.class);
        this.pack();
        return true;
    }

    protected boolean apply() {
        boolean result;
        boolean bl = result = !this.getDestAdapter().isNewColumn() || !IDManager.idExistsInSubtree(this.getDocument().getTree().getPaintStart(), ((NewNodeBranchDataAdapter)this.getDestAdapter()).getID());
        if (result) {
            this.getDocument().executeEdit(new CopyColumnEdit(this.getDocument(), this.getSrcAdapter(), this.getDestAdapter(), this.getIncludeLeaves()));
        } else {
            WikiHelpOptionPane.showMessageDialog((Component)((Object)this), (Object)("There are already elements with the ID \"" + ((NewNodeBranchDataAdapter)this.getDestAdapter()).getID() + "\" present.\n" + "Please choose another ID."), (String)"Invalid ID", (int)0, (WikiHelp)Main.getInstance().getWikiHelp(), (int)30);
        }
        return result;
    }

    public NodeBranchDataAdapter getSrcAdapter() {
        return this.getSrcInput().getSelectedAdapter();
    }

    public NodeBranchDataAdapter getDestAdapter() {
        return this.getDestInput().getSelectedAdapter();
    }

    public boolean getIncludeLeaves() {
        return this.getIncludeLeavesCheckBox().isSelected();
    }

    private void initialize() {
        this.setTitle("Copy node/branch data");
        this.setContentPane(this.getJContentPane());
        this.getApplyButton().setVisible(false);
        this.pack();
    }

    public NodeBranchDataInput getSrcInput() {
        this.getCopyPanel();
        return this.srcInput;
    }

    public NewNodeBranchDataInput getDestInput() {
        this.getCopyPanel();
        return this.destInput;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getCopyPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getCopyPanel() {
        if (this.copyPanel == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 2;
            this.labelIDLabel = new JLabel();
            this.labelIDLabel.setText("New ID: ");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 17;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            this.destLabel = new JLabel();
            this.destLabel.setText("Destination: ");
            this.srcLabel = new JLabel();
            this.srcLabel.setText("Source: ");
            this.copyPanel = new JPanel();
            this.copyPanel.setLayout(new GridBagLayout());
            this.copyPanel.add((Component)this.srcLabel, gridBagConstraints11);
            this.srcInput = new NodeBranchDataInput(this.copyPanel, 1, 0);
            this.copyPanel.add((Component)this.destLabel, gridBagConstraints1);
            this.copyPanel.add((Component)this.labelIDLabel, gridBagConstraints3);
            this.destInput = new NewNodeBranchDataInput(this.copyPanel, 1, 1, false);
            this.copyPanel.add((Component)this.getIncludeLeavesCheckBox(), gridBagConstraints12);
        }
        return this.copyPanel;
    }

    private JCheckBox getIncludeLeavesCheckBox() {
        if (this.includeLeavesCheckBox == null) {
            this.includeLeavesCheckBox = new JCheckBox();
            this.includeLeavesCheckBox.setText("Include data from leaves");
        }
        return this.includeLeavesCheckBox;
    }
}

