/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdata;

import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.IDElementAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import info.bioinfweb.wikihelp.client.WikiHelp;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractNodeBranchDataColumnsDialog
extends OkCancelApplyWikiHelpDialog {
    protected JPanel importPanel = null;
    protected JScrollPane scrollPane;
    protected Tree tree = null;

    public AbstractNodeBranchDataColumnsDialog(Frame owner, boolean modal, WikiHelp wikiHelp) {
        super(owner, modal, wikiHelp);
    }

    protected boolean checkSelectedAdapters(NodeBranchDataAdapter[] adapterArray, boolean[] excludedAdapters) {
        NodeBranchDataAdapter adapter;
        StringBuffer message = new StringBuffer();
        ArrayList<String> duplicateColumns = new ArrayList<String>();
        message.append("The following node/branch data columns were selected more than once:\n\n");
        HashSet<String> adapterTypes = new HashSet<String>();
        boolean cancel = false;
        boolean idExists = false;
        int i = 0;
        while (i < adapterArray.length) {
            if (excludedAdapters == null || excludedAdapters[i]) {
                adapter = adapterArray[i];
                if (!(adapter instanceof VoidNodeBranchDataAdapter)) {
                    if (adapter instanceof IDElementAdapter) {
                        String name = "Node/branch data columns with the ID \"" + ((IDElementAdapter)adapter).getID() + "\"";
                        if (!adapterTypes.add(name)) {
                            idExists = true;
                            duplicateColumns.add(name);
                        }
                    } else if (!adapterTypes.add(adapter.toString())) {
                        idExists = true;
                        duplicateColumns.add(adapter.toString());
                    }
                }
                cancel = cancel || idExists;
            }
            ++i;
        }
        message.append(DocumentAction.createElementList(duplicateColumns, false));
        message.append("\nPlease select different node/branch data columns.");
        if (cancel) {
            JOptionPane.showMessageDialog((Component)((Object)this), message, "Error", 0);
        } else {
            message.delete(0, message.length());
            duplicateColumns.clear();
            message.append("The following node/branch data columns already exist in the tree:\n\n");
            i = 0;
            while (i < adapterArray.length) {
                if (excludedAdapters == null || excludedAdapters[i]) {
                    adapter = adapterArray[i];
                    boolean columnExists = false;
                    if (!(adapter instanceof VoidNodeBranchDataAdapter)) {
                        if (adapter instanceof IDElementAdapter) {
                            columnExists = IDManager.idExistsInSubtree(this.tree.getPaintStart(), ((IDElementAdapter)adapter).getID());
                            if (columnExists) {
                                duplicateColumns.add("Node/branch data columns with the ID \"" + ((IDElementAdapter)adapter).getID() + "\"");
                            }
                        } else {
                            columnExists = true;
                            duplicateColumns.add(adapter.toString());
                        }
                    }
                    cancel = cancel || columnExists;
                }
                ++i;
            }
            message.append(DocumentAction.createElementList(duplicateColumns, false));
            message.append("\n\nDo you want to possibly overwrite entries in these columns?\n");
            message.append("(Only data of those nodes that are referenced in the imported file will be affected.)");
            if (cancel) {
                cancel = JOptionPane.showConfirmDialog((Component)((Object)this), message, "Warning", 0) == 1;
            }
        }
        return !cancel;
    }

    protected JPanel getImportPanel() {
        if (this.importPanel == null) {
            this.importPanel = new JPanel();
            this.importPanel.setLayout(new GridBagLayout());
        }
        return this.importPanel;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getImportPanel());
        }
        return this.scrollPane;
    }
}

