/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.imexporttable;

import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableParameters;
import info.bioinfweb.treegraph.gui.dialogs.io.FileDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.TableSeparatorPanel;
import info.bioinfweb.treegraph.gui.dialogs.io.TextFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SelectImportTableDialog
extends FileDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel filePanel = null;
    private TableSeparatorPanel separatorPanel = null;
    private JFileChooser fileChooser;
    private JPanel nodeIdentificationPanel;
    private JLabel separatorLabel;
    private JLabel linesToSkipLabel;
    private JCheckBox columnHeadingsCheckBox;
    private JSpinner linesToSkipSpinner;

    public SelectImportTableDialog(Frame owner) {
        super(owner, FileDialog.Option.FILE_MUST_EXIST);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    public void assignParameters(ImportTableParameters parameters) {
        parameters.setTableFile(this.getSelectedFile());
        parameters.setColumnSeparator(this.getSeparatorPanel().getSeparator());
        parameters.setLinesToSkip((Integer)this.getLinesToSkipSpinner().getValue());
        parameters.setHeadingContained(this.getColumnHeadingsCheckBox().isSelected());
    }

    @Override
    protected boolean onApply(File file) {
        return true;
    }

    @Override
    protected boolean onExecute() {
        return true;
    }

    private void initialize() {
        this.setHelpCode(88);
        this.setTitle("Import table as node/branch data");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    @Override
    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(0);
            this.fileChooser.setControlButtonsAreShown(false);
            TextFileFilter textFilter = new TextFileFilter();
            this.fileChooser.addChoosableFileFilter(textFilter);
            this.fileChooser.setFileFilter(textFilter);
        }
        return this.fileChooser;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getFilePanel(), null);
            this.jContentPane.add(this.getNodeIdentificationPanel());
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
            this.getApplyButton().setVisible(false);
            this.getOkButton().setText("Next >");
        }
        return this.jContentPane;
    }

    private JPanel getFilePanel() {
        if (this.filePanel == null) {
            this.filePanel = new JPanel();
            this.filePanel.setLayout(new BoxLayout(this.getFilePanel(), 1));
            this.filePanel.setBorder(BorderFactory.createTitledBorder(null, "File", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.filePanel.add((Component)this.getFileChooser(), null);
        }
        return this.filePanel;
    }

    private TableSeparatorPanel getSeparatorPanel() {
        if (this.separatorPanel == null) {
            this.separatorPanel = new TableSeparatorPanel();
            this.separatorPanel.setBorder(null);
        }
        return this.separatorPanel;
    }

    private JPanel getNodeIdentificationPanel() {
        if (this.nodeIdentificationPanel == null) {
            this.nodeIdentificationPanel = new JPanel();
            this.nodeIdentificationPanel.setBorder(BorderFactory.createTitledBorder(null, "Table preferences", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            GridBagLayout gbl_nodeIdentificationPanel = new GridBagLayout();
            gbl_nodeIdentificationPanel.columnWidths = new int[3];
            gbl_nodeIdentificationPanel.rowHeights = new int[5];
            gbl_nodeIdentificationPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
            gbl_nodeIdentificationPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.nodeIdentificationPanel.setLayout(gbl_nodeIdentificationPanel);
            GridBagConstraints gbc_separatorLabel = new GridBagConstraints();
            gbc_separatorLabel.anchor = 18;
            gbc_separatorLabel.insets = new Insets(0, 0, 5, 5);
            gbc_separatorLabel.gridx = 0;
            gbc_separatorLabel.gridy = 0;
            this.nodeIdentificationPanel.add((Component)this.getSeparatorLabel(), gbc_separatorLabel);
            GridBagConstraints gbc_separatorPanel = new GridBagConstraints();
            gbc_separatorPanel.fill = 2;
            gbc_separatorPanel.weighty = 1.0;
            gbc_separatorPanel.insets = new Insets(0, 0, 5, 0);
            gbc_separatorPanel.gridx = 1;
            gbc_separatorPanel.gridy = 0;
            this.nodeIdentificationPanel.add((Component)this.getSeparatorPanel(), gbc_separatorPanel);
            GridBagConstraints gbc_linesToSkipLabel = new GridBagConstraints();
            gbc_linesToSkipLabel.anchor = 17;
            gbc_linesToSkipLabel.insets = new Insets(0, 0, 5, 5);
            gbc_linesToSkipLabel.gridx = 0;
            gbc_linesToSkipLabel.gridy = 1;
            this.nodeIdentificationPanel.add((Component)this.getLinesToSkipLabel(), gbc_linesToSkipLabel);
            GridBagConstraints gbc_linesToSkipSpinner = new GridBagConstraints();
            gbc_linesToSkipSpinner.fill = 2;
            gbc_linesToSkipSpinner.insets = new Insets(0, 0, 5, 0);
            gbc_linesToSkipSpinner.gridx = 1;
            gbc_linesToSkipSpinner.gridy = 1;
            this.nodeIdentificationPanel.add((Component)this.getLinesToSkipSpinner(), gbc_linesToSkipSpinner);
            GridBagConstraints gbc_columnHeadingsCheckBox = new GridBagConstraints();
            gbc_columnHeadingsCheckBox.insets = new Insets(0, 0, 5, 0);
            gbc_columnHeadingsCheckBox.gridwidth = 2;
            gbc_columnHeadingsCheckBox.anchor = 17;
            gbc_columnHeadingsCheckBox.gridx = 0;
            gbc_columnHeadingsCheckBox.gridy = 2;
            this.nodeIdentificationPanel.add((Component)this.getColumnHeadingsCheckBox(), gbc_columnHeadingsCheckBox);
        }
        return this.nodeIdentificationPanel;
    }

    private JLabel getSeparatorLabel() {
        if (this.separatorLabel == null) {
            this.separatorLabel = new JLabel("Values separated by: ");
        }
        return this.separatorLabel;
    }

    private JLabel getLinesToSkipLabel() {
        if (this.linesToSkipLabel == null) {
            this.linesToSkipLabel = new JLabel("Number of lines to skip before heading or data:");
        }
        return this.linesToSkipLabel;
    }

    private JCheckBox getColumnHeadingsCheckBox() {
        if (this.columnHeadingsCheckBox == null) {
            this.columnHeadingsCheckBox = new JCheckBox("First line (after skipped lines) contains column headings");
        }
        return this.columnHeadingsCheckBox;
    }

    private JSpinner getLinesToSkipSpinner() {
        if (this.linesToSkipSpinner == null) {
            this.linesToSkipSpinner = new JSpinner();
            this.linesToSkipSpinner.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        }
        return this.linesToSkipSpinner;
    }
}

