/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.imexporttable;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableData;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableParameters;
import info.bioinfweb.treegraph.gui.dialogs.CompareTextElementDataParametersPanel;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class KeyColumnDialog
extends OkCancelApplyWikiHelpDialog {
    private JPanel jContentPane = null;
    private JPanel treeColumnPanel;
    private NodeBranchDataInput keyColumnInput;
    private JLabel nodeIdentifierLabel;
    private CompareTextElementDataParametersPanel textElementDataParametersPanel;
    private JPanel tableColumnPanel;
    private JLabel lblSelectTheColumns;
    private JComboBox<String> tableColumnComboBox;

    public KeyColumnDialog(Frame owner) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    public void assignParameters(ImportTableParameters parameters) {
        parameters.setKeyAdapter(this.getKeyColumnInput().getSelectedAdapter());
        this.getTextElementDataParametersPanel().assignToParameters(parameters);
    }

    public int getSelectedTableKeyColumn() {
        return this.getTableColumnComboBox().getSelectedIndex();
    }

    private void setTableColumns(ImportTableData data) {
        this.getTableColumnComboBoxModel().removeAllElements();
        int column = 0;
        while (column < data.columnCount()) {
            this.getTableColumnComboBoxModel().addElement(String.valueOf(column) + ") " + data.getHeading(column));
            ++column;
        }
    }

    public boolean execute(Document document, ImportTableData data) {
        this.getKeyColumnInput().setAdapters(document.getTree(), true, true, true, false, false, "");
        this.getKeyColumnInput().setSelectedAdapter(document.getDefaultLeafAdapter());
        this.setTableColumns(data);
        return this.execute();
    }

    protected boolean apply() {
        return true;
    }

    private void initialize() {
        this.setHelpCode(87);
        this.setTitle("Select matching key columns in the table and the tree");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add(this.getTableColumnPanel());
            this.jContentPane.add(this.getTreeColumnPanel());
            this.jContentPane.add(this.getTextElementDataParametersPanel());
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
            this.getApplyButton().setVisible(false);
            this.getOkButton().setText("Next >");
        }
        return this.jContentPane;
    }

    private JLabel getNodeIdentifierLabel() {
        if (this.nodeIdentifierLabel == null) {
            this.nodeIdentifierLabel = new JLabel("Select a node/branch data column of the tree that contains the same values as a column of the table:");
        }
        return this.nodeIdentifierLabel;
    }

    private NodeBranchDataInput getKeyColumnInput() {
        if (this.keyColumnInput == null) {
            this.getTreeColumnPanel();
        }
        return this.keyColumnInput;
    }

    private CompareTextElementDataParametersPanel getTextElementDataParametersPanel() {
        if (this.textElementDataParametersPanel == null) {
            this.textElementDataParametersPanel = new CompareTextElementDataParametersPanel();
            this.textElementDataParametersPanel.setBorder(new TitledBorder(null, "Compare options", 4, 2, null, null));
        }
        return this.textElementDataParametersPanel;
    }

    private JPanel getTreeColumnPanel() {
        if (this.treeColumnPanel == null) {
            this.treeColumnPanel = new JPanel();
            this.treeColumnPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Key column in tree", 4, 2, null, null));
            GridBagLayout gbl_treeColumnPanel = new GridBagLayout();
            this.treeColumnPanel.setLayout(gbl_treeColumnPanel);
            this.keyColumnInput = new NodeBranchDataInput(this.treeColumnPanel, 0, 1);
            GridBagConstraints gbc_nodeIdentifierLabel = new GridBagConstraints();
            gbc_nodeIdentifierLabel.weighty = 1.0;
            gbc_nodeIdentifierLabel.anchor = 17;
            gbc_nodeIdentifierLabel.insets = new Insets(0, 0, 5, 0);
            gbc_nodeIdentifierLabel.gridx = 0;
            gbc_nodeIdentifierLabel.gridy = 0;
            this.treeColumnPanel.add((Component)this.getNodeIdentifierLabel(), gbc_nodeIdentifierLabel);
        }
        return this.treeColumnPanel;
    }

    private JPanel getTableColumnPanel() {
        if (this.tableColumnPanel == null) {
            this.tableColumnPanel = new JPanel();
            this.tableColumnPanel.setBorder(new TitledBorder(null, "Key column in table", 4, 2, null, null));
            GridBagLayout gbl_tableColumnPanel = new GridBagLayout();
            this.tableColumnPanel.setLayout(gbl_tableColumnPanel);
            GridBagConstraints gbc_lblSelectTheColumns = new GridBagConstraints();
            gbc_lblSelectTheColumns.insets = new Insets(0, 0, 5, 0);
            gbc_lblSelectTheColumns.gridx = 0;
            gbc_lblSelectTheColumns.gridy = 0;
            this.tableColumnPanel.add((Component)this.getLblSelectTheColumns(), gbc_lblSelectTheColumns);
            GridBagConstraints gbc_tableColumnComboBox = new GridBagConstraints();
            gbc_tableColumnComboBox.fill = 2;
            gbc_tableColumnComboBox.gridx = 0;
            gbc_tableColumnComboBox.gridy = 1;
            this.tableColumnPanel.add(this.getTableColumnComboBox(), gbc_tableColumnComboBox);
        }
        return this.tableColumnPanel;
    }

    private JLabel getLblSelectTheColumns() {
        if (this.lblSelectTheColumns == null) {
            this.lblSelectTheColumns = new JLabel("Select the column of the table that contains the same values as a node/branch data column of the tree:");
        }
        return this.lblSelectTheColumns;
    }

    private JComboBox<String> getTableColumnComboBox() {
        if (this.tableColumnComboBox == null) {
            this.tableColumnComboBox = new JComboBox(new DefaultComboBoxModel());
        }
        return this.tableColumnComboBox;
    }

    private DefaultComboBoxModel<String> getTableColumnComboBoxModel() {
        return (DefaultComboBoxModel)this.getTableColumnComboBox().getModel();
    }
}

