/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.imexporttable;

import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.imexporttable.ExportNodeDataTableModel;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportTableDialog
extends EditDialog {
    public static final String EXPORT_FILE_EXT = "txt";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel nodeDataPanel = null;
    private NodeBranchDataInput nodeDataInput = null;
    private JScrollPane tableScrollPane = null;
    private JTable table = null;
    private JPanel nodeDataButtonsPanel = null;
    private JButton addButton = null;
    private JButton replaceButton = null;
    private JButton removeButton = null;
    private JButton clearButton = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private JPanel filePanel = null;
    private JTextField fileTextField = null;
    private JButton fileButton = null;
    private JFileChooser fileChooser = null;
    private JPanel headingsPanel = null;
    private JCheckBox exportHeadingsCheckBox = null;
    private JPanel nodesPanel = null;
    private ButtonGroup nodesGroup = null;
    private JRadioButton internalsRadioButton = null;
    private JRadioButton leavesRadioButton = null;
    private JRadioButton bothRadioButton = null;
    private JCheckBox chckbxReplaceSpacesBy;
    private JButton addAllButton;

    public ExportTableDialog(Frame owner) {
        super(owner);
        this.setHelpCode(67);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        this.getNodeDataInput().setAdapters(this.getDocument().getTree(), true, true, true, false, false, "");
        this.setButtonStatus();
        return true;
    }

    protected boolean apply() {
        File file = new File(this.getFileTextField().getText());
        boolean write = true;
        if (file.exists()) {
            boolean bl = write = JOptionPane.showConfirmDialog((Component)((Object)this), "The file \"" + this.getFileTextField().getText() + "\" already exists.\n Do you want to overwrite it?", "Warning", 0, 2) == 0;
        }
        if (write) {
            try {
                NodeType nodeType = NodeType.BOTH;
                if (this.getInternalsRadioButton().isSelected()) {
                    nodeType = NodeType.INTERNAL_NODES;
                } else if (this.getLeavesRadioButton().isSelected()) {
                    nodeType = NodeType.LEAVES;
                }
                boolean exportHeadings = this.getExportHeadingsCheckBox().isSelected();
                boolean replaceSpaces = this.getChckbxReplaceSpacesBy().isSelected();
                this.getTableModel().writeData(file, this.getDocument().getTree().getPaintStart(), nodeType, exportHeadings, replaceSpaces);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The path \"" + this.getFileTextField().getText() + "\" is invalid.", "Error", 0);
                return false;
            }
            catch (SecurityException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The permission for writing to the file \"" + this.getFileTextField().getText() + "\" was denied.", "Error", 0);
                return false;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The error \"" + e.getMessage() + "\" occured when writing to the file \"" + this.getFileTextField().getText() + "\".", "Error", 0);
                return false;
            }
        }
        return write;
    }

    private void setButtonStatus() {
        boolean enabled = this.getTableModel().size() > 0;
        this.getReplaceButton().setEnabled(enabled);
        this.getRemoveButton().setEnabled(enabled);
        this.getClearButton().setEnabled(enabled);
        enabled = this.getTableModel().size() >= 2;
        this.getUpButton().setEnabled(enabled && this.getTable().getSelectedRow() > 0);
        this.getDownButton().setEnabled(enabled && this.getTable().getSelectedRow() < this.getTableModel().size() - 1);
    }

    private ExportNodeDataTableModel getTableModel() {
        return (ExportNodeDataTableModel)this.getTable().getModel();
    }

    private void initialize() {
        this.setTitle("Export node/branch data");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private NodeBranchDataInput getNodeDataInput() {
        this.getNodeDataPanel();
        return this.nodeDataInput;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getNodeDataPanel(), null);
            this.jContentPane.add((Component)this.getHeadingsPanel(), null);
            this.jContentPane.add((Component)this.getNodesPanel(), null);
            this.jContentPane.add((Component)this.getFilePanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
            this.getApplyButton().setVisible(false);
        }
        return this.jContentPane;
    }

    private JPanel getNodeDataPanel() {
        if (this.nodeDataPanel == null) {
            GridBagConstraints tableGBC = new GridBagConstraints();
            tableGBC.fill = 1;
            tableGBC.gridy = 1;
            tableGBC.weightx = 1.0;
            tableGBC.weighty = 1.0;
            tableGBC.gridheight = 2;
            tableGBC.gridx = 0;
            GridBagConstraints buttonsGBC = new GridBagConstraints();
            buttonsGBC.gridx = 1;
            buttonsGBC.gridheight = 2;
            buttonsGBC.anchor = 11;
            buttonsGBC.fill = 2;
            buttonsGBC.gridy = 0;
            this.nodeDataPanel = new JPanel();
            this.nodeDataPanel.setLayout(new GridBagLayout());
            this.nodeDataPanel.setBorder(BorderFactory.createTitledBorder(null, "Columns to export", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.nodeDataInput = new NodeBranchDataInput(this.nodeDataPanel, 0, 0);
            this.nodeDataPanel.add((Component)this.getTableScrollPane(), tableGBC);
            this.nodeDataPanel.add((Component)this.getNodeDataButtonsPanel(), buttonsGBC);
        }
        return this.nodeDataPanel;
    }

    private JPanel getNodeDataButtonsPanel() {
        if (this.nodeDataButtonsPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints6.gridy = 6;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(0, 4, 6, 4);
            gridBagConstraints5.gridy = 5;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(0, 4, 16, 4);
            gridBagConstraints4.gridy = 4;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(0, 4, 6, 4);
            gridBagConstraints3.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 4, 16, 4);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 4, 6, 4);
            gridBagConstraints1.gridy = 0;
            this.nodeDataButtonsPanel = new JPanel();
            this.nodeDataButtonsPanel.setLayout(new GridBagLayout());
            this.nodeDataButtonsPanel.add((Component)this.getAddButton(), gridBagConstraints1);
            this.nodeDataButtonsPanel.add((Component)this.getReplaceButton(), gridBagConstraints2);
            GridBagConstraints gbc_btnAddAll = new GridBagConstraints();
            gbc_btnAddAll.fill = 2;
            gbc_btnAddAll.insets = new Insets(0, 4, 16, 4);
            gbc_btnAddAll.gridx = 0;
            gbc_btnAddAll.gridy = 2;
            this.nodeDataButtonsPanel.add((Component)this.getAddAllButton(), gbc_btnAddAll);
            this.nodeDataButtonsPanel.add((Component)this.getRemoveButton(), gridBagConstraints3);
            this.nodeDataButtonsPanel.add((Component)this.getUpButton(), gridBagConstraints5);
            this.nodeDataButtonsPanel.add((Component)this.getClearButton(), gridBagConstraints4);
            this.nodeDataButtonsPanel.add((Component)this.getDownButton(), gridBagConstraints6);
        }
        return this.nodeDataButtonsPanel;
    }

    private JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane();
            this.tableScrollPane.setViewportView(this.getTable());
        }
        return this.tableScrollPane;
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new JTable(new ExportNodeDataTableModel());
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExportTableDialog.this.setButtonStatus();
                }
            });
        }
        return this.table;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportTableDialog.this.getTableModel().add(ExportTableDialog.this.getNodeDataInput().getSelectedAdapter());
                    int sel = ExportTableDialog.this.getTableModel().size() - 1;
                    ExportTableDialog.this.getTable().getSelectionModel().setSelectionInterval(sel, sel);
                }
            });
        }
        return this.addButton;
    }

    private JButton getReplaceButton() {
        if (this.replaceButton == null) {
            this.replaceButton = new JButton();
            this.replaceButton.setText("Replace");
            this.replaceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int replacedIndex = ExportTableDialog.this.getTable().getSelectedRow();
                    ExportTableDialog.this.getTableModel().set(replacedIndex, ExportTableDialog.this.getNodeDataInput().getSelectedAdapter());
                    int[] rows = ExportTableDialog.this.getTable().getSelectedRows();
                    int i = 0;
                    while (i < rows.length) {
                        if (rows[i] != replacedIndex) {
                            ExportTableDialog.this.getTableModel().remove(rows[i]);
                        }
                        ++i;
                    }
                }
            });
        }
        return this.replaceButton;
    }

    private JButton getAddAllButton() {
        if (this.addAllButton == null) {
            this.addAllButton = new JButton("Add all");
            this.addAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int start = ExportTableDialog.this.getTableModel().size() - 1;
                    ExportTableDialog.this.getTableModel().addAll(ExportTableDialog.this.getNodeDataInput().getModel().getAdapters());
                    ExportTableDialog.this.getTable().getSelectionModel().setSelectionInterval(start, ExportTableDialog.this.getTableModel().size() - 1);
                }
            });
        }
        return this.addAllButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = ExportTableDialog.this.getTable().getSelectedRows();
                    int i = 0;
                    while (i < rows.length) {
                        ExportTableDialog.this.getTableModel().remove(rows[i]);
                        ++i;
                    }
                }
            });
        }
        return this.removeButton;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("Clear");
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportTableDialog.this.getTableModel().clear();
                }
            });
        }
        return this.clearButton;
    }

    private JButton getUpButton() {
        if (this.upButton == null) {
            this.upButton = new JButton();
            this.upButton.setText("Move up");
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = ExportTableDialog.this.getTable().getSelectedRows();
                    int i = 0;
                    while (i < rows.length) {
                        ExportTableDialog.this.getTableModel().moveUp(rows[i]);
                        ++i;
                    }
                    ExportTableDialog.this.getTable().getSelectionModel().clearSelection();
                    i = 0;
                    while (i < rows.length) {
                        ExportTableDialog.this.getTable().getSelectionModel().addSelectionInterval(rows[i] - 1, rows[i] - 1);
                        ++i;
                    }
                }
            });
        }
        return this.upButton;
    }

    private JButton getDownButton() {
        if (this.downButton == null) {
            this.downButton = new JButton();
            this.downButton.setText("Move down");
            this.downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = ExportTableDialog.this.getTable().getSelectedRows();
                    int i = rows.length - 1;
                    while (i >= 0) {
                        ExportTableDialog.this.getTableModel().moveDown(rows[i]);
                        --i;
                    }
                    ExportTableDialog.this.getTable().getSelectionModel().clearSelection();
                    i = 0;
                    while (i < rows.length) {
                        ExportTableDialog.this.getTable().getSelectionModel().addSelectionInterval(rows[i] + 1, rows[i] + 1);
                        ++i;
                    }
                }
            });
        }
        return this.downButton;
    }

    private JPanel getFilePanel() {
        if (this.filePanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.insets = new Insets(0, 4, 0, 4);
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(0, 4, 0, 4);
            gridBagConstraints7.gridx = 0;
            this.filePanel = new JPanel();
            this.filePanel.setLayout(new GridBagLayout());
            this.filePanel.setBorder(BorderFactory.createTitledBorder(null, "Destination file", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.filePanel.add((Component)this.getFileTextField(), gridBagConstraints7);
            this.filePanel.add((Component)this.getFileButton(), gridBagConstraints8);
        }
        return this.filePanel;
    }

    private JTextField getFileTextField() {
        if (this.fileTextField == null) {
            this.fileTextField = new JTextField();
        }
        return this.fileTextField;
    }

    private JButton getFileButton() {
        if (this.fileButton == null) {
            this.fileButton = new JButton();
            this.fileButton.setText("...");
            this.fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportTableDialog.this.getFileChooser().setSelectedFile(new File(ExportTableDialog.this.getFileTextField().getText()));
                    if (ExportTableDialog.this.getFileChooser().showSaveDialog(MainFrame.getInstance()) == 0) {
                        String path = ExportTableDialog.this.getFileChooser().getSelectedFile().getAbsolutePath();
                        if (!path.endsWith(".txt")) {
                            path = String.valueOf(path) + ".txt";
                        }
                        ExportTableDialog.this.getFileTextField().setText(path);
                    }
                }
            });
        }
        return this.fileButton;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileFilter(new FileNameExtensionFilter("Text files", EXPORT_FILE_EXT));
            CurrentDirectoryModel.getInstance().addFileChooser(this.fileChooser);
        }
        return this.fileChooser;
    }

    private JPanel getHeadingsPanel() {
        if (this.headingsPanel == null) {
            this.headingsPanel = new JPanel();
            this.headingsPanel.setLayout(new GridBagLayout());
            this.headingsPanel.setBorder(BorderFactory.createTitledBorder(null, "Table settings", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            GridBagConstraints gbc_exportHeadingsCheckBox = new GridBagConstraints();
            gbc_exportHeadingsCheckBox.insets = new Insets(0, 0, 0, 5);
            gbc_exportHeadingsCheckBox.weightx = 1.0;
            gbc_exportHeadingsCheckBox.anchor = 17;
            gbc_exportHeadingsCheckBox.gridx = 0;
            gbc_exportHeadingsCheckBox.gridy = 0;
            this.headingsPanel.add((Component)this.getExportHeadingsCheckBox(), gbc_exportHeadingsCheckBox);
            GridBagConstraints gbc_chckbxReplaceSpacesBy = new GridBagConstraints();
            gbc_chckbxReplaceSpacesBy.insets = new Insets(0, 0, 0, 5);
            gbc_chckbxReplaceSpacesBy.weightx = 1.0;
            gbc_chckbxReplaceSpacesBy.anchor = 17;
            gbc_chckbxReplaceSpacesBy.gridx = 1;
            gbc_chckbxReplaceSpacesBy.gridy = 0;
            this.headingsPanel.add((Component)this.getChckbxReplaceSpacesBy(), gbc_chckbxReplaceSpacesBy);
        }
        return this.headingsPanel;
    }

    private JCheckBox getExportHeadingsCheckBox() {
        if (this.exportHeadingsCheckBox == null) {
            this.exportHeadingsCheckBox = new JCheckBox();
            this.exportHeadingsCheckBox.setText("Export column headings");
            this.exportHeadingsCheckBox.setSelected(true);
        }
        return this.exportHeadingsCheckBox;
    }

    private JCheckBox getChckbxReplaceSpacesBy() {
        if (this.chckbxReplaceSpacesBy == null) {
            this.chckbxReplaceSpacesBy = new JCheckBox("Replace spaces in node names with underscores");
        }
        return this.chckbxReplaceSpacesBy;
    }

    private JPanel getNodesPanel() {
        if (this.nodesPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.fill = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.gridy = 0;
            this.nodesPanel = new JPanel();
            this.nodesPanel.setLayout(new GridBagLayout());
            this.nodesPanel.setBorder(BorderFactory.createTitledBorder(null, "Nodes to export", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.getNodesGroup();
            this.nodesPanel.add((Component)this.getInternalsRadioButton(), gridBagConstraints9);
            this.nodesPanel.add((Component)this.getLeavesRadioButton(), gridBagConstraints10);
            this.nodesPanel.add((Component)this.getBothRadioButton(), gridBagConstraints11);
        }
        return this.nodesPanel;
    }

    private ButtonGroup getNodesGroup() {
        if (this.nodesGroup == null) {
            this.nodesGroup = new ButtonGroup();
            this.nodesGroup.add(this.getInternalsRadioButton());
            this.nodesGroup.add(this.getLeavesRadioButton());
            this.nodesGroup.add(this.getBothRadioButton());
        }
        return this.nodesGroup;
    }

    private JRadioButton getInternalsRadioButton() {
        if (this.internalsRadioButton == null) {
            this.internalsRadioButton = new JRadioButton();
            this.internalsRadioButton.setText("Internal nodes");
        }
        return this.internalsRadioButton;
    }

    private JRadioButton getLeavesRadioButton() {
        if (this.leavesRadioButton == null) {
            this.leavesRadioButton = new JRadioButton();
            this.leavesRadioButton.setText("Terminal nodes");
        }
        return this.leavesRadioButton;
    }

    private JRadioButton getBothRadioButton() {
        if (this.bothRadioButton == null) {
            this.bothRadioButton = new JRadioButton();
            this.bothRadioButton.setText("All");
            this.bothRadioButton.setSelected(true);
        }
        return this.bothRadioButton;
    }
}

