/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.imexporttable;

import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.io.ancestralstate.BayesTraitsCommandsWriter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ExportNodeDataTableModel
extends AbstractTableModel {
    private Vector<NodeBranchDataAdapter> adapters = new Vector();
    private NodeType nodeType = null;
    private OutputStreamWriter writer = null;

    public NodeBranchDataAdapter get(int index) {
        return this.adapters.get(index);
    }

    public boolean add(NodeBranchDataAdapter adapter) {
        boolean result = this.adapters.add(adapter);
        if (result) {
            int index = this.size() - 1;
            this.fireTableRowsInserted(index, index);
        }
        return result;
    }

    public boolean addAll(Collection<? extends NodeBranchDataAdapter> otherAdapters) {
        int start = this.adapters.size() - 1;
        boolean result = this.adapters.addAll(otherAdapters);
        if (result) {
            this.fireTableRowsInserted(start, this.size() - 1);
        }
        return result;
    }

    public NodeBranchDataAdapter set(int index, NodeBranchDataAdapter adapter) {
        if (index >= 0 && index < this.size()) {
            NodeBranchDataAdapter result = this.adapters.set(index, adapter);
            if (result != null) {
                this.fireTableRowsUpdated(index, index);
            }
            return result;
        }
        throw new IllegalArgumentException("The index " + index + " is not valid.");
    }

    public NodeBranchDataAdapter remove(int index) {
        if (index >= 0 && index < this.size()) {
            NodeBranchDataAdapter result = this.adapters.remove(index);
            if (result != null) {
                this.fireTableRowsDeleted(index, index);
            }
            return result;
        }
        throw new IllegalArgumentException("The index " + index + " is not valid.");
    }

    public void clear() {
        this.adapters.clear();
        this.fireTableStructureChanged();
    }

    public boolean moveUp(int index) {
        if (index >= 1 && index < this.size()) {
            NodeBranchDataAdapter save = this.get(index - 1);
            this.set(index - 1, this.get(index));
            this.set(index, save);
            this.fireTableRowsUpdated(index - 1, index);
            return true;
        }
        return false;
    }

    public boolean moveDown(int index) {
        if (index >= 0 && index < this.size() - 1) {
            NodeBranchDataAdapter save = this.get(index + 1);
            this.set(index + 1, this.get(index));
            this.set(index, save);
            this.fireTableRowsUpdated(index, index + 1);
            return true;
        }
        return false;
    }

    public int size() {
        return this.adapters.size();
    }

    public boolean isEmpty() {
        return this.adapters.isEmpty();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Column";
        }
        return "Data";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.adapters.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return "" + row;
        }
        return this.adapters.get(row).toString();
    }

    private String getValue(NodeBranchDataAdapter adapter, Node node, boolean replaceSpaces) {
        if (adapter.isString(node)) {
            String nodeName = adapter.getText(node);
            if (replaceSpaces && nodeName.contains(" ")) {
                return nodeName.replaceAll(" ", "_");
            }
            return nodeName;
        }
        if (adapter.isDecimal(node)) {
            return BayesTraitsCommandsWriter.DECIMAL_INTEGER_FORMAT.format(adapter.getDecimal(node));
        }
        return "";
    }

    private void writeSubtree(Node root, boolean replaceSpaces) throws IOException {
        if (root.isLeaf() && !this.nodeType.equals((Object)NodeType.INTERNAL_NODES) || !root.isLeaf() && !this.nodeType.equals((Object)NodeType.LEAVES)) {
            String line = "";
            if (this.adapters.size() > 0) {
                int i = 0;
                while (i < this.adapters.size() - 1) {
                    line = String.valueOf(line) + this.getValue(this.adapters.get(i), root, replaceSpaces) + "\t";
                    ++i;
                }
                line = String.valueOf(line) + this.getValue(this.adapters.get(this.adapters.size() - 1), root, replaceSpaces) + System.getProperty("line.separator");
            }
            this.writer.write(line);
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            this.writeSubtree(root.getChildren().get(i), replaceSpaces);
            ++i;
        }
    }

    public void writeData(OutputStream stream, Node root, NodeType nodeType, boolean exportHeadings, boolean replaceSpaces) throws IOException {
        this.writer = new OutputStreamWriter(stream);
        this.nodeType = nodeType;
        try {
            if (exportHeadings) {
                String headings = "";
                if (this.adapters.size() > 0) {
                    int i = 0;
                    while (i < this.adapters.size() - 1) {
                        headings = String.valueOf(headings) + this.adapters.get(i).toString() + "\t";
                        ++i;
                    }
                    headings = String.valueOf(headings) + this.adapters.get(this.adapters.size() - 1).toString() + System.getProperty("line.separator");
                }
                this.writer.write(headings);
            }
            this.writeSubtree(root, replaceSpaces);
        }
        finally {
            this.writer.close();
        }
    }

    public void writeData(File file, Node root, NodeType nodeType, boolean exportHeadings, boolean replaceSpaces) throws FileNotFoundException, IOException {
        this.writeData(new FileOutputStream(file), root, nodeType, exportHeadings, replaceSpaces);
    }
}

