/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.exporttree;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttree.NewickFormatPanel;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttree.TreeFormatPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class NexusFormatPanel
extends NewickFormatPanel
implements TreeFormatPanel {
    private JPanel nexusOptionsPanel = null;
    private JCheckBox exportTaxaTable = null;
    private JCheckBox useTranslTable = null;

    public NexusFormatPanel() {
        this.initialize();
    }

    @Override
    public void addProperties(ParameterMap properties) {
        super.addProperties(properties);
        properties.put("exportTaxaBlock", this.exportTaxaTable.isSelected());
        properties.put("useTranslTable", this.useTranslTable.isSelected());
    }

    @Override
    public void initializeContents(Document document) {
        super.initializeContents(document);
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getNodeNameFormatPanel());
        this.add(this.getNexusOptionsPanel());
        this.add(this.getSourceDataPanel());
        this.exportTaxaTable.setSelected(true);
        this.useTranslTable.setSelected(true);
    }

    private JPanel getNexusOptionsPanel() {
        if (this.nexusOptionsPanel == null) {
            this.nexusOptionsPanel = new JPanel();
            this.nexusOptionsPanel.setLayout(new GridBagLayout());
            this.nexusOptionsPanel.setBorder(new TitledBorder(null, "Nexus file components", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            GridBagConstraints gbc_exportTaxaTable = new GridBagConstraints();
            gbc_exportTaxaTable.gridx = 0;
            gbc_exportTaxaTable.anchor = 17;
            gbc_exportTaxaTable.gridy = 0;
            gbc_exportTaxaTable.weightx = 1.0;
            this.exportTaxaTable = new JCheckBox();
            this.exportTaxaTable.setText("Export taxa block");
            GridBagConstraints gbc_useTranslTable = new GridBagConstraints();
            gbc_useTranslTable.gridx = 1;
            gbc_useTranslTable.anchor = 17;
            gbc_useTranslTable.insets = new Insets(0, 0, 0, 0);
            gbc_useTranslTable.gridy = 0;
            gbc_useTranslTable.weightx = 1.0;
            this.useTranslTable = new JCheckBox();
            this.useTranslTable.setText("Use translation table");
            this.nexusOptionsPanel.add((Component)this.exportTaxaTable, gbc_exportTaxaTable);
            this.nexusOptionsPanel.add((Component)this.useTranslTable, gbc_useTranslTable);
        }
        return this.nexusOptionsPanel;
    }
}

