/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.exporttree;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttree.TreeFormatPanel;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class NewickFormatPanel
extends JPanel
implements TreeFormatPanel {
    private JPanel sourceDataPanel = null;
    private NodeBranchDataInput internalInput = null;
    private NodeBranchDataInput leafInput = null;
    private NodeBranchDataInput branchLengthInput = null;
    private JLabel internalLabel = null;
    private JLabel leafLabel = null;
    private JLabel branchLengthLabel = null;
    private JPanel nodeNameFormatPanel;
    private JRadioButton singleQuotationRadioButton;
    private JRadioButton spacesAsUnderscoresRadioButton;
    private final ButtonGroup nodeNameFormatButtonGroup = new ButtonGroup();
    private JLabel lblPressTheHelp;

    public NewickFormatPanel() {
        this.initialize();
    }

    @Override
    public void addProperties(ParameterMap properties) {
        properties.put("spacesAsUnderscore", this.getSpacesAsUnderscoresRadioButton().isSelected());
        properties.put("internalNodeNamesAdapter", this.getInternalInput().getSelectedAdapter());
        properties.put("leafNodeNamesAdapter", this.getLeafInput().getSelectedAdapter());
        properties.put("branchLengthAdapter", this.getBranchLengthInput().getSelectedAdapter());
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getNodeNameFormatPanel());
        this.add(this.getSourceDataPanel());
    }

    @Override
    public void initializeContents(Document document) {
        if (document != null) {
            this.getInternalInput().setAdapters(document.getTree(), true, true, true, false, false, "Do not export internal node names");
            if (!this.getInternalInput().setSelectedAdapter(TextLabelAdapter.class) && !this.getInternalInput().setSelectedAdapter(HiddenDataAdapter.class)) {
                if (document.getDefaultSupportAdapter() instanceof VoidNodeBranchDataAdapter) {
                    this.getInternalInput().setSelectedAdapter(VoidNodeBranchDataAdapter.class);
                } else {
                    this.getInternalInput().setSelectedAdapter(document.getDefaultSupportAdapter());
                }
            }
            this.getLeafInput().setAdapters(document.getTree(), true, true, true, false, false, "");
            this.getLeafInput().setSelectedAdapter(document.getDefaultLeafAdapter());
            this.getBranchLengthInput().setAdapters(document.getTree(), false, false, true, true, false, "Do not export branch lengths");
            this.getBranchLengthInput().setSelectedAdapter(BranchLengthAdapter.class);
        }
    }

    protected JPanel getSourceDataPanel() {
        if (this.sourceDataPanel == null) {
            this.sourceDataPanel = new JPanel();
            this.sourceDataPanel.setLayout(new GridBagLayout());
            this.sourceDataPanel.setBorder(BorderFactory.createTitledBorder(null, "Source data", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            GridBagConstraints gbc_internalLabel = new GridBagConstraints();
            gbc_internalLabel.gridx = 0;
            gbc_internalLabel.anchor = 17;
            gbc_internalLabel.insets = new Insets(0, 2, 0, 0);
            gbc_internalLabel.gridy = 0;
            this.internalLabel = new JLabel();
            this.internalLabel.setText("Internal node names: ");
            this.sourceDataPanel.add((Component)this.internalLabel, gbc_internalLabel);
            this.internalInput = new NodeBranchDataInput(this.sourceDataPanel, 1, 0);
            GridBagConstraints gbc_leafLabel = new GridBagConstraints();
            gbc_leafLabel.gridx = 0;
            gbc_leafLabel.anchor = 17;
            gbc_leafLabel.insets = new Insets(0, 2, 0, 0);
            gbc_leafLabel.gridy = 1;
            this.leafLabel = new JLabel();
            this.leafLabel.setText("Leaf node names: ");
            this.sourceDataPanel.add((Component)this.leafLabel, gbc_leafLabel);
            this.leafInput = new NodeBranchDataInput(this.sourceDataPanel, 1, 1);
            GridBagConstraints gbc_branchLengthLabel = new GridBagConstraints();
            gbc_branchLengthLabel.anchor = 17;
            gbc_branchLengthLabel.gridx = 0;
            gbc_branchLengthLabel.gridy = 2;
            gbc_branchLengthLabel.insets = new Insets(0, 2, 0, 0);
            this.branchLengthLabel = new JLabel();
            this.branchLengthLabel.setText("Branch lengths: ");
            this.sourceDataPanel.add((Component)this.branchLengthLabel, gbc_branchLengthLabel);
            this.branchLengthInput = new NodeBranchDataInput(this.sourceDataPanel, 1, 2);
        }
        return this.sourceDataPanel;
    }

    public NodeBranchDataInput getInternalInput() {
        this.getSourceDataPanel();
        return this.internalInput;
    }

    public NodeBranchDataInput getLeafInput() {
        this.getSourceDataPanel();
        return this.leafInput;
    }

    public NodeBranchDataInput getBranchLengthInput() {
        this.getSourceDataPanel();
        return this.branchLengthInput;
    }

    protected JPanel getNodeNameFormatPanel() {
        if (this.nodeNameFormatPanel == null) {
            this.nodeNameFormatPanel = new JPanel();
            this.nodeNameFormatPanel.setBorder(new TitledBorder(null, "Node name format", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.nodeNameFormatPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_singleQuotationRadioButton = new GridBagConstraints();
            gbc_singleQuotationRadioButton.weightx = 1.0;
            gbc_singleQuotationRadioButton.fill = 2;
            gbc_singleQuotationRadioButton.insets = new Insets(0, 0, 5, 5);
            gbc_singleQuotationRadioButton.gridx = 0;
            gbc_singleQuotationRadioButton.gridy = 0;
            this.nodeNameFormatPanel.add((Component)this.getSingleQuotationRadioButton(), gbc_singleQuotationRadioButton);
            GridBagConstraints gbc_spacesAsUnderscoresRadioButton = new GridBagConstraints();
            gbc_spacesAsUnderscoresRadioButton.insets = new Insets(0, 0, 5, 0);
            gbc_spacesAsUnderscoresRadioButton.anchor = 13;
            gbc_spacesAsUnderscoresRadioButton.weightx = 1.0;
            gbc_spacesAsUnderscoresRadioButton.gridx = 1;
            gbc_spacesAsUnderscoresRadioButton.gridy = 0;
            this.nodeNameFormatPanel.add((Component)this.getSpacesAsUnderscoresRadioButton(), gbc_spacesAsUnderscoresRadioButton);
            GridBagConstraints gbc_lblPressTheHelp = new GridBagConstraints();
            gbc_lblPressTheHelp.gridwidth = 2;
            gbc_lblPressTheHelp.insets = new Insets(0, 0, 0, 5);
            gbc_lblPressTheHelp.gridx = 0;
            gbc_lblPressTheHelp.gridy = 1;
            this.nodeNameFormatPanel.add((Component)this.getLblPressTheHelp(), gbc_lblPressTheHelp);
        }
        return this.nodeNameFormatPanel;
    }

    private JRadioButton getSingleQuotationRadioButton() {
        if (this.singleQuotationRadioButton == null) {
            this.singleQuotationRadioButton = new JRadioButton("Quotation marks if necessary");
            this.nodeNameFormatButtonGroup.add(this.singleQuotationRadioButton);
            this.singleQuotationRadioButton.setSelected(true);
        }
        return this.singleQuotationRadioButton;
    }

    private JRadioButton getSpacesAsUnderscoresRadioButton() {
        if (this.spacesAsUnderscoresRadioButton == null) {
            this.spacesAsUnderscoresRadioButton = new JRadioButton("Spaces as underscores, not quotation marks");
            this.nodeNameFormatButtonGroup.add(this.spacesAsUnderscoresRadioButton);
        }
        return this.spacesAsUnderscoresRadioButton;
    }

    private JLabel getLblPressTheHelp() {
        if (this.lblPressTheHelp == null) {
            this.lblPressTheHelp = new JLabel("Press the help button to understand the difference between these options.");
        }
        return this.lblPressTheHelp;
    }
}

