/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.exporttree;

import info.bioinfweb.treegraph.document.io.DocumentFilter;
import info.bioinfweb.treegraph.document.io.DocumentWriter;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.io.TreeFilter;
import info.bioinfweb.treegraph.document.io.nexus.NexusFilter;
import info.bioinfweb.treegraph.gui.dialogs.io.FileDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttree.AdditionalDataPanelFactory;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttree.TreeFormatPanel;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ExportToTreeDialog
extends FileDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JFileChooser fileChooser;
    private NexusFilter nexusFilter;
    private JPanel filePanel;
    private JPanel additionalDataOuterPanel;
    private TreeFormatPanel additionalDataPanel;

    public ExportToTreeDialog(Frame owner) {
        super(owner, FileDialog.Option.ASK_TO_OVERWRITE);
        this.initialize();
        this.setHelpCode(82);
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        String name = this.getDocument().getDefaultNameOrPath();
        if (name.endsWith(".xtg")) {
            name = name.substring(0, name.length() - ".xtg".length());
        }
        if (name.length() > 0) {
            this.getFileChooser().setSelectedFile(new File(name));
        }
        this.additionalDataPanel.initializeContents(this.getDocument());
        return true;
    }

    @Override
    protected File getSelectedFile() {
        DocumentFilter filter;
        File result = super.getSelectedFile();
        if (result != null && !(filter = (DocumentFilter)((Object)this.getFileChooser().getFileFilter())).validExtension(result.getAbsolutePath())) {
            result = new File(String.valueOf(result.getAbsolutePath()) + filter.getDefaultExtension());
        }
        return result;
    }

    @Override
    protected boolean onApply(File file) {
        DocumentWriter writer = ((DocumentFilter)((Object)this.getFileChooser().getFileFilter())).equals(this.nexusFilter) ? ReadWriteFactory.getInstance().getWriter(ReadWriteFormat.NEXUS) : ReadWriteFactory.getInstance().getWriter(ReadWriteFormat.NEWICK);
        try {
            ReadWriteParameterMap properties = new ReadWriteParameterMap();
            if (this.additionalDataPanel != null) {
                this.additionalDataPanel.addProperties(properties);
            }
            writer.write(this.getDocument(), file, properties);
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "An error occured when trying to write to the file \"" + file.getAbsolutePath() + "\".\nError message: \"" + e.getMessage() + "\"", "Error", 0);
            return false;
        }
    }

    private void initialize() {
        this.setTitle("Export to tree format");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add(this.getFilePanel());
            this.jContentPane.add(this.getAdditionalDataOuterPanel());
            this.getApplyButton().setVisible(false);
            this.getOkButton().setText("Export");
            this.jContentPane.add(this.getButtonsPanel());
        }
        return this.jContentPane;
    }

    private JPanel getFilePanel() {
        if (this.filePanel == null) {
            this.filePanel = new JPanel();
            this.filePanel.setBorder(BorderFactory.createTitledBorder(null, "File", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.filePanel.add(this.getFileChooser());
        }
        return this.filePanel;
    }

    @Override
    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setControlButtonsAreShown(false);
            if (this.fileChooser.getFileFilter() != null) {
                this.fileChooser.removeChoosableFileFilter(this.fileChooser.getFileFilter());
            }
            this.nexusFilter = new NexusFilter();
            this.fileChooser.addChoosableFileFilter(this.nexusFilter);
            this.fileChooser.addChoosableFileFilter(ReadWriteFactory.getInstance().getFilter(ReadWriteFormat.NEWICK));
            this.fileChooser.setFileFilter(this.nexusFilter);
            this.setAdditionalDataOuterPanel(this.nexusFilter.getFormat());
            this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("fileFilterChanged")) {
                        if (e.getNewValue() instanceof TreeFilter) {
                            ExportToTreeDialog.this.setAdditionalDataOuterPanel(((TreeFilter)e.getNewValue()).getFormat());
                        } else {
                            System.out.println("Null.");
                            ExportToTreeDialog.this.setAdditionalDataOuterPanel(null);
                        }
                    }
                }
            });
        }
        return this.fileChooser;
    }

    private JPanel getAdditionalDataOuterPanel() {
        if (this.additionalDataOuterPanel == null) {
            this.additionalDataOuterPanel = new JPanel();
            this.additionalDataOuterPanel.setLayout(new BoxLayout(this.additionalDataOuterPanel, 1));
        }
        return this.additionalDataOuterPanel;
    }

    private void setAdditionalDataOuterPanel(ReadWriteFormat format) {
        this.additionalDataPanel = null;
        if (format != null) {
            this.additionalDataPanel = AdditionalDataPanelFactory.getInstance().getPanel(format);
        }
        this.getAdditionalDataOuterPanel().removeAll();
        if (this.additionalDataPanel != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.getAdditionalDataOuterPanel().add((Component)((JComponent)((Object)this.additionalDataPanel)), gridBagConstraints);
            this.additionalDataPanel.initializeContents(this.getDocument());
            this.getAdditionalDataOuterPanel().setVisible(true);
        } else {
            this.getAdditionalDataOuterPanel().setVisible(false);
        }
        this.pack();
    }
}

