/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.exporttographic;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttographic.PreferencesPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class JPEGPrefPanel
extends JPanel
implements PreferencesPanel {
    private static final long serialVersionUID = 1L;
    private JLabel qualityLabel = null;
    private JSlider qualitySlider = null;
    private JLabel highestComprLabel = null;
    private JLabel bestQualityLabel = null;

    public JPEGPrefPanel() {
        this.initialize();
    }

    @Override
    public void addHints(ParameterMap hints) {
        hints.put("jpegCompression", new Float((float)this.getQualitySlider().getValue() / 100.0f));
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.gridy = 0;
        this.bestQualityLabel = new JLabel();
        this.bestQualityLabel.setText("best quality");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints3.gridy = 0;
        this.highestComprLabel = new JLabel();
        this.highestComprLabel.setText("highest compression");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        this.qualityLabel = new JLabel();
        this.qualityLabel.setText("Quality [%]: ");
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.qualityLabel, gridBagConstraints);
        this.add((Component)this.getQualitySlider(), gridBagConstraints1);
        this.add((Component)this.highestComprLabel, gridBagConstraints3);
        this.add((Component)this.bestQualityLabel, gridBagConstraints4);
    }

    private JSlider getQualitySlider() {
        if (this.qualitySlider == null) {
            this.qualitySlider = new JSlider();
            this.qualitySlider.setMinimum(0);
            this.qualitySlider.setMaximum(100);
            this.qualitySlider.setMajorTickSpacing(10);
            this.qualitySlider.setMinorTickSpacing(1);
            this.qualitySlider.setValue(80);
            this.qualitySlider.setPaintLabels(true);
            this.qualitySlider.setPaintTicks(true);
        }
        return this.qualitySlider;
    }
}

