/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.exporttographic;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.graphics.export.GraphicFilter;
import info.bioinfweb.treegraph.graphics.export.GraphicFormat;
import info.bioinfweb.treegraph.graphics.export.GraphicWriterFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.gui.dialogs.ResolutionInput;
import info.bioinfweb.treegraph.gui.dialogs.io.FileDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttographic.PreferencesPanel;
import info.bioinfweb.treegraph.gui.dialogs.io.exporttographic.PreferencesPanelFactory;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ExportToGraphicDialog
extends FileDialog {
    public static final String UNIT_MILLIMETERS = "mm";
    public static final String UNIT_POINTS = "pt";
    public static final String UNIT_PIXELS = "px";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel dimensionsPanel = null;
    private ResolutionInput resolutionInput = null;
    private JLabel widthLabel = null;
    private JLabel heightLabel = null;
    private JTextField widthTextField = null;
    private JTextField heightTextField = null;
    private JComboBox unitComboBox = null;
    private JLabel spacerLabel = null;
    private JFileChooser fileChooser;
    private JPanel fileChooserPanel;
    private JPanel outerPreferencesPanel;
    private JPanel commandPanel = null;
    private JRadioButton openRadioButton = null;
    private JRadioButton printRadioButton = null;
    private JRadioButton noneRadioButton = null;
    private ButtonGroup commandGroup = null;
    private int lastSelection = -1;
    private DecimalFormat decimalFormat = new DecimalFormat("##########.######");
    private float aspectRatio = 1.0f;
    private PreferencesPanel preferencesPanel;
    private TreeInternalFrame treeFrame = null;

    public ExportToGraphicDialog(Frame owner) {
        super(owner, FileDialog.Option.ASK_TO_OVERWRITE);
        this.initialize();
        this.setHelpCode(3);
        this.setLocationRelativeTo(owner);
    }

    @Override
    public boolean execute(Document document, TreeSelection selection, NodeBranchDataAdapter selectedAdapter) {
        throw new RuntimeException("This method cannot be called in this class. Call execute(TreeInternalFrame frame) instead.");
    }

    public boolean execute(TreeInternalFrame frame) {
        this.treeFrame = frame;
        DistanceDimension d = frame.getDocument().getTree().getPaintDimension(frame.getTreeViewPanel().getPainterType());
        this.getUnitComboBox().setSelectedItem(UNIT_MILLIMETERS);
        this.getWidthTextField().setText(this.decimalFormat.format(d.getWidth().getInMillimeters()));
        this.getHeightTextField().setText(this.decimalFormat.format(d.getHeight().getInMillimeters()));
        this.aspectRatio = d.getWidth().getInMillimeters() / d.getHeight().getInMillimeters();
        this.resolutionInput.getComboBox().setSelectedItem("pixel per mm");
        this.resolutionInput.setResolution(2.8346457f);
        this.lastSelection = this.getUnitComboBox().getSelectedIndex();
        return super.execute(frame.getDocument(), frame.getTreeViewPanel().getSelection(), frame.getSelectedAdapter());
    }

    @Override
    protected boolean onExecute() {
        String name = this.getDocument().getDefaultNameOrPath();
        if (name.endsWith(".xtg")) {
            name = name.substring(0, name.length() - ".xtg".length());
        }
        if (name.length() > 0) {
            this.getFileChooser().setSelectedFile(new File(name));
        }
        return true;
    }

    private float convertToPixels(String text) {
        float result = Math2.parseFloat(text);
        if (this.getUnitComboBox().getSelectedItem().equals(UNIT_POINTS)) {
            result = DistanceValue.pointsToMillimeters(result);
        }
        return result;
    }

    private float getImageWidth() {
        return this.convertToPixels(this.getWidthTextField().getText());
    }

    private float getImageHeight() {
        return this.convertToPixels(this.getHeightTextField().getText());
    }

    private float getPixelsPerMillimeter() {
        return this.resolutionInput.getPixelsPerMillimeter();
    }

    private boolean dimensionsInPixels() {
        return this.getUnitComboBox().getSelectedItem().equals(UNIT_PIXELS);
    }

    private GraphicFormat getFormat() {
        return ((GraphicFilter)this.getFileChooser().getFileFilter()).getFormat();
    }

    private ParameterMap getHints() {
        ParameterMap result = new ParameterMap();
        result.put("ppm", new Float(this.getPixelsPerMillimeter()));
        result.put("dimensionsInPixels", new Boolean(this.dimensionsInPixels()));
        result.put("width", new Float(this.getImageWidth()));
        result.put("height", new Float(this.getImageHeight()));
        if (this.preferencesPanel != null) {
            this.preferencesPanel.addHints(result);
        }
        return result;
    }

    @Override
    protected File getSelectedFile() {
        GraphicFilter filter;
        File result = this.fileChooser.getSelectedFile();
        if (result != null && !(filter = (GraphicFilter)this.getFileChooser().getFileFilter()).validExtension(result.getName())) {
            result = new File(String.valueOf(result.getAbsolutePath()) + filter.getDefaultExtension());
        }
        return result;
    }

    @Override
    protected boolean onApply(File file) {
        block15: {
            Cursor cursor = MainFrame.getInstance().getCursor();
            MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            try {
                try {
                    GraphicWriterFactory.getInstance().getWriter(this.getFormat()).write(this.getDocument(), PositionPaintFactory.getInstance().getPainter(this.treeFrame.getTreeViewPanel().getPainterType()), this.getHints(), file);
                    if (Desktop.isDesktopSupported()) {
                        try {
                            if (this.getOpenRadioButton().isSelected()) {
                                Desktop.getDesktop().open(file);
                            } else if (this.getPrintRadioButton().isSelected()) {
                                Desktop.getDesktop().print(file);
                            }
                            break block15;
                        }
                        catch (IOException e) {
                            String command = "open";
                            if (this.getPrintRadioButton().isSelected()) {
                                command = "print";
                            }
                            JOptionPane.showMessageDialog((Component)((Object)this), "The error \"" + e.getMessage() + "\" occured when trying to " + command + " the file \"" + file.getAbsolutePath() + "\".", "Error", 0);
                        }
                        break block15;
                    }
                    if (!this.getNoneRadioButton().isSelected()) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Your system does not support opening or printing files from here.", "Commands not supported", 0);
                    }
                }
                catch (OutOfMemoryError ex) {
                    WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)"There is not enough memory avialable. This may happen, when trying to create large raster images.\n\nYou can try to run TreeGraph with the following command line options for the Java Virtual Machine from the TreeGraph installation directory:\n\"java -Xms64m -Xmx1024m -jar TreeGraph.jar\"\n\nAlternatively you can export a high resolution SVG and convert the SVG to a raster graphic using a third party tool (e.g. Inkscape).", (WikiHelp)Main.getInstance().getWikiHelp(), (int)33);
                    MainFrame.getInstance().setCursor(cursor);
                    return false;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "The excpeption \"" + ex.getMessage() + "\" occurred when trying to write to the file \"" + file.getAbsolutePath() + "\".", "Error", 0);
                }
            }
            finally {
                MainFrame.getInstance().setCursor(cursor);
            }
        }
        return true;
    }

    private void convertValue(JTextField textField, ItemEvent e) {
        String result = "";
        float value = Math2.parseFloat(textField.getText());
        switch (this.lastSelection) {
            case 0: {
                if (e.getItem().equals(UNIT_POINTS)) {
                    result = this.decimalFormat.format(DistanceValue.millimetersToPoints(value));
                    break;
                }
                if (!e.getItem().equals(UNIT_PIXELS)) break;
                result = this.decimalFormat.format(this.resolutionInput.millimetersToPixels(value));
                break;
            }
            case 1: {
                value = DistanceValue.pointsToMillimeters(value);
                if (e.getItem().equals(UNIT_MILLIMETERS)) {
                    result = this.decimalFormat.format(value);
                    break;
                }
                if (!e.getItem().equals(UNIT_PIXELS)) break;
                result = this.decimalFormat.format(this.resolutionInput.millimetersToPixels(value));
                break;
            }
            case 2: {
                value = this.resolutionInput.pixelsToMillimeters(value);
                if (e.getItem().equals(UNIT_MILLIMETERS)) {
                    result = this.decimalFormat.format(value);
                    break;
                }
                if (!e.getItem().equals(UNIT_POINTS)) break;
                result = this.decimalFormat.format(DistanceValue.millimetersToPoints(value));
            }
        }
        textField.setText(result);
    }

    private void setPreferencesPanel(GraphicFormat format) {
        this.getOuterPreferencesPanel().removeAll();
        this.preferencesPanel = null;
        if (format != null) {
            this.preferencesPanel = PreferencesPanelFactory.getInstance().getPanel(format);
        }
        if (this.preferencesPanel != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.getOuterPreferencesPanel().add((Component)((JComponent)((Object)this.preferencesPanel)), gridBagConstraints);
            this.getOuterPreferencesPanel().setVisible(true);
        } else {
            this.getOuterPreferencesPanel().setVisible(false);
        }
        this.pack();
    }

    private void initialize() {
        this.setTitle("Export to graphic/ PDF");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getFileChooserPanel(), null);
            this.jContentPane.add((Component)this.getDimensionsPanel(), null);
            this.jContentPane.add((Component)this.getOuterPreferencesPanel(), null);
            this.jContentPane.add((Component)this.getCommandPanel(), null);
            this.getApplyButton().setVisible(false);
            this.getOkButton().setText("Export");
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getDimensionsPanel() {
        if (this.dimensionsPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 2;
            this.spacerLabel = new JLabel();
            this.spacerLabel.setText(" ");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridheight = 2;
            gridBagConstraints5.gridx = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            this.heightLabel = new JLabel();
            this.heightLabel.setText("Height: ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.widthLabel = new JLabel();
            this.widthLabel.setText("Width: ");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            this.dimensionsPanel = new JPanel();
            this.dimensionsPanel.setLayout(new GridBagLayout());
            this.dimensionsPanel.setBorder(BorderFactory.createTitledBorder(null, "Dimensions and resolution", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.dimensionsPanel.add((Component)this.widthLabel, gridBagConstraints);
            this.dimensionsPanel.add((Component)this.heightLabel, gridBagConstraints1);
            this.dimensionsPanel.add((Component)this.getWidthTextField(), gridBagConstraints2);
            this.dimensionsPanel.add((Component)this.getHeightTextField(), gridBagConstraints4);
            this.dimensionsPanel.add((Component)this.getUnitComboBox(), gridBagConstraints5);
            this.dimensionsPanel.add((Component)this.spacerLabel, gridBagConstraints11);
            this.resolutionInput = new ResolutionInput("Resolution: ", this.dimensionsPanel, 3);
        }
        return this.dimensionsPanel;
    }

    private JTextField getWidthTextField() {
        if (this.widthTextField == null) {
            this.widthTextField = new JTextField();
            this.widthTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        ExportToGraphicDialog.this.getHeightTextField().setText(ExportToGraphicDialog.this.decimalFormat.format(Math2.parseFloat(ExportToGraphicDialog.this.widthTextField.getText()) / ExportToGraphicDialog.this.aspectRatio));
                    }
                    catch (NumberFormatException ex) {
                        ExportToGraphicDialog.this.getHeightTextField().setText("");
                    }
                }
            });
        }
        return this.widthTextField;
    }

    private JTextField getHeightTextField() {
        if (this.heightTextField == null) {
            this.heightTextField = new JTextField();
            this.heightTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        ExportToGraphicDialog.this.getWidthTextField().setText(ExportToGraphicDialog.this.decimalFormat.format(Math2.parseFloat(ExportToGraphicDialog.this.heightTextField.getText()) * ExportToGraphicDialog.this.aspectRatio));
                    }
                    catch (NumberFormatException ex) {
                        ExportToGraphicDialog.this.getWidthTextField().setText("");
                    }
                }
            });
        }
        return this.heightTextField;
    }

    private JComboBox getUnitComboBox() {
        if (this.unitComboBox == null) {
            this.unitComboBox = new JComboBox();
            this.unitComboBox.addItem(UNIT_MILLIMETERS);
            this.unitComboBox.addItem(UNIT_POINTS);
            this.unitComboBox.addItem(UNIT_PIXELS);
            this.unitComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ExportToGraphicDialog.this.convertValue(ExportToGraphicDialog.this.getWidthTextField(), e);
                        ExportToGraphicDialog.this.convertValue(ExportToGraphicDialog.this.getHeightTextField(), e);
                        ExportToGraphicDialog.this.lastSelection = ExportToGraphicDialog.this.getUnitComboBox().getSelectedIndex();
                    }
                }
            });
        }
        return this.unitComboBox;
    }

    @Override
    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setControlButtonsAreShown(false);
            if (this.fileChooser.getFileFilter() != null) {
                this.fileChooser.removeChoosableFileFilter(this.fileChooser.getFileFilter());
            }
            GraphicFilter[] filters = GraphicWriterFactory.getInstance().getAllFilters();
            int i = 0;
            while (i < filters.length) {
                this.fileChooser.addChoosableFileFilter(filters[i]);
                ++i;
            }
            this.fileChooser.setFileFilter(filters[0]);
            this.setPreferencesPanel(filters[0].getFormat());
            this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("fileFilterChanged")) {
                        if (e.getNewValue() instanceof GraphicFilter) {
                            ExportToGraphicDialog.this.setPreferencesPanel(((GraphicFilter)e.getNewValue()).getFormat());
                        } else {
                            ExportToGraphicDialog.this.setPreferencesPanel(null);
                        }
                    }
                }
            });
        }
        return this.fileChooser;
    }

    private JPanel getFileChooserPanel() {
        if (this.fileChooserPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.weightx = 1.0;
            this.fileChooserPanel = new JPanel();
            this.fileChooserPanel.setLayout(new GridBagLayout());
            this.fileChooserPanel.setBorder(BorderFactory.createTitledBorder(null, "File", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.fileChooserPanel.add((Component)this.getFileChooser(), gridBagConstraints7);
        }
        return this.fileChooserPanel;
    }

    private JPanel getOuterPreferencesPanel() {
        if (this.outerPreferencesPanel == null) {
            this.outerPreferencesPanel = new JPanel();
            this.outerPreferencesPanel.setLayout(new GridBagLayout());
            this.outerPreferencesPanel.setBorder(BorderFactory.createTitledBorder(null, "Options", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        }
        return this.outerPreferencesPanel;
    }

    private JPanel getCommandPanel() {
        if (this.commandPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.anchor = 10;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.anchor = 10;
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.anchor = 10;
            gridBagConstraints6.gridy = 0;
            this.commandPanel = new JPanel();
            this.commandPanel.setLayout(new GridBagLayout());
            this.commandPanel.setBorder(BorderFactory.createTitledBorder(null, "Command", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.commandPanel.add((Component)this.getOpenRadioButton(), gridBagConstraints6);
            this.commandPanel.add((Component)this.getPrintRadioButton(), gridBagConstraints8);
            this.commandPanel.add((Component)this.getNoneRadioButton(), gridBagConstraints9);
            this.getCommandGroup();
        }
        return this.commandPanel;
    }

    private JRadioButton getOpenRadioButton() {
        if (this.openRadioButton == null) {
            this.openRadioButton = new JRadioButton();
            this.openRadioButton.setText("Open");
        }
        return this.openRadioButton;
    }

    private JRadioButton getPrintRadioButton() {
        if (this.printRadioButton == null) {
            this.printRadioButton = new JRadioButton();
            this.printRadioButton.setText("Print");
        }
        return this.printRadioButton;
    }

    private JRadioButton getNoneRadioButton() {
        if (this.noneRadioButton == null) {
            this.noneRadioButton = new JRadioButton();
            this.noneRadioButton.setText("None");
            this.noneRadioButton.setSelected(true);
        }
        return this.noneRadioButton;
    }

    public ButtonGroup getCommandGroup() {
        if (this.commandGroup == null) {
            this.commandGroup = new ButtonGroup();
            this.commandGroup.add(this.getOpenRadioButton());
            this.commandGroup.add(this.getPrintRadioButton());
            this.commandGroup.add(this.getNoneRadioButton());
        }
        return this.commandGroup;
    }
}

