/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.ancestralstate;

import info.bioinfweb.treegraph.document.undo.file.ancestralstate.AncestralStateImportParameters;
import info.bioinfweb.treegraph.gui.dialogs.CompareTextElementDataParametersPanel;
import info.bioinfweb.treegraph.gui.dialogs.io.FileDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.TextFileFilter;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ImportBayesTraitsDataDialog
extends FileDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel filePanel = null;
    private JFileChooser fileChooser;
    private JLabel nodeIdentifierLabel;
    private NodeBranchDataInput keyColumnInput;
    private JPanel keyColumnPanel;
    private CompareTextElementDataParametersPanel textElementDataParametersPanel;

    public ImportBayesTraitsDataDialog(Frame owner) {
        super(owner, FileDialog.Option.FILE_MUST_EXIST);
        this.setHelpCode(80);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    public void assignParameters(AncestralStateImportParameters parameters) {
        parameters.setTableFile(this.getSelectedFile());
        parameters.setKeyAdapter(this.getKeyColumnInput().getSelectedAdapter());
        this.getTextElementDataParametersPanel().assignToParameters(parameters);
    }

    @Override
    protected boolean onApply(File file) {
        return true;
    }

    @Override
    protected boolean onExecute() {
        this.getKeyColumnInput().setAdapters(this.getDocument().getTree(), true, true, true, false, false, "");
        this.getKeyColumnInput().setSelectedAdapter(this.getDocument().getDefaultLeafAdapter());
        return true;
    }

    private void initialize() {
        this.setTitle("Import BayesTraits Log Data");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    @Override
    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(0);
            this.fileChooser.setControlButtonsAreShown(false);
            TextFileFilter textFilter = new TextFileFilter();
            this.fileChooser.addChoosableFileFilter(textFilter);
            this.fileChooser.setFileFilter(textFilter);
        }
        return this.fileChooser;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getFilePanel(), null);
            this.jContentPane.add(this.getKeyColumnPanel());
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
            this.getApplyButton().setVisible(false);
            this.getOkButton().setText("Next >");
        }
        return this.jContentPane;
    }

    private JPanel getFilePanel() {
        if (this.filePanel == null) {
            this.filePanel = new JPanel();
            this.filePanel.setLayout(new BoxLayout(this.getFilePanel(), 1));
            this.filePanel.setBorder(BorderFactory.createTitledBorder(null, "File", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.filePanel.add((Component)this.getFileChooser(), null);
        }
        return this.filePanel;
    }

    private JLabel getNodeIdentifierLabel() {
        if (this.nodeIdentifierLabel == null) {
            this.nodeIdentifierLabel = new JLabel("Column in tree to identify nodes: ");
        }
        return this.nodeIdentifierLabel;
    }

    private NodeBranchDataInput getKeyColumnInput() {
        if (this.keyColumnInput == null) {
            this.getKeyColumnPanel();
        }
        return this.keyColumnInput;
    }

    private JPanel getKeyColumnPanel() {
        if (this.keyColumnPanel == null) {
            this.keyColumnPanel = new JPanel();
            this.keyColumnPanel.setBorder(new TitledBorder(null, "Node names", 4, 2, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            GridBagLayout gbl_keyColumnPanel = new GridBagLayout();
            gbl_keyColumnPanel.rowWeights = new double[]{0.0, 1.0};
            gbl_keyColumnPanel.columnWeights = new double[]{0.0, 1.0};
            this.keyColumnPanel.setLayout(gbl_keyColumnPanel);
            this.keyColumnInput = new NodeBranchDataInput(this.keyColumnPanel, 1, 0);
            GridBagConstraints gbc_nodeIdentifierLabel = new GridBagConstraints();
            gbc_nodeIdentifierLabel.anchor = 17;
            gbc_nodeIdentifierLabel.insets = new Insets(0, 0, 5, 0);
            gbc_nodeIdentifierLabel.gridx = 0;
            gbc_nodeIdentifierLabel.gridy = 0;
            this.keyColumnPanel.add((Component)this.getNodeIdentifierLabel(), gbc_nodeIdentifierLabel);
            GridBagConstraints gbc_textElementDataParametersPanel = new GridBagConstraints();
            gbc_textElementDataParametersPanel.gridwidth = 2;
            gbc_textElementDataParametersPanel.fill = 1;
            gbc_textElementDataParametersPanel.gridx = 0;
            gbc_textElementDataParametersPanel.gridy = 1;
            this.keyColumnPanel.add((Component)this.getTextElementDataParametersPanel(), gbc_textElementDataParametersPanel);
        }
        return this.keyColumnPanel;
    }

    private CompareTextElementDataParametersPanel getTextElementDataParametersPanel() {
        if (this.textElementDataParametersPanel == null) {
            this.textElementDataParametersPanel = new CompareTextElementDataParametersPanel();
        }
        return this.textElementDataParametersPanel;
    }
}

