/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.ancestralstate;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.io.ancestralstate.BayesTraitsCommandsWriter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.wikihelp.client.JHTMLLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GenerateBayesTraitsInputDialog
extends EditDialog {
    public static final String EXPORT_FILE_EXT = "txt";
    private BayesTraitsCommandsWriter commandWriter = new BayesTraitsCommandsWriter();
    private JPanel jContentPane = null;
    private JPanel filesPanel = null;
    private JTextField outputFileTextField = null;
    private JButton changeOutputFileButton = null;
    private JFileChooser fileChooser = null;
    private JPanel nodesPanel = null;
    private ButtonGroup nodesButtonGroup = null;
    private JRadioButton allNodesRadioButton = null;
    private JRadioButton selectedNodesRadioButton = null;
    private JPanel commandTypePanel = null;
    private JRadioButton addNodeRadioButton = null;
    private JRadioButton addMRCARadioButton = null;
    private ButtonGroup commandTypeButtonGroup = null;
    private JPanel nodeNamesPanel = null;
    private JLabel terminalNodeNamesInputLabel = null;
    private NodeBranchDataInput terminalNodeNamesColumnInput = null;
    private JLabel internalNodeNamesInputLabel = null;
    private NodeBranchDataInput internalNodeNamesColumnInput = null;
    private JPanel helpTextPanel = null;
    private JHTMLLabel helpTextLabel;
    private JPanel copyButtonPanel = null;
    private JButton copyButton = null;

    public GenerateBayesTraitsInputDialog(MainFrame owner) {
        super(owner);
        this.setHelpCode(60);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        this.getTerminalNodeNamesColumnInput().setAdapters(this.getDocument().getTree(), true, true, false, false, false, null);
        this.getTerminalNodeNamesColumnInput().setSelectedAdapter(this.getDocument().getDefaultLeafAdapter());
        return true;
    }

    protected boolean apply() {
        String outputFilePath = this.getOutputFileTextField().getText();
        File file = new File(outputFilePath);
        boolean write = true;
        if (file.exists()) {
            boolean bl = write = JOptionPane.showConfirmDialog((Component)((Object)this), "The file \"" + file.getName() + "\" already exists.\n Do you want to overwrite it?", "Warning", 0, 2) == 0;
        }
        if (write) {
            try {
                this.writeBayesTraitsCommands(new BufferedWriter(new FileWriter(file)));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The error \"" + e.getMessage() + "\" occured when writing to the file \"" + file.getName() + "\".", "Error", 0);
                return false;
            }
        }
        return write;
    }

    private void writeBayesTraitsCommands(Writer writer) throws IOException {
        Node[] nodes = this.getSelectedNodesRadioButton().isSelected() ? (Node[])this.getSelection().getAllElementsOfType(Node.class, false) : (Node[])TreeSerializer.getElementsInSubtree((Node)this.getDocument().getTree().getPaintStart(), (NodeType)NodeType.INTERNAL_NODES, Node.class);
        if (this.getAddNodeRadioButton().isSelected()) {
            this.commandWriter.write(writer, "AddNode ", nodes, this.getTerminalNodeNamesColumnInput().getSelectedAdapter(), this.getInternalNodeNamesColumnInput().getSelectedAdapter());
        } else if (this.getAddMRCARadioButton().isSelected()) {
            this.commandWriter.write(writer, "AddMRCA ", nodes, this.getTerminalNodeNamesColumnInput().getSelectedAdapter(), this.getInternalNodeNamesColumnInput().getSelectedAdapter());
        }
    }

    private void initialize() {
        this.setTitle("Generate BayesTraits commands");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add(this.getFilesPanel());
            this.jContentPane.add(this.getNodesPanel());
            this.jContentPane.add(this.getCommandTypePanel());
            this.jContentPane.add(this.getNodeNamesPanel());
            this.jContentPane.add(this.getHelpTextPanel());
            this.jContentPane.add(this.getCopyButtonPanel());
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
            this.getApplyButton().setVisible(false);
        }
        return this.jContentPane;
    }

    protected JPanel getFilesPanel() {
        if (this.filesPanel == null) {
            this.filesPanel = new JPanel();
            this.filesPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Output file", 4, 2, null, null));
            this.filesPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_outputFolderTextField = new GridBagConstraints();
            gbc_outputFolderTextField.insets = new Insets(2, 2, 2, 1);
            gbc_outputFolderTextField.fill = 2;
            gbc_outputFolderTextField.gridx = 0;
            gbc_outputFolderTextField.gridy = 0;
            gbc_outputFolderTextField.weightx = 1.0;
            this.filesPanel.add((Component)this.getOutputFileTextField(), gbc_outputFolderTextField);
            GridBagConstraints gbc_changeOutputFolderButton = new GridBagConstraints();
            gbc_changeOutputFolderButton.insets = new Insets(2, 1, 2, 2);
            gbc_changeOutputFolderButton.gridx = 1;
            gbc_changeOutputFolderButton.gridy = 0;
            this.filesPanel.add((Component)this.getChangeOutputFileButton(), gbc_changeOutputFolderButton);
        }
        return this.filesPanel;
    }

    private JTextField getOutputFileTextField() {
        if (this.outputFileTextField == null) {
            this.outputFileTextField = new JTextField();
        }
        return this.outputFileTextField;
    }

    private JButton getChangeOutputFileButton() {
        if (this.changeOutputFileButton == null) {
            this.changeOutputFileButton = new JButton();
            this.changeOutputFileButton.setText("...");
            this.changeOutputFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenerateBayesTraitsInputDialog.this.getFileChooser().setSelectedFile(new File(GenerateBayesTraitsInputDialog.this.getOutputFileTextField().getText()));
                    if (GenerateBayesTraitsInputDialog.this.getFileChooser().showSaveDialog(MainFrame.getInstance()) == 0) {
                        String path = GenerateBayesTraitsInputDialog.this.getFileChooser().getSelectedFile().getAbsolutePath();
                        if (!path.endsWith(".txt")) {
                            path = String.valueOf(path) + ".txt";
                        }
                        GenerateBayesTraitsInputDialog.this.getOutputFileTextField().setText(path);
                    }
                }
            });
        }
        return this.changeOutputFileButton;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileFilter(new FileNameExtensionFilter("Text files", EXPORT_FILE_EXT));
            CurrentDirectoryModel.getInstance().addFileChooser(this.fileChooser);
        }
        return this.fileChooser;
    }

    private JPanel getNodesPanel() {
        if (this.nodesPanel == null) {
            this.nodesPanel = new JPanel();
            this.nodesPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Nodes to be reconstructed", 4, 2, null, null));
            this.nodesPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_allNodesRadioButton = new GridBagConstraints();
            gbc_allNodesRadioButton.insets = new Insets(2, 0, 2, 0);
            gbc_allNodesRadioButton.gridx = 0;
            gbc_allNodesRadioButton.gridy = 0;
            this.nodesPanel.add((Component)this.getAllNodesRadioButton(), gbc_allNodesRadioButton);
            GridBagConstraints gbc_selectedNodesRadioButton = new GridBagConstraints();
            gbc_selectedNodesRadioButton.insets = new Insets(2, 0, 2, 0);
            gbc_selectedNodesRadioButton.gridx = 1;
            gbc_selectedNodesRadioButton.gridy = 0;
            this.nodesPanel.add((Component)this.getSelectedNodesRadioButton(), gbc_selectedNodesRadioButton);
        }
        return this.nodesPanel;
    }

    public ButtonGroup getNodesButtonGroup() {
        if (this.nodesButtonGroup == null) {
            this.nodesButtonGroup = new ButtonGroup();
        }
        return this.nodesButtonGroup;
    }

    private JRadioButton getAllNodesRadioButton() {
        if (this.allNodesRadioButton == null) {
            this.allNodesRadioButton = new JRadioButton("All nodes in the document");
            this.allNodesRadioButton.setSelected(true);
            this.getNodesButtonGroup().add(this.allNodesRadioButton);
        }
        return this.allNodesRadioButton;
    }

    private JRadioButton getSelectedNodesRadioButton() {
        if (this.selectedNodesRadioButton == null) {
            this.selectedNodesRadioButton = new JRadioButton("Only selected nodes");
            this.getNodesButtonGroup().add(this.selectedNodesRadioButton);
        }
        return this.selectedNodesRadioButton;
    }

    private JPanel getCommandTypePanel() {
        if (this.commandTypePanel == null) {
            this.commandTypePanel = new JPanel();
            this.commandTypePanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Type of BayesTraits command", 4, 2, null, null));
            this.commandTypePanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_addNodeRadioButton = new GridBagConstraints();
            gbc_addNodeRadioButton.insets = new Insets(2, 0, 2, 0);
            gbc_addNodeRadioButton.gridx = 0;
            gbc_addNodeRadioButton.gridy = 0;
            this.commandTypePanel.add((Component)this.getAddNodeRadioButton(), gbc_addNodeRadioButton);
            GridBagConstraints gbc_addMRCARadioButton = new GridBagConstraints();
            gbc_addMRCARadioButton.insets = new Insets(2, 0, 2, 0);
            gbc_addMRCARadioButton.gridx = 1;
            gbc_addMRCARadioButton.gridy = 0;
            this.commandTypePanel.add((Component)this.getAddMRCARadioButton(), gbc_addMRCARadioButton);
        }
        return this.commandTypePanel;
    }

    private ButtonGroup getCommandTypeButtonGroup() {
        if (this.commandTypeButtonGroup == null) {
            this.commandTypeButtonGroup = new ButtonGroup();
        }
        return this.commandTypeButtonGroup;
    }

    private JRadioButton getAddNodeRadioButton() {
        if (this.addNodeRadioButton == null) {
            this.addNodeRadioButton = new JRadioButton("AddNode command");
            this.addNodeRadioButton.setSelected(true);
            this.getCommandTypeButtonGroup().add(this.addNodeRadioButton);
        }
        return this.addNodeRadioButton;
    }

    private JRadioButton getAddMRCARadioButton() {
        if (this.addMRCARadioButton == null) {
            this.addMRCARadioButton = new JRadioButton("AddMRCA command");
            this.getCommandTypeButtonGroup().add(this.addMRCARadioButton);
        }
        return this.addMRCARadioButton;
    }

    private JPanel getNodeNamesPanel() {
        if (this.nodeNamesPanel == null) {
            this.nodeNamesPanel = new JPanel();
            this.nodeNamesPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Node name column", 4, 2, null, null));
            this.nodeNamesPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_internalNodeNamesInputlabel = new GridBagConstraints();
            gbc_internalNodeNamesInputlabel.anchor = 17;
            gbc_internalNodeNamesInputlabel.insets = new Insets(2, 0, 2, 0);
            gbc_internalNodeNamesInputlabel.gridx = 0;
            gbc_internalNodeNamesInputlabel.gridy = 0;
            this.nodeNamesPanel.add((Component)this.getInternalNodeNamesInputLabel(), gbc_internalNodeNamesInputlabel);
            this.internalNodeNamesColumnInput = new NodeBranchDataInput(this.nodeNamesPanel, 0, 1, 2);
            this.internalNodeNamesColumnInput.setAdapters(MainFrame.getInstance().getActiveTreeFrame().getDocument().getTree(), true, true, false, false, false, "Generate internal node names");
            GridBagConstraints gbc_terminalNodeNamesInputlabel = new GridBagConstraints();
            gbc_terminalNodeNamesInputlabel.anchor = 17;
            gbc_terminalNodeNamesInputlabel.insets = new Insets(2, 0, 2, 0);
            gbc_terminalNodeNamesInputlabel.gridx = 0;
            gbc_terminalNodeNamesInputlabel.gridy = 2;
            this.nodeNamesPanel.add((Component)this.getTerminalNodeNamesInputLabel(), gbc_terminalNodeNamesInputlabel);
            this.terminalNodeNamesColumnInput = new NodeBranchDataInput(this.nodeNamesPanel, 0, 3, 2);
            this.terminalNodeNamesColumnInput.setAdapters(MainFrame.getInstance().getActiveTreeFrame().getDocument().getTree(), true, true, false, false, false, "");
        }
        return this.nodeNamesPanel;
    }

    private JLabel getInternalNodeNamesInputLabel() {
        if (this.internalNodeNamesInputLabel == null) {
            this.internalNodeNamesInputLabel = new JLabel();
            this.internalNodeNamesInputLabel.setText("Internal node/MRCA names:");
        }
        return this.internalNodeNamesInputLabel;
    }

    private NodeBranchDataInput getInternalNodeNamesColumnInput() {
        this.getNodeNamesPanel();
        return this.internalNodeNamesColumnInput;
    }

    private JLabel getTerminalNodeNamesInputLabel() {
        if (this.terminalNodeNamesInputLabel == null) {
            this.terminalNodeNamesInputLabel = new JLabel();
            this.terminalNodeNamesInputLabel.setText("Terminal node names:");
        }
        return this.terminalNodeNamesInputLabel;
    }

    private NodeBranchDataInput getTerminalNodeNamesColumnInput() {
        this.getNodeNamesPanel();
        return this.terminalNodeNamesColumnInput;
    }

    private JPanel getCopyButtonPanel() {
        if (this.copyButtonPanel == null) {
            this.copyButtonPanel = new JPanel();
            this.copyButtonPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_copyButton = new GridBagConstraints();
            gbc_copyButton.insets = new Insets(2, 0, 2, 0);
            gbc_copyButton.gridx = 0;
            gbc_copyButton.gridy = 0;
            this.copyButtonPanel.add((Component)this.getCopyButton(), gbc_copyButton);
        }
        return this.copyButtonPanel;
    }

    private JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton("Copy to clipboard");
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        CharArrayWriter writer = new CharArrayWriter();
                        GenerateBayesTraitsInputDialog.this.writeBayesTraitsCommands(writer);
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(writer.toString()), null);
                    }
                    catch (IOException ex) {
                        throw new InternalError(ex);
                    }
                }
            });
        }
        return this.copyButton;
    }

    private JPanel getHelpTextPanel() {
        if (this.helpTextPanel == null) {
            this.helpTextPanel = new JPanel();
            GridBagLayout gbl_helpTextPanel = new GridBagLayout();
            gbl_helpTextPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_helpTextPanel.rowWeights = new double[]{1.0, Double.MIN_VALUE};
            this.helpTextPanel.setLayout(gbl_helpTextPanel);
            GridBagConstraints gbc_helpTextLabel = new GridBagConstraints();
            gbc_helpTextLabel.fill = 1;
            gbc_helpTextLabel.insets = new Insets(2, 5, 2, 5);
            gbc_helpTextLabel.gridx = 0;
            gbc_helpTextLabel.gridy = 0;
            this.helpTextPanel.add((Component)this.getHelpTextLabel(), gbc_helpTextLabel);
        }
        return this.helpTextPanel;
    }

    private JHTMLLabel getHelpTextLabel() {
        if (this.helpTextLabel == null) {
            this.helpTextLabel = new JHTMLLabel(Main.getInstance().getWikiHelp());
            this.helpTextLabel.setHTMLContent("If you also want to create a tree file or a character table see <a href='wikihelp://82'>Exporting trees as Newick/Nexus files</a> <br>and <a href='wikihelp://67'>Exporting node/branch data</a> or click the help button.");
        }
        return this.helpTextLabel;
    }
}

