/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.ancestralstate;

import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.io.ancestralstate.AncestralStateData;
import info.bioinfweb.treegraph.document.nodebranchdata.NewHiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.file.ancestralstate.AncestralStateImportParameters;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NewNodeBranchDataInput;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CharacterInput {
    private static final int FIXED_ROWS_PER_CHARACTER = 3;
    private static final int HEADING_ROWS_COUNT = 2;
    private int bottomY = 0;
    private List<NewNodeBranchDataInput> stateInputs = new ArrayList<NewNodeBranchDataInput>();
    private JCheckBox importCharacterCheckbox = null;
    private JLabel prefixLabel = null;
    private JLabel typeHeadingLabel = null;
    private JLabel idHeadingLabel = null;
    private JCheckBox pieChartLabelCheckbox = null;
    private JTextField pieChartLabelIDTextField = null;

    public CharacterInput(JPanel panel, int y, AncestralStateData data, Tree tree, String prefixIDText) {
        this.bottomY = this.createCharacterInput(panel, y, data, tree, prefixIDText);
    }

    private int createCharacterInput(JPanel panel, int y, AncestralStateData data, Tree tree, String prefixIDText) {
        int usedRows = y + 3 + data.getStateCountPerSite(prefixIDText);
        GridBagConstraints importCharacterCheckboxGBC = new GridBagConstraints();
        importCharacterCheckboxGBC.gridx = 0;
        importCharacterCheckboxGBC.anchor = 17;
        importCharacterCheckboxGBC.gridy = y;
        importCharacterCheckboxGBC.insets = new Insets(2, 2, 2, 0);
        this.importCharacterCheckbox = new JCheckBox();
        this.importCharacterCheckbox.setSelected(true);
        GridBagConstraints prefixGBC = new GridBagConstraints();
        prefixGBC.gridx = 1;
        prefixGBC.anchor = 17;
        prefixGBC.gridy = y;
        prefixGBC.insets = new Insets(2, 0, 2, 2);
        this.prefixLabel = new JLabel();
        this.prefixLabel.setText("Import ancestral state data for site \"" + prefixIDText + "\"");
        GridBagConstraints typeHeadingGBC = new GridBagConstraints();
        typeHeadingGBC.gridx = 1;
        typeHeadingGBC.anchor = 17;
        typeHeadingGBC.gridy = y + 1;
        typeHeadingGBC.insets = new Insets(2, 2, 2, 2);
        this.typeHeadingLabel = new JLabel();
        this.typeHeadingLabel.setText("Node data type:");
        GridBagConstraints idHeadingGBC = new GridBagConstraints();
        idHeadingGBC.gridx = 2;
        idHeadingGBC.gridy = y + 1;
        idHeadingGBC.anchor = 17;
        idHeadingGBC.insets = new Insets(2, 2, 2, 2);
        this.idHeadingLabel = new JLabel();
        this.idHeadingLabel.setText("ID:                ");
        panel.add((Component)this.importCharacterCheckbox, importCharacterCheckboxGBC);
        panel.add((Component)this.prefixLabel, prefixGBC);
        panel.add((Component)this.typeHeadingLabel, typeHeadingGBC);
        panel.add((Component)this.idHeadingLabel, idHeadingGBC);
        Iterator<String> keySetIterator = data.getKeyIterator(prefixIDText);
        int counter = 1;
        while (keySetIterator.hasNext()) {
            NewNodeBranchDataInput input = new NewNodeBranchDataInput(panel, 1, y + counter + 2 - 1, true);
            input.setAdapters(tree, false, false, false, false, true, "");
            input.setSelectedAdapter(NewHiddenBranchDataAdapter.class);
            input.setID(String.valueOf(prefixIDText) + "." + keySetIterator.next());
            this.stateInputs.add(input);
            ++counter;
        }
        GridBagConstraints pieChartLabelCheckboxGBC = new GridBagConstraints();
        pieChartLabelCheckboxGBC.gridx = 1;
        pieChartLabelCheckboxGBC.anchor = 17;
        pieChartLabelCheckboxGBC.gridy = usedRows - 1;
        pieChartLabelCheckboxGBC.insets = new Insets(2, 2, 2, 2);
        this.pieChartLabelCheckbox = new JCheckBox();
        this.pieChartLabelCheckbox.setText("Create pie chart label with ID:");
        this.pieChartLabelCheckbox.setSelected(true);
        GridBagConstraints pieChartLabelIDGBC = new GridBagConstraints();
        pieChartLabelIDGBC.gridx = 2;
        pieChartLabelIDGBC.anchor = 17;
        pieChartLabelIDGBC.gridy = usedRows - 1;
        pieChartLabelIDGBC.insets = new Insets(2, 2, 2, 2);
        pieChartLabelIDGBC.fill = 2;
        this.pieChartLabelIDTextField = new JTextField();
        this.pieChartLabelIDTextField.setText(String.valueOf(prefixIDText) + ".label");
        panel.add((Component)this.pieChartLabelCheckbox, pieChartLabelCheckboxGBC);
        panel.add((Component)this.pieChartLabelIDTextField, pieChartLabelIDGBC);
        this.importCharacterCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CharacterInput.this.setContentsEnabled(CharacterInput.this.importCharacterCheckbox.isSelected());
            }
        });
        this.pieChartLabelCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CharacterInput.this.pieChartLabelIDTextField.setEnabled(CharacterInput.this.pieChartLabelCheckbox.isSelected());
            }
        });
        return usedRows;
    }

    public void assignParameters(AncestralStateImportParameters parameters, int importAdapterIndex, int labelIDsIndex) {
        NodeBranchDataAdapter[] importAdapters = parameters.getImportAdapters();
        VoidNodeBranchDataAdapter voidAdapter = new VoidNodeBranchDataAdapter("");
        int i = 0;
        while (i < this.stateInputs.size()) {
            importAdapters[importAdapterIndex + i] = this.importCharacterCheckbox.isSelected() ? this.stateInputs.get(i).getSelectedAdapter() : voidAdapter;
            ++i;
        }
        parameters.setImportAdapters(importAdapters);
        String[] labelIDs = parameters.getPieChartLabelIDs();
        labelIDs[labelIDsIndex] = this.importCharacterCheckbox.isSelected() && this.pieChartLabelCheckbox.isSelected() ? this.pieChartLabelIDTextField.getText() : null;
        parameters.setPieChartLabelIDs(labelIDs);
    }

    public int getBottomY() {
        return this.bottomY;
    }

    private void setContentsEnabled(boolean enabled) {
        this.prefixLabel.setEnabled(enabled);
        this.typeHeadingLabel.setEnabled(enabled);
        this.idHeadingLabel.setEnabled(enabled);
        int i = 0;
        while (i < this.stateInputs.size()) {
            this.stateInputs.get(i).setEnabled(enabled);
            ++i;
        }
        this.pieChartLabelCheckbox.setEnabled(enabled);
        this.pieChartLabelIDTextField.setEnabled(enabled);
    }

    public boolean isSelected() {
        return this.importCharacterCheckbox.isSelected();
    }

    public void setSelected(boolean selected) {
        this.importCharacterCheckbox.setSelected(selected);
    }
}

