/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io.ancestralstate;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.io.ancestralstate.AncestralStateData;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.PieChartLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.file.ancestralstate.AncestralStateImportParameters;
import info.bioinfweb.treegraph.gui.dialogs.io.ancestralstate.CharacterInput;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.AbstractNodeBranchDataColumnsDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NewNodeBranchDataInput;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AssignBayesTraitsImportColumnsDialog
extends AbstractNodeBranchDataColumnsDialog {
    private JPanel jContentPane = null;
    private JPanel importInternalNodeNamesPanel = null;
    private AncestralStateImportParameters parameters = null;
    private AncestralStateData data = null;
    private List<CharacterInput> characterInputs = new ArrayList<CharacterInput>();
    private NewNodeBranchDataInput internalNodeNames = null;
    private JPanel characterListHeadingPanel = null;
    private JLabel importCharacterDataLabel = null;
    private JLabel importInternalNodeNamesLabel = null;
    private JButton invertSelectionButton;
    private JButton selectAllButton;
    private JButton selectNoneButton;

    public AssignBayesTraitsImportColumnsDialog(Frame owner) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.setHelpCode(81);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    private void createInputs(AncestralStateData data) {
        this.getImportPanel().removeAll();
        this.characterInputs.clear();
        Iterator<String> keySetIterator = data.getSiteIterator();
        int bottomY = 0;
        while (keySetIterator.hasNext()) {
            CharacterInput input = new CharacterInput(this.getImportPanel(), bottomY, data, this.tree, keySetIterator.next());
            bottomY = input.getBottomY();
            this.characterInputs.add(input);
        }
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        Rectangle bounds = this.getBounds();
        this.setBounds(bounds.x, bounds.y, bounds.width, Math.min(bounds.height, Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getHeight() * 0.9f)));
    }

    public boolean execute(AncestralStateImportParameters parameters, AncestralStateData data, Tree tree) {
        this.tree = tree;
        this.parameters = parameters;
        this.data = data;
        this.createInputs(data);
        this.internalNodeNames.setAdapters(tree, false, true, false, false, true, "Do not import internal node names");
        this.internalNodeNames.setSelectedAdapter(NodeNameAdapter.class);
        this.internalNodeNames.setID("");
        return this.execute();
    }

    protected boolean apply() {
        NodeBranchDataAdapter[] importAdapters = new NodeBranchDataAdapter[this.data.getCharacterStateCount()];
        String[] labelIDs = new String[this.data.getSiteCount()];
        this.parameters.setImportAdapters(importAdapters);
        this.parameters.setPieChartLabelIDs(labelIDs);
        Iterator<String> keySetIterator = this.data.getSiteIterator();
        int importAdapterIndexStart = 0;
        int labelIDsIndexStart = 0;
        while (keySetIterator.hasNext()) {
            this.characterInputs.get(labelIDsIndexStart).assignParameters(this.parameters, importAdapterIndexStart, labelIDsIndexStart);
            importAdapterIndexStart += this.data.getStateCountPerSite(keySetIterator.next());
            ++labelIDsIndexStart;
        }
        this.parameters.setInternalNodeNamesAdapter(this.internalNodeNames.getSelectedAdapter());
        int importAdapterCount = this.parameters.getImportAdapters().length;
        int pieChartLabelCount = this.parameters.getPieChartLabelIDs().length;
        NodeBranchDataAdapter[] allAdapters = new NodeBranchDataAdapter[1 + importAdapterCount + pieChartLabelCount];
        allAdapters[0] = this.parameters.getInternalNodeNamesAdapter();
        int i = 0;
        while (i < importAdapterCount) {
            allAdapters[i + 1] = this.parameters.getImportAdapters()[i];
            ++i;
        }
        i = 0;
        while (i < pieChartLabelCount) {
            String pieChartLabelID = this.parameters.getPieChartLabelIDs()[i];
            allAdapters[i + importAdapterCount + 1] = pieChartLabelID != null ? new PieChartLabelAdapter(pieChartLabelID) : new VoidNodeBranchDataAdapter("");
            ++i;
        }
        return this.checkSelectedAdapters(allAdapters, null);
    }

    private void initialize() {
        this.setTitle("Import BayesTraits data");
        this.setSize(380, 400);
        this.getApplyButton().setVisible(false);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add(this.getCharacterListHeadingPanel());
            this.jContentPane.add(this.getScrollPane());
            this.jContentPane.add((Component)this.getImportInternalNodeNamesPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getCharacterListHeadingPanel() {
        if (this.characterListHeadingPanel == null) {
            this.characterListHeadingPanel = new JPanel();
            GridBagLayout gbl_characterListHeadingPanel = new GridBagLayout();
            this.characterListHeadingPanel.setLayout(gbl_characterListHeadingPanel);
            GridBagConstraints importCharacterDataLabelGBC = new GridBagConstraints();
            importCharacterDataLabelGBC.weightx = 1.0;
            importCharacterDataLabelGBC.gridx = 0;
            importCharacterDataLabelGBC.anchor = 17;
            importCharacterDataLabelGBC.gridy = 0;
            importCharacterDataLabelGBC.insets = new Insets(4, 6, 5, 5);
            importCharacterDataLabelGBC.gridwidth = 3;
            importCharacterDataLabelGBC.weighty = 2.0;
            this.importCharacterDataLabel = new JLabel();
            this.importCharacterDataLabel.setText("Import ancestral state data");
            this.characterListHeadingPanel.add((Component)this.importCharacterDataLabel, importCharacterDataLabelGBC);
            GridBagConstraints gbc_btnSelectAll = new GridBagConstraints();
            gbc_btnSelectAll.insets = new Insets(0, 4, 2, 5);
            gbc_btnSelectAll.gridx = 0;
            gbc_btnSelectAll.gridy = 1;
            this.characterListHeadingPanel.add((Component)this.getSelectAllButton(), gbc_btnSelectAll);
            GridBagConstraints gbc_btnSelectNone = new GridBagConstraints();
            gbc_btnSelectNone.insets = new Insets(0, 0, 2, 5);
            gbc_btnSelectNone.gridx = 1;
            gbc_btnSelectNone.gridy = 1;
            this.characterListHeadingPanel.add((Component)this.getSelectNoneButton(), gbc_btnSelectNone);
            GridBagConstraints gbc_btnInvertSelection = new GridBagConstraints();
            gbc_btnInvertSelection.insets = new Insets(0, 0, 2, 4);
            gbc_btnInvertSelection.anchor = 17;
            gbc_btnInvertSelection.gridx = 2;
            gbc_btnInvertSelection.gridy = 1;
            this.characterListHeadingPanel.add((Component)this.getInvertSelectionButton(), gbc_btnInvertSelection);
        }
        return this.characterListHeadingPanel;
    }

    private JPanel getImportInternalNodeNamesPanel() {
        if (this.importInternalNodeNamesPanel == null) {
            this.importInternalNodeNamesPanel = new JPanel();
            this.importInternalNodeNamesPanel.setLayout(new GridBagLayout());
            GridBagConstraints importInternalNodeNamesLabelGBC = new GridBagConstraints();
            importInternalNodeNamesLabelGBC.gridx = 0;
            importInternalNodeNamesLabelGBC.anchor = 17;
            importInternalNodeNamesLabelGBC.gridy = 0;
            importInternalNodeNamesLabelGBC.insets = new Insets(4, 6, 4, 0);
            importInternalNodeNamesLabelGBC.gridwidth = -1;
            this.importInternalNodeNamesLabel = new JLabel();
            this.importInternalNodeNamesLabel.setText("Import internal node names");
            this.importInternalNodeNamesPanel.add((Component)this.importInternalNodeNamesLabel, importInternalNodeNamesLabelGBC);
            this.internalNodeNames = new NewNodeBranchDataInput(this.importInternalNodeNamesPanel, 1, 1, true);
        }
        return this.importInternalNodeNamesPanel;
    }

    private JButton getInvertSelectionButton() {
        if (this.invertSelectionButton == null) {
            this.invertSelectionButton = new JButton("Invert selection");
            this.invertSelectionButton.setMnemonic('i');
            this.invertSelectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Iterator iterator = AssignBayesTraitsImportColumnsDialog.this.characterInputs.iterator();
                    while (iterator.hasNext()) {
                        CharacterInput characterInput;
                        characterInput.setSelected(!(characterInput = (CharacterInput)iterator.next()).isSelected());
                    }
                }
            });
        }
        return this.invertSelectionButton;
    }

    private JButton getSelectAllButton() {
        if (this.selectAllButton == null) {
            this.selectAllButton = new JButton("Select all");
            this.selectAllButton.setMnemonic('a');
            this.selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (CharacterInput characterInput : AssignBayesTraitsImportColumnsDialog.this.characterInputs) {
                        characterInput.setSelected(true);
                    }
                }
            });
        }
        return this.selectAllButton;
    }

    private JButton getSelectNoneButton() {
        if (this.selectNoneButton == null) {
            this.selectNoneButton = new JButton("Select none");
            this.selectNoneButton.setMnemonic('n');
            this.selectNoneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (CharacterInput characterInput : AssignBayesTraitsImportColumnsDialog.this.characterInputs) {
                        characterInput.setSelected(false);
                    }
                }
            });
        }
        return this.selectNoneButton;
    }
}

