/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.io.TreeSelector;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TreeSelectionDialog
extends OkCancelApplyWikiHelpDialog
implements TreeSelector {
    private static final long serialVersionUID = 1L;
    private static TreeSelectionDialog firstInstance = null;
    private List<Tree> trees = null;
    private int currentTree = -1;
    private JPanel jContentPane = null;
    private JPanel selectionPanel = null;
    private JComboBox treeComboBox = null;
    private JPanel previewPanel = null;
    private JScrollPane previewScrollPane = null;
    private TreeViewPanel treeViewPanel = null;

    private TreeSelectionDialog(Frame owner) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.initialize();
        this.setLocationRelativeTo(owner);
        this.setHelpCode(51);
    }

    public static TreeSelectionDialog getInstance() {
        if (firstInstance == null) {
            firstInstance = new TreeSelectionDialog(MainFrame.getInstance());
        }
        return firstInstance;
    }

    private int getSelectedIndex() {
        return this.getTreeComboBox().getSelectedIndex();
    }

    @Override
    public int select(String[] names, List<Tree> trees) {
        if (trees.size() > 1) {
            this.currentTree = -1;
            this.trees = trees;
            StringUtils.renameRepeatedEntries(names);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.getTreeComboBox().getModel();
            model.removeAllElements();
            int i = 0;
            while (i < names.length) {
                model.addElement(names[i]);
                ++i;
            }
            this.execute();
            return this.getSelectedIndex();
        }
        return 0;
    }

    protected boolean apply() {
        return true;
    }

    private void initialize() {
        this.setTitle("Select tree");
        this.setSize(400, 400);
        this.setContentPane(this.getJContentPane());
        this.getCancelButton().setVisible(false);
        this.getApplyButton().setVisible(false);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getSelectionPanel(), null);
            this.jContentPane.add((Component)this.getPreviewPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.gridx = 0;
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            this.selectionPanel.setBorder(BorderFactory.createTitledBorder(null, "Trees in the document:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.selectionPanel.add((Component)this.getTreeComboBox(), gridBagConstraints);
        }
        return this.selectionPanel;
    }

    private JComboBox getTreeComboBox() {
        if (this.treeComboBox == null) {
            this.treeComboBox = new JComboBox();
            this.treeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (TreeSelectionDialog.this.currentTree != TreeSelectionDialog.this.getSelectedIndex()) {
                        TreeSelectionDialog.this.currentTree = TreeSelectionDialog.this.getSelectedIndex();
                        TreeSelectionDialog.this.getTreeViewPanel().getDocument().setTree((Tree)TreeSelectionDialog.this.trees.get(TreeSelectionDialog.this.getSelectedIndex()));
                    }
                }
            });
        }
        return this.treeComboBox;
    }

    private JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            this.previewPanel = new JPanel();
            this.previewPanel.setLayout(new GridBagLayout());
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.previewPanel.add((Component)this.getPreviewScrollPane(), gridBagConstraints1);
        }
        return this.previewPanel;
    }

    private JScrollPane getPreviewScrollPane() {
        if (this.previewScrollPane == null) {
            this.previewScrollPane = new JScrollPane();
            this.previewScrollPane.setViewportView(this.getTreeViewPanel());
        }
        return this.previewScrollPane;
    }

    private TreeViewPanel getTreeViewPanel() {
        if (this.treeViewPanel == null) {
            this.treeViewPanel = new TreeViewPanel(new Document(false));
        }
        return this.treeViewPanel;
    }
}

