/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TableSeparatorPanel
extends JPanel {
    public static final char DEFAULT_SEPARATOR = ';';
    private JRadioButton tabRadioButton = null;
    private JRadioButton stringRadioButton = null;
    private JTextField separatorTextField = null;
    private ButtonGroup separatorGroup = new ButtonGroup();

    public TableSeparatorPanel() {
        this.initialize();
    }

    public boolean checkInput() {
        if (!this.getTabRadioButton().isSelected() && this.getSeparatorTextField().getText().length() != 1) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "The separator must be exactly one character long.", "Invalid separator", 0);
            return false;
        }
        return true;
    }

    public char getSeparator() {
        if (this.getTabRadioButton().isSelected()) {
            return '\t';
        }
        return this.getSeparatorTextField().getText().charAt(0);
    }

    private void initialize() {
        GridBagConstraints textFieldGBC = new GridBagConstraints();
        textFieldGBC.fill = 2;
        textFieldGBC.gridy = 1;
        textFieldGBC.weightx = 2.0;
        textFieldGBC.gridx = 1;
        GridBagConstraints stringRadioGBC = new GridBagConstraints();
        stringRadioGBC.gridx = 0;
        stringRadioGBC.anchor = 17;
        stringRadioGBC.gridy = 1;
        GridBagConstraints tabRadioGBC = new GridBagConstraints();
        tabRadioGBC.gridx = 0;
        tabRadioGBC.anchor = 17;
        tabRadioGBC.gridwidth = 2;
        tabRadioGBC.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Values separated by:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.getTabRadioButton(), tabRadioGBC);
        this.add((Component)this.getStringRadioButton(), stringRadioGBC);
        this.add((Component)this.getSeparatorTextField(), textFieldGBC);
    }

    private JRadioButton getTabRadioButton() {
        if (this.tabRadioButton == null) {
            this.tabRadioButton = new JRadioButton();
            this.tabRadioButton.setText("Tab");
            this.tabRadioButton.setSelected(true);
            this.separatorGroup.add(this.tabRadioButton);
        }
        return this.tabRadioButton;
    }

    private JRadioButton getStringRadioButton() {
        if (this.stringRadioButton == null) {
            this.stringRadioButton = new JRadioButton();
            this.stringRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableSeparatorPanel.this.getSeparatorTextField().setEnabled(e.getItem().equals(TableSeparatorPanel.this.getStringRadioButton()));
                }
            });
            this.separatorGroup.add(this.stringRadioButton);
        }
        return this.stringRadioButton;
    }

    private JTextField getSeparatorTextField() {
        if (this.separatorTextField == null) {
            this.separatorTextField = new JTextField();
            this.separatorTextField.setText(Character.toString(';'));
            this.separatorTextField.setEnabled(false);
        }
        return this.separatorTextField;
    }
}

