/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.treegraph.document.io.DocumentReader;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.io.SupportedFormatsFilter;
import info.bioinfweb.treegraph.document.io.jphyloio.NeXMLFilter;
import info.bioinfweb.treegraph.document.io.newick.NewickException;
import info.bioinfweb.treegraph.document.io.newick.NewickFilter;
import info.bioinfweb.treegraph.document.io.nexus.NexusFilter;
import info.bioinfweb.treegraph.document.io.phyloxml.PhyloXMLFilter;
import info.bioinfweb.treegraph.document.io.xtg.XTGFilter;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewTextLabelAdapter;
import info.bioinfweb.treegraph.gui.dialogs.io.FileDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.NewickExceptionDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.TreeSelectionDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NewNodeBranchDataInput;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OpenDialog
extends FileDialog {
    public static final String DEFAULT_NODE_NAME_ID = "support";
    public static final String DEFAULT_BRANCH_LENGTH_ID = "lengths";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel fileChooserPanel = null;
    private JFileChooser fileChooser;
    private JPanel internalNodesPanel = null;
    private NewNodeBranchDataInput nodeNamesDataInput = null;
    private NewNodeBranchDataInput branchLengthsDataInput = null;
    private JCheckBox translateInternalNodesCheckBox = null;
    private JPanel branchLengthsPanel = null;
    private XTGFilter xtgFilter;
    private NexusFilter nexusFilter;
    private NewickFilter newickFilter;
    private NeXMLFilter nexmlFilter;
    private PhyloXMLFilter phyloxmlFilter;
    private NewickExceptionDialog newickExceptionDialog = null;

    public OpenDialog(Frame owner) {
        super(owner, FileDialog.Option.FILE_MUST_EXIST);
        this.initialize();
        this.setLocationRelativeTo(owner);
        this.setHelpCode(50);
    }

    @Override
    protected boolean onExecute() {
        return true;
    }

    @Override
    protected boolean onApply(File file) {
        try {
            boolean open = true;
            if (MainFrame.getInstance().getInternalFrameByFile(file) != null) {
                boolean bl = open = JOptionPane.showConfirmDialog((Component)((Object)this), "The file \"" + file.getAbsolutePath() + "\" is already open.\n" + "Do you want to open it another time?", "Warning", 0, 2) == 0;
            }
            if (open) {
                DocumentReader reader = ReadWriteFactory.getInstance().getReader(this.getFileChooser().getSelectedFile());
                if (reader != null) {
                    ReadWriteParameterMap parameterMap = new ReadWriteParameterMap();
                    parameterMap.putApplicationLogger((ApplicationLogger)MainFrame.getInstance().getReadWriteLogDialog());
                    parameterMap.put("internalNodeNamesAdapter", this.getNodeNamesDataInput().getSelectedAdapter());
                    parameterMap.put("branchLengthAdapter", this.getBranchLengthsDataInput().getSelectedAdapter());
                    parameterMap.put("treeSelector", TreeSelectionDialog.getInstance());
                    parameterMap.put("translateInternalNodeNames", this.getTranslateInternalNodesCheckBox().isSelected());
                    MainFrame.getInstance().addInternalFrame(reader.read(file, parameterMap));
                    MainFrame.getInstance().getReadWriteLogDialog().display();
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "The selected file has an unsupported format.", "Unsupported file format", 0);
                    return false;
                }
            }
            return true;
        }
        catch (NewickException e) {
            if (this.newickExceptionDialog == null) {
                this.newickExceptionDialog = new NewickExceptionDialog((Dialog)((Object)this));
            }
            this.newickExceptionDialog.show(e);
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "The error \"" + e.toString() + "\" occured\n" + "when trying to open the file \"" + file.getAbsolutePath() + "\".", "Error", 0);
            e.printStackTrace();
            return false;
        }
    }

    private void initialize() {
        this.setTitle("Open tree file");
        this.setContentPane(this.getJContentPane());
        this.getApplyButton().setVisible(false);
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getFileChooserPanel(), null);
            this.jContentPane.add((Component)this.getInternalNodesPanel(), null);
            this.jContentPane.add((Component)this.getBranchLengthsPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getFileChooserPanel() {
        if (this.fileChooserPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            this.fileChooserPanel = new JPanel();
            this.fileChooserPanel.setLayout(new GridBagLayout());
            this.fileChooserPanel.setBorder(BorderFactory.createTitledBorder(null, "File", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.fileChooserPanel.add((Component)this.getFileChooser(), gridBagConstraints);
        }
        return this.fileChooserPanel;
    }

    @Override
    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(0);
            this.fileChooser.setControlButtonsAreShown(false);
            if (this.fileChooser.getFileFilter() != null) {
                this.fileChooser.removeChoosableFileFilter(this.fileChooser.getFileFilter());
            }
            SupportedFormatsFilter supportedFormatsFilter = new SupportedFormatsFilter();
            this.fileChooser.addChoosableFileFilter(supportedFormatsFilter);
            this.xtgFilter = new XTGFilter();
            this.fileChooser.addChoosableFileFilter(this.xtgFilter);
            this.phyloxmlFilter = new PhyloXMLFilter();
            this.fileChooser.addChoosableFileFilter(this.phyloxmlFilter);
            this.nexmlFilter = new NeXMLFilter();
            this.fileChooser.addChoosableFileFilter(this.nexmlFilter);
            this.nexusFilter = new NexusFilter();
            this.fileChooser.addChoosableFileFilter(this.nexusFilter);
            this.newickFilter = new NewickFilter();
            this.fileChooser.addChoosableFileFilter(this.newickFilter);
            this.fileChooser.setFileFilter(supportedFormatsFilter);
            this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    File file = OpenDialog.this.getFileChooser().getSelectedFile();
                    if (e.getPropertyName().equals("fileFilterChanged")) {
                        boolean enableAdapters = file != null && !(e.getNewValue() instanceof XTGFilter);
                        OpenDialog.this.getNodeNamesDataInput().setEnabled(enableAdapters);
                        OpenDialog.this.getTranslateInternalNodesCheckBox().setEnabled(file != null && (e.getNewValue() instanceof NexusFilter || e.getNewValue() instanceof SupportedFormatsFilter));
                        OpenDialog.this.getBranchLengthsDataInput().setEnabled(enableAdapters);
                    } else if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                        boolean enableAdapters = file != null && OpenDialog.this.nexusFilter.validExtension(file.getAbsolutePath()) && OpenDialog.this.newickFilter.validExtension(file.getAbsolutePath());
                        OpenDialog.this.getNodeNamesDataInput().setEnabled(enableAdapters);
                        OpenDialog.this.getTranslateInternalNodesCheckBox().setEnabled(file != null && OpenDialog.this.nexusFilter.accept(file));
                        OpenDialog.this.getBranchLengthsDataInput().setEnabled(enableAdapters);
                    }
                }
            });
        }
        return this.fileChooser;
    }

    private JPanel getInternalNodesPanel() {
        if (this.internalNodesPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridy = 1;
            this.internalNodesPanel = new JPanel();
            this.internalNodesPanel.setLayout(new GridBagLayout());
            this.internalNodesPanel.setBorder(BorderFactory.createTitledBorder(null, "Import internal nodes as", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.internalNodesPanel.add((Component)this.getTranslateInternalNodesCheckBox(), gridBagConstraints1);
            this.nodeNamesDataInput = new NewNodeBranchDataInput(this.internalNodesPanel, 0, 0, true);
            this.nodeNamesDataInput.setAdapters(null, false, true, false, false, true, "");
            this.nodeNamesDataInput.setSelectedAdapter(NewTextLabelAdapter.class);
            this.nodeNamesDataInput.setID(DEFAULT_NODE_NAME_ID);
        }
        return this.internalNodesPanel;
    }

    private NewNodeBranchDataInput getNodeNamesDataInput() {
        this.getInternalNodesPanel();
        return this.nodeNamesDataInput;
    }

    private JCheckBox getTranslateInternalNodesCheckBox() {
        if (this.translateInternalNodesCheckBox == null) {
            this.translateInternalNodesCheckBox = new JCheckBox();
            this.translateInternalNodesCheckBox.setText("Translate internal node names");
        }
        return this.translateInternalNodesCheckBox;
    }

    private JPanel getBranchLengthsPanel() {
        if (this.branchLengthsPanel == null) {
            this.branchLengthsPanel = new JPanel();
            this.branchLengthsPanel.setLayout(new GridBagLayout());
            this.branchLengthsPanel.setBorder(BorderFactory.createTitledBorder(null, "Branch lengths", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.branchLengthsDataInput = new NewNodeBranchDataInput(this.branchLengthsPanel, 0, 0, true);
            this.branchLengthsDataInput.setAdapters(null, false, false, true, true, true, "");
            this.branchLengthsDataInput.setSelectedAdapter(BranchLengthAdapter.class);
            this.branchLengthsDataInput.setID(DEFAULT_BRANCH_LENGTH_ID);
        }
        return this.branchLengthsPanel;
    }

    private NewNodeBranchDataInput getBranchLengthsDataInput() {
        this.getBranchLengthsPanel();
        return this.branchLengthsDataInput;
    }
}

