/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.treegraph.document.io.MultipleDocumentIterator;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.nexus.NexusFilter;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextElementDataAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.undo.file.NodeSupportEdit;
import info.bioinfweb.treegraph.gui.dialogs.io.FileDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NewNodeBranchDataInput;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NodeSupportDialog
extends FileDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel fileChooserPanel = null;
    private JFileChooser fileChooser = null;
    private NexusFilter nexusFilter = null;
    private JPanel nodeBranchDataPanel = null;
    private JPanel normalisationPanel = null;
    private JCheckBox normalisationCheckBox = null;
    private JTextField normalisationTextField = null;
    private NewNodeBranchDataInput destInput = null;
    private NodeBranchDataInput terminalInput = null;
    private JLabel destInputLabel = null;
    private JLabel terminalsInputLabel = null;
    private double normalisationBorder = 0.0;

    public NodeSupportDialog(Frame owner) {
        super(owner, FileDialog.Option.FILE_MUST_EXIST);
        this.initialize();
        this.setHelpCode(59);
    }

    @Override
    protected boolean onApply(File file) {
        boolean result = true;
        NodeBranchDataAdapter adapter = this.getDestInput().getSelectedAdapter();
        if (this.normalisationCheckBox.isSelected()) {
            this.normalisationBorder = Double.valueOf(this.normalisationTextField.getText());
        }
        if (!this.normalisationCheckBox.isSelected()) {
            this.normalisationBorder = -1.0;
        }
        if (adapter instanceof NewNodeBranchDataAdapter) {
            String id = ((NewNodeBranchDataAdapter)adapter).getID();
            if (IDManager.idExistsInSubtree(this.getDocument().getTree().getPaintStart(), id)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The ID " + id + " already exists", "Error", 0);
                result = false;
            }
        }
        if (result) {
            NodeSupportEdit edit = new NodeSupportEdit(this.getDocument(), (TextElementDataAdapter)this.getTerminalInput().getSelectedAdapter(), this.getDestInput().getSelectedAdapter(), NodeNameAdapter.getSharedInstance(), false, new MultipleDocumentIterator(this.getFileChooser().getSelectedFiles(), (ApplicationLogger)MainFrame.getInstance().getReadWriteLogDialog(), NodeNameAdapter.getSharedInstance(), BranchLengthAdapter.getSharedInstance(), false), this.normalisationBorder);
            this.getDocument().executeEdit(edit);
        }
        return result;
    }

    @Override
    protected boolean onExecute() {
        if (!this.getDocument().getTree().isEmpty()) {
            this.getDestInput().setAdapters(this.getDocument().getTree(), true, false, false, true, false, "");
            this.getTerminalInput().setAdapters(this.getDocument().getTree(), true, false, false, false, true, "");
            return true;
        }
        JOptionPane.showMessageDialog(MainFrame.getInstance(), "The document cannot be empty.", "Error", 0);
        return false;
    }

    private NewNodeBranchDataInput getDestInput() {
        this.getNodeBranchDataPanel();
        return this.destInput;
    }

    private NodeBranchDataInput getTerminalInput() {
        this.getNodeBranchDataPanel();
        return this.terminalInput;
    }

    private void initialize() {
        this.setSize(600, 500);
        this.setContentPane(this.getJContentPane());
        this.getApplyButton().setVisible(false);
        this.getCancelButton().setVisible(true);
    }

    private JPanel getFileChooserPanel() {
        if (this.fileChooserPanel == null) {
            this.fileChooserPanel = new JPanel();
            this.fileChooserPanel.setLayout(new BoxLayout(this.getFileChooserPanel(), 1));
            this.fileChooserPanel.setBorder(BorderFactory.createTitledBorder(null, "Source file", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.fileChooserPanel.add((Component)this.getFileChooser(), null);
        }
        return this.fileChooserPanel;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.setPreferredSize(new Dimension(520, 402));
            this.jContentPane.add((Component)this.getFileChooserPanel(), null);
            this.jContentPane.add((Component)this.getNodeBranchDataPanel(), null);
            this.jContentPane.add((Component)this.getNormalisationPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    @Override
    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setDialogType(0);
            this.fileChooser.setControlButtonsAreShown(false);
            this.nexusFilter = new NexusFilter();
            if (this.fileChooser.getFileFilter() != null) {
                this.fileChooser.removeChoosableFileFilter(this.fileChooser.getFileFilter());
            }
            this.fileChooser.addChoosableFileFilter(this.nexusFilter);
            this.fileChooser.addChoosableFileFilter(ReadWriteFactory.getInstance().getFilter(ReadWriteFormat.NEWICK));
            this.fileChooser.setFileFilter(this.nexusFilter);
        }
        return this.fileChooser;
    }

    private JPanel getNodeBranchDataPanel() {
        if (this.nodeBranchDataPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            this.terminalsInputLabel = new JLabel();
            this.terminalsInputLabel.setText("Terminals identification colum: ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            this.destInputLabel = new JLabel();
            this.destInputLabel.setText("Node frequency colum: ");
            this.nodeBranchDataPanel = new JPanel();
            this.nodeBranchDataPanel.setLayout(new GridBagLayout());
            this.nodeBranchDataPanel.setBorder(BorderFactory.createTitledBorder(null, "Import column", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.nodeBranchDataPanel.add((Component)this.destInputLabel, gridBagConstraints2);
            this.nodeBranchDataPanel.add((Component)this.terminalsInputLabel, gridBagConstraints3);
            this.destInput = new NewNodeBranchDataInput(this.nodeBranchDataPanel, 1, 1, true);
            this.terminalInput = new NodeBranchDataInput(this.nodeBranchDataPanel, 1, 2);
        }
        return this.nodeBranchDataPanel;
    }

    private JPanel getNormalisationPanel() {
        if (this.normalisationPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.anchor = 10;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 0;
            this.normalisationPanel = new JPanel();
            this.normalisationPanel.setLayout(new GridBagLayout());
            this.normalisationPanel.setBorder(BorderFactory.createTitledBorder(null, "Normalisation", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.normalisationPanel.add((Component)this.getNormalisationCheckBox(), gridBagConstraints);
            this.normalisationPanel.add((Component)this.getNormalisationTextField(), gridBagConstraints1);
        }
        return this.normalisationPanel;
    }

    private JCheckBox getNormalisationCheckBox() {
        if (this.normalisationCheckBox == null) {
            this.normalisationCheckBox = new JCheckBox();
            this.normalisationCheckBox.setText("Normalise to specific border:");
            this.normalisationCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NodeSupportDialog.this.getNormalisationTextField().setEnabled(NodeSupportDialog.this.getNormalisationCheckBox().isSelected());
                }
            });
        }
        return this.normalisationCheckBox;
    }

    private JTextField getNormalisationTextField() {
        if (this.normalisationTextField == null) {
            this.normalisationTextField = new JTextField();
            this.normalisationTextField.setEnabled(false);
        }
        return this.normalisationTextField;
    }
}

