/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.io.newick.NewickException;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewickExceptionDialog
extends OkCancelApplyWikiHelpDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel messagePanel = null;
    private JLabel sourceBeforeLabel = null;
    private JLabel headingLabel = null;
    private JLabel sourceAfterLabel = null;
    private JLabel messageLabel = null;
    private JLabel messageContentLabel = null;
    private JLabel positionLabel = null;
    private JLabel positionContentLabel = null;
    private JLabel sourceLabel = null;
    private JLabel positionArrowLabel = null;

    public NewickExceptionDialog(Dialog owner) {
        super(owner, Main.getInstance().getWikiHelp());
        this.setHelpCode(53);
        this.initialize();
    }

    public void show(NewickException exception) {
        this.messageContentLabel.setText(exception.getMessage());
        this.positionContentLabel.setText("" + exception.getPosition());
        this.sourceBeforeLabel.setText(exception.getSourceBefore());
        this.sourceAfterLabel.setText(exception.getSourceAfter());
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.execute();
    }

    protected boolean apply() {
        return true;
    }

    private void initialize() {
        this.setSize(500, 200);
        this.setTitle("Newick syntax error");
        this.setContentPane(this.getJContentPane());
        this.getApplyButton().setVisible(false);
        this.getCancelButton().setVisible(false);
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getMessagePanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 4;
            this.positionArrowLabel = new JLabel();
            this.positionArrowLabel.setText("^");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(3, 3, 0, 0);
            gridBagConstraints7.gridy = 3;
            this.sourceLabel = new JLabel();
            this.sourceLabel.setText("Source: ");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(3, 3, 3, 0);
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.gridy = 2;
            this.positionContentLabel = new JLabel();
            this.positionContentLabel.setText("JLabel");
            this.positionContentLabel.setFont(new Font("Dialog", 0, 12));
            this.positionContentLabel.setDisplayedMnemonic(0);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(3, 3, 3, 0);
            gridBagConstraints5.gridy = 2;
            this.positionLabel = new JLabel();
            this.positionLabel.setText("Position: ");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 3, 3, 0);
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridy = 1;
            this.messageContentLabel = new JLabel();
            this.messageContentLabel.setText("JLabel");
            this.messageContentLabel.setFont(new Font("Dialog", 0, 12));
            this.messageContentLabel.setDisplayedMnemonic(0);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(3, 3, 3, 0);
            gridBagConstraints3.gridy = 1;
            this.messageLabel = new JLabel();
            this.messageLabel.setText("Message: ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
            gridBagConstraints2.gridy = 3;
            this.sourceAfterLabel = new JLabel();
            this.sourceAfterLabel.setText("JLabel");
            this.sourceAfterLabel.setFont(new Font("Monospaced", 0, 12));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridwidth = 3;
            gridBagConstraints1.insets = new Insets(0, 3, 3, 0);
            gridBagConstraints1.gridy = 0;
            this.headingLabel = new JLabel();
            this.headingLabel.setFont(new Font("Dialog", 1, 12));
            this.headingLabel.setText("The Newick string in the file you are trying to open seems to contain a syntax error.");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(3, 3, 0, 0);
            gridBagConstraints.gridy = 3;
            this.sourceBeforeLabel = new JLabel();
            this.sourceBeforeLabel.setText("JLabel");
            this.sourceBeforeLabel.setFont(new Font("Monospaced", 0, 12));
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new GridBagLayout());
            this.messagePanel.setFont(new Font("Monospaced", 0, 12));
            this.messagePanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.messagePanel.add((Component)this.sourceBeforeLabel, gridBagConstraints);
            this.messagePanel.add((Component)this.headingLabel, gridBagConstraints1);
            this.messagePanel.add((Component)this.sourceAfterLabel, gridBagConstraints2);
            this.messagePanel.add((Component)this.messageLabel, gridBagConstraints3);
            this.messagePanel.add((Component)this.messageContentLabel, gridBagConstraints4);
            this.messagePanel.add((Component)this.positionLabel, gridBagConstraints5);
            this.messagePanel.add((Component)this.positionContentLabel, gridBagConstraints6);
            this.messagePanel.add((Component)this.sourceLabel, gridBagConstraints7);
            this.messagePanel.add((Component)this.positionArrowLabel, gridBagConstraints8);
        }
        return this.messagePanel;
    }
}

