/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.plaf.basic.BasicFileChooserUI;

public abstract class FileDialog
extends EditDialog {
    private Option option = Option.NONE;

    public FileDialog(Dialog owner, Option option) {
        super(owner);
        this.option = option;
        this.init();
    }

    public FileDialog(Frame owner, Option option) {
        super(owner);
        this.option = option;
        this.init();
    }

    private void init() {
        CurrentDirectoryModel.getInstance().addFileChooser(this.getFileChooser());
    }

    protected abstract JFileChooser getFileChooser();

    protected File getSelectedFile() {
        return this.getFileChooser().getSelectedFile();
    }

    public boolean execute() {
        this.getFileChooser().rescanCurrentDirectory();
        return super.execute();
    }

    protected abstract boolean onApply(File var1);

    protected boolean apply() {
        if (this.getFileChooser().getUI() instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)this.getFileChooser().getUI()).getApproveSelectionAction().actionPerformed(null);
        }
        this.getFileChooser().approveSelection();
        File file = this.getSelectedFile();
        if (file != null) {
            boolean exists = file.exists();
            if (!this.option.equals((Object)Option.FILE_MUST_EXIST) || exists) {
                boolean write = true;
                if (this.option.equals((Object)Option.ASK_TO_OVERWRITE) && exists) {
                    boolean bl = write = JOptionPane.showConfirmDialog((Component)((Object)this), "The file \"" + file.getAbsolutePath() + "\" already exists.\n" + "Do you want to overwrite it?", "Overwrite file", 0, 2) == 0;
                }
                if (write) {
                    return this.onApply(file);
                }
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "The file \"" + file.getAbsolutePath() + "\" could not be found.", "File not found", 0);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "You did not select any file.", "No file selected", 0);
        }
        return false;
    }

    public static enum Option {
        NONE,
        FILE_MUST_EXIST,
        ASK_TO_OVERWRITE;

    }
}

