/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.DocumentReader;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.io.SupportedFormatsFilter;
import info.bioinfweb.treegraph.document.io.nexus.NexusFilter;
import info.bioinfweb.treegraph.document.io.phyloxml.PhyloXMLFilter;
import info.bioinfweb.treegraph.document.io.xtg.XTGFilter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextElementDataAdapter;
import info.bioinfweb.treegraph.document.undo.file.AddSupportValuesParameters;
import info.bioinfweb.treegraph.gui.dialogs.io.FileDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.TreeSelectionDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.TextIDElementTypeInput;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddSupportValuesDialog
extends FileDialog {
    private JPanel jContentPane = null;
    private JPanel fileChooserPanel = null;
    private JFileChooser fileChooser;
    private JPanel idNamePanel = null;
    private JTextField idNameTextField = null;
    private NodeBranchDataInput terminalDataInput = null;
    private JLabel prefixLabel = null;
    private TextIDElementTypeInput targetTypePanel = null;
    private JPanel terminalsPanel = null;
    private JLabel terminalsLabel = null;
    private JCheckBox translateInternalsCheckBox = null;
    private JCheckBox parseNumericValuesCheckBox;
    private JPanel importPanel = null;
    private File file;
    private NexusFilter nexusFilter;
    private XTGFilter xtgFilter;
    private PhyloXMLFilter phyloXMLFilter;

    public AddSupportValuesDialog(Frame owner) {
        super(owner, FileDialog.Option.FILE_MUST_EXIST);
        this.setHelpCode(85);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        if (!this.getDocument().getTree().isEmpty()) {
            this.getTerminalDataInput().setAdapters(this.getDocument().getTree(), false, true, false, false, false, "");
            this.getTerminalDataInput().setSelectedAdapter(this.getDocument().getDefaultLeafAdapter());
            return true;
        }
        JOptionPane.showMessageDialog(MainFrame.getInstance(), "The document cannot be empty.", "Error", 0);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean assignParameters(AddSupportValuesParameters parameters) {
        DocumentReader reader = ReadWriteFactory.getInstance().getReader(this.file);
        try {
            ReadWriteParameterMap parameterMap = new ReadWriteParameterMap();
            parameterMap.putApplicationLogger((ApplicationLogger)MainFrame.getInstance().getReadWriteLogDialog());
            parameterMap.put("treeSelector", TreeSelectionDialog.getInstance());
            parameterMap.put("translateInternalNodeNames", this.getTranslateInternalsCheckBox().isSelected());
            Document sourceDoc = reader.read(this.getFileChooser().getSelectedFile(), parameterMap);
            boolean rooted = sourceDoc.getTree().getFormats().getShowRooted();
            if (rooted != this.getDocument().getTree().getFormats().getShowRooted()) {
                Object[] options = new String[]{"Regard both trees as unrooted", "Regard both trees as rooted", "Cancel"};
                switch (JOptionPane.showOptionDialog((Component)((Object)this), "The source and the target are incompatible because they are not both rooted or both unrooted.\n\nWhat do you want to do?", "Incompatible trees", 2, 2, null, options, options[0])) {
                    case 0: {
                        rooted = false;
                        break;
                    }
                    case 1: {
                        rooted = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            parameters.setSourceDocument(sourceDoc);
            parameters.setIdPrefix(this.getIDNameTextField().getText());
            parameters.setRooted(rooted);
            parameters.setTerminalsAdapter((TextElementDataAdapter)this.getTerminalDataInput().getSelectedAdapter());
            parameters.setTargetType(this.getTargetTypePanel().getSelectedType());
            parameters.setParseNumericValues(this.parseNumericValuesCheckBox.isSelected());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The error \"" + e.getMessage() + "\" occured when trying to open the file \"" + this.file.getAbsolutePath() + "\"", "Error", 0);
            return false;
        }
    }

    @Override
    protected boolean onApply(File file) {
        this.file = file;
        if (this.getIDNameTextField().getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "A target node/branch data ID prefix must be specified.", "Missing target ID prefix", 0);
            return false;
        }
        return true;
    }

    private void initialize() {
        this.setTitle("Add support values");
        this.setContentPane(this.getJContentPane());
        this.getApplyButton().setVisible(false);
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getFileChooserPanel(), null);
            this.jContentPane.add((Component)this.getImportPanel(), null);
            this.jContentPane.add((Component)this.getTerminalsPanel(), null);
            this.jContentPane.add((Component)this.getIDNamePanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
            this.getApplyButton().setVisible(false);
            this.getOkButton().setText("Next >");
        }
        return this.jContentPane;
    }

    private JPanel getFileChooserPanel() {
        if (this.fileChooserPanel == null) {
            this.fileChooserPanel = new JPanel();
            this.fileChooserPanel.setLayout(new BoxLayout(this.getFileChooserPanel(), 1));
            this.fileChooserPanel.setBorder(BorderFactory.createTitledBorder(null, "Source file", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.fileChooserPanel.add((Component)this.getFileChooser(), null);
        }
        return this.fileChooserPanel;
    }

    @Override
    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(0);
            this.fileChooser.setControlButtonsAreShown(false);
            if (this.fileChooser.getFileFilter() != null) {
                this.fileChooser.removeChoosableFileFilter(this.fileChooser.getFileFilter());
            }
            SupportedFormatsFilter supportedFormatsFilter = new SupportedFormatsFilter();
            this.fileChooser.addChoosableFileFilter(supportedFormatsFilter);
            this.nexusFilter = new NexusFilter();
            this.fileChooser.addChoosableFileFilter(this.nexusFilter);
            this.fileChooser.addChoosableFileFilter(ReadWriteFactory.getInstance().getFilter(ReadWriteFormat.NEWICK));
            this.xtgFilter = new XTGFilter();
            this.fileChooser.addChoosableFileFilter(this.xtgFilter);
            this.phyloXMLFilter = new PhyloXMLFilter();
            this.fileChooser.addChoosableFileFilter(this.phyloXMLFilter);
            this.fileChooser.setFileFilter(supportedFormatsFilter);
            this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("fileFilterChanged")) {
                        AddSupportValuesDialog.this.getTranslateInternalsCheckBox().setEnabled(e.getNewValue() instanceof NexusFilter);
                        AddSupportValuesDialog.this.getParseNumericValuesCheckBox().setEnabled(e.getNewValue() instanceof XTGFilter);
                    } else if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                        File file = AddSupportValuesDialog.this.getFileChooser().getSelectedFile();
                        AddSupportValuesDialog.this.getTranslateInternalsCheckBox().setEnabled(file != null && AddSupportValuesDialog.this.nexusFilter.accept(file));
                        AddSupportValuesDialog.this.getParseNumericValuesCheckBox().setEnabled(file != null && AddSupportValuesDialog.this.xtgFilter.accept(file));
                    }
                }
            });
        }
        return this.fileChooser;
    }

    private JPanel getIDNamePanel() {
        if (this.idNamePanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            this.prefixLabel = new JLabel();
            this.prefixLabel.setText("ID prefix: ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            this.idNamePanel = new JPanel();
            this.idNamePanel.setLayout(new GridBagLayout());
            this.idNamePanel.setBorder(BorderFactory.createTitledBorder(null, "Target data", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.idNamePanel.add((Component)this.getIDNameTextField(), gridBagConstraints);
            this.idNamePanel.add((Component)this.prefixLabel, gridBagConstraints1);
            this.idNamePanel.add((Component)this.getTargetTypePanel(), gridBagConstraints2);
        }
        return this.idNamePanel;
    }

    private JTextField getIDNameTextField() {
        if (this.idNameTextField == null) {
            this.idNameTextField = new JTextField();
        }
        return this.idNameTextField;
    }

    private TextIDElementTypeInput getTargetTypePanel() {
        if (this.targetTypePanel == null) {
            this.targetTypePanel = new TextIDElementTypeInput();
        }
        return this.targetTypePanel;
    }

    private JPanel getTerminalsPanel() {
        if (this.terminalsPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            this.terminalsLabel = new JLabel();
            this.terminalsLabel.setText("Node data that contains same terminal names as used in the import file: ");
            this.terminalsPanel = new JPanel();
            this.terminalsPanel.setLayout(new GridBagLayout());
            this.terminalsPanel.setBorder(BorderFactory.createTitledBorder(null, "Terminals", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.terminalsPanel.add((Component)this.terminalsLabel, gridBagConstraints6);
            this.terminalDataInput = new NodeBranchDataInput(this.terminalsPanel, 1, 0);
        }
        return this.terminalsPanel;
    }

    public NodeBranchDataInput getTerminalDataInput() {
        this.getTerminalsPanel();
        return this.terminalDataInput;
    }

    private JCheckBox getTranslateInternalsCheckBox() {
        if (this.translateInternalsCheckBox == null) {
            this.translateInternalsCheckBox = new JCheckBox();
            this.translateInternalsCheckBox.setText("Translate internal node names");
        }
        return this.translateInternalsCheckBox;
    }

    private JPanel getImportPanel() {
        if (this.importPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            this.importPanel = new JPanel();
            this.importPanel.setLayout(new GridBagLayout());
            this.importPanel.setBorder(BorderFactory.createTitledBorder(null, "Import", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            GridBagConstraints gbc_chckbxNewCheckBox = new GridBagConstraints();
            gbc_chckbxNewCheckBox.anchor = 17;
            gbc_chckbxNewCheckBox.insets = new Insets(2, 2, 2, 2);
            gbc_chckbxNewCheckBox.weightx = 1.0;
            gbc_chckbxNewCheckBox.gridx = 1;
            gbc_chckbxNewCheckBox.gridy = 0;
            this.importPanel.add((Component)this.getParseNumericValuesCheckBox(), gbc_chckbxNewCheckBox);
            this.importPanel.add((Component)this.getTranslateInternalsCheckBox(), gridBagConstraints7);
        }
        return this.importPanel;
    }

    private JCheckBox getParseNumericValuesCheckBox() {
        if (this.parseNumericValuesCheckBox == null) {
            this.parseNumericValuesCheckBox = new JCheckBox("Try to import textual values as numerical support");
        }
        return this.parseNumericValuesCheckBox;
    }
}

