/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.io;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.undo.file.AddSupportValuesParameters;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddSupportValueColumnsDialog
extends OkCancelApplyWikiHelpDialog {
    private JPanel jContentPane;
    private JPanel importSupportValuesPanel;
    private JLabel supportColumnLabel;
    private NodeBranchDataInput supportColumnInput;
    private JLabel leavesColumnLabel;
    private NodeBranchDataInput leavesColumnInput;
    private AddSupportValuesParameters addSupportValuesParameters;

    public AddSupportValueColumnsDialog(Frame owner) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.setHelpCode(84);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    public boolean execute(AddSupportValuesParameters addSupportValuesParameters, Tree tree) {
        this.addSupportValuesParameters = addSupportValuesParameters;
        this.supportColumnInput.setAdapters(tree, false, true, true, false, false, "");
        this.supportColumnInput.setSelectedAdapter(addSupportValuesParameters.getSourceDocument().getDefaultSupportAdapter());
        this.leavesColumnInput.setAdapters(tree, true, true, false, false, false, "");
        this.leavesColumnInput.setSelectedAdapter(NodeNameAdapter.class);
        this.pack();
        return this.execute();
    }

    protected boolean apply() {
        this.addSupportValuesParameters.setSourceSupportColumn(this.supportColumnInput.getSelectedAdapter());
        this.addSupportValuesParameters.setSourceLeavesColumn(this.leavesColumnInput.getSelectedAdapter());
        return true;
    }

    private void initialize() {
        this.setTitle("Select columns for import");
        this.getApplyButton().setVisible(false);
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add((Component)this.getImportSupportValuesPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getImportSupportValuesPanel() {
        if (this.importSupportValuesPanel == null) {
            this.importSupportValuesPanel = new JPanel();
            this.importSupportValuesPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_supportColumnLabel = new GridBagConstraints();
            gbc_supportColumnLabel.gridx = 0;
            gbc_supportColumnLabel.anchor = 17;
            gbc_supportColumnLabel.gridy = 0;
            gbc_supportColumnLabel.insets = new Insets(5, 3, 5, 0);
            this.importSupportValuesPanel.add((Component)this.getSupportColumnLabel(), gbc_supportColumnLabel);
            this.supportColumnInput = new NodeBranchDataInput(this.importSupportValuesPanel, 1, 0);
            GridBagConstraints gbc_lblNodebranchDataColumn = new GridBagConstraints();
            gbc_lblNodebranchDataColumn.anchor = 17;
            gbc_lblNodebranchDataColumn.gridx = 0;
            gbc_lblNodebranchDataColumn.gridy = 1;
            gbc_lblNodebranchDataColumn.insets = new Insets(5, 3, 5, 0);
            this.importSupportValuesPanel.add((Component)this.getLeavesColumnLabel(), gbc_lblNodebranchDataColumn);
            this.leavesColumnInput = new NodeBranchDataInput(this.importSupportValuesPanel, 1, 1);
        }
        return this.importSupportValuesPanel;
    }

    private JLabel getSupportColumnLabel() {
        if (this.supportColumnLabel == null) {
            this.supportColumnLabel = new JLabel();
            this.supportColumnLabel.setText("Node/branch data column in imported document containing support values: ");
        }
        return this.supportColumnLabel;
    }

    private JLabel getLeavesColumnLabel() {
        if (this.leavesColumnLabel == null) {
            this.leavesColumnLabel = new JLabel("Node/branch data column in imported document identifying the leaves: ");
        }
        return this.leavesColumnLabel;
    }
}

