/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.ScaleValue;
import info.bioinfweb.treegraph.gui.dialogs.DecimalUnitInput;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ScaleValueInput
extends DecimalUnitInput {
    public static final String UNIT_SCALE = "branch length units";
    private String previousUnit = "mm";
    private float branchLengthScale = 1.0f;

    public ScaleValueInput(String labelText, JPanel panel, int y) {
        super(labelText, panel, y);
    }

    public float getBranchLengthScale() {
        return this.branchLengthScale;
    }

    public void setBranchLengthScale(float branchLengthScale) {
        this.branchLengthScale = branchLengthScale;
    }

    protected void customizeComboBox(JComboBox comboBox) {
        comboBox.addItem("mm");
        comboBox.addItem("pt");
        comboBox.addItem(UNIT_SCALE);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String currentUnit = (String)e.getItem();
                    if (currentUnit.equals("mm")) {
                        if (ScaleValueInput.this.previousUnit.equals("pt")) {
                            ScaleValueInput.this.getTextField().setText("" + DistanceValue.pointsToMillimeters(ScaleValueInput.this.parseFloat()));
                        } else {
                            ScaleValueInput.this.getTextField().setText("" + ScaleValue.unitsToMillimeters(ScaleValueInput.this.parseFloat(), ScaleValueInput.this.getBranchLengthScale()));
                        }
                    } else if (currentUnit.equals("pt")) {
                        if (ScaleValueInput.this.previousUnit.equals("mm")) {
                            ScaleValueInput.this.getTextField().setText("" + DistanceValue.millimetersToPoints(ScaleValueInput.this.parseFloat()));
                        } else {
                            ScaleValueInput.this.getTextField().setText("" + ScaleValue.unitsToPoints(ScaleValueInput.this.parseFloat(), ScaleValueInput.this.getBranchLengthScale()));
                        }
                    } else if (ScaleValueInput.this.previousUnit.equals("mm")) {
                        ScaleValueInput.this.getTextField().setText("" + ScaleValue.millimetersToUnits(ScaleValueInput.this.parseFloat(), ScaleValueInput.this.getBranchLengthScale()));
                    } else {
                        ScaleValueInput.this.getTextField().setText("" + ScaleValue.pointsToUnits(ScaleValueInput.this.parseFloat(), ScaleValueInput.this.getBranchLengthScale()));
                    }
                    ScaleValueInput.this.previousUnit = currentUnit;
                }
            }
        });
    }

    public void setValue(ScaleValue value) {
        String unit = (String)this.getComboBox().getSelectedItem();
        if (unit.equals("mm")) {
            this.setValue(value.getInMillimeters(this.branchLengthScale));
        } else if (unit.equals("pt")) {
            this.setValue(value.getInPoints(this.branchLengthScale));
        } else {
            this.setValue(value.getInUnits(this.branchLengthScale));
        }
    }

    public void assignValueTo(ScaleValue target) {
        float value = this.parseFloat();
        String unit = (String)this.getComboBox().getSelectedItem();
        if (unit.equals("mm")) {
            target.setInMillimeters(value);
        } else if (unit.equals("pt")) {
            target.setInPoints(value);
        } else {
            target.setInUnits(value);
        }
    }

    public ScaleValue getValue() {
        ScaleValue result = new ScaleValue();
        this.assignValueTo(result);
        return result;
    }
}

