/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.swing.DecimalInput;
import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.treegraph.document.ScaleBar;
import info.bioinfweb.treegraph.document.format.ScaleBarAlignment;
import info.bioinfweb.treegraph.document.format.ScaleBarFormats;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.ScaleBarFormatsOperator;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsDialog;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ScaleBarIntervalKeyListener;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ScaleValueInput;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

public class ScaleBarPanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private ElementFormatsDialog owner = null;
    private JPanel alignmentPanel = null;
    private JRadioButton leftRadioButton = null;
    private JRadioButton rightRadioButton = null;
    private JRadioButton treeWidthRadioButton = null;
    private ButtonGroup alignGroup = null;
    private SwingChangeMonitor alignMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor increaseMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor startMonitor = new SwingChangeMonitor();
    private JPanel intervalPanel = null;
    private DistanceValueInput treeDistanceInput = null;
    private ScaleValueInput widthInput = null;
    private DistanceValueInput heightInput = null;
    private DecimalInput smallIntervalInput = null;
    private DecimalInput longIntervalInput = null;
    private JPanel dimensionsPanel = null;
    private JPanel startPanel = null;
    private JRadioButton zeroLeftRadioButton = null;
    private JRadioButton zeroRightRadioButton = null;
    private ButtonGroup zeroPosGroup = null;
    private JPanel labelingPanel = null;
    private JPanel directionPanel = null;
    private JRadioButton incRadioButton = null;
    private JRadioButton decRadioButton = null;
    private ButtonGroup increaseGroup = null;
    private JLabel smallIntervalLengthLabel = null;
    private JLabel longIntervalLengthLabel = null;
    private ScaleBarIntervalKeyListener smallIntervalKeyListener = null;
    private ScaleBarIntervalKeyListener longIntervalKeyListener = null;

    public ScaleBarPanel(ElementFormatsDialog owner) {
        this.owner = owner;
        this.initialize();
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.alignMonitor.hasChanged() || this.startMonitor.hasChanged() || this.increaseMonitor.hasChanged() || this.widthInput.getChangeMonitor().hasChanged() || this.heightInput.getChangeMonitor().hasChanged() || this.treeDistanceInput.getChangeMonitor().hasChanged() || this.smallIntervalInput.getChangeMonitor().hasChanged() || this.longIntervalInput.getChangeMonitor().hasChanged()) {
            ScaleBarFormats formats = new ScaleBarFormats();
            if (this.getLeftRadioButton().isSelected()) {
                formats.setAlignment(ScaleBarAlignment.LEFT);
            } else if (this.getRightRadioButton().isSelected()) {
                formats.setAlignment(ScaleBarAlignment.RIGHT);
            } else {
                formats.setAlignment(ScaleBarAlignment.TREE_WIDTH);
            }
            this.treeDistanceInput.assignValueTo(formats.getTreeDistance());
            this.widthInput.assignValueTo(formats.getWidth());
            this.heightInput.assignValueTo(formats.getHeight());
            formats.setStartLeft(this.getZeroLeftRadioButton().isSelected());
            formats.setIncreasing(this.getIncRadioButton().isSelected());
            formats.setSmallInterval(this.smallIntervalInput.parseFloat());
            formats.setLongInterval(this.longIntervalInput.parseInt());
            operators.add(new ScaleBarFormatsOperator(formats));
        }
    }

    @Override
    public void addError(List<String> list) {
        if (this.widthInput.getValue().getStoredValue() <= 0.0f) {
            list.add("The width of the scale bar must be greater than 0.");
        }
        if (this.heightInput.getValue().getInMillimeters() <= 0.0f) {
            list.add("The height of the scale bar must be greater than 0.");
        }
        if (this.smallIntervalInput.parseFloat() <= 0.0f) {
            list.add("The length of a scale bar small interval must be greater than 0.");
        }
        if (this.longIntervalInput.parseFloat() <= 0.0f) {
            list.add("The length of a scale bar long interval must be greater than 0.");
        }
    }

    @Override
    public void resetChangeMonitors() {
        this.alignMonitor.reset();
        this.treeDistanceInput.getChangeMonitor().reset();
        this.widthInput.getChangeMonitor().reset();
        this.heightInput.getChangeMonitor().reset();
        this.smallIntervalInput.getChangeMonitor().reset();
        this.longIntervalInput.getChangeMonitor().reset();
        this.startMonitor.reset();
        this.increaseMonitor.reset();
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result = selection.containsType(ScaleBar.class);
        if (result) {
            ScaleBarFormats formats = selection.getFirstElementOfType(ScaleBar.class).getFormats();
            switch (formats.getAlignment()) {
                case LEFT: {
                    this.getLeftRadioButton().setSelected(true);
                    break;
                }
                case RIGHT: {
                    this.getRightRadioButton().setSelected(true);
                    break;
                }
                default: {
                    this.getTreeWidthRadioButton().setSelected(true);
                }
            }
            this.treeDistanceInput.setValue(formats.getTreeDistance());
            this.widthInput.setBranchLengthScale(this.owner.getDocument().getTree().getFormats().getBranchLengthScale().getInMillimeters());
            this.widthInput.setValue(formats.getWidth());
            this.heightInput.setValue(formats.getHeight());
            this.smallIntervalInput.setValue(formats.getSmallInterval());
            this.longIntervalInput.setValue(formats.getLongInterval());
            this.getSmallIntervalKeyListener().refreshText();
            this.getLongIntervalKeyListener().refreshText();
            if (formats.isStartLeft()) {
                this.getZeroLeftRadioButton().setSelected(true);
            } else {
                this.getZeroRightRadioButton().setSelected(true);
            }
            if (formats.isIncreasing()) {
                this.getIncRadioButton().setSelected(true);
            } else {
                this.getDecRadioButton().setSelected(true);
            }
        }
        return result;
    }

    @Override
    public String title() {
        return "Scale bar formats";
    }

    private void initialize() {
        this.setSize(320, 400);
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getAlignmentPanel(), null);
        this.add((Component)this.getDimensionsPanel(), null);
        this.add((Component)this.getLabelingPanel(), null);
        this.add((Component)this.getIntervalPanel(), null);
    }

    private JPanel getAlignmentPanel() {
        if (this.alignmentPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridy = 0;
            this.alignmentPanel = new JPanel();
            this.alignmentPanel.setLayout(new GridBagLayout());
            this.alignmentPanel.setBorder(BorderFactory.createTitledBorder(null, "Alignment", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.alignmentPanel.add((Component)this.getRightRadioButton(), gridBagConstraints1);
            this.alignmentPanel.add((Component)this.getTreeWidthRadioButton(), gridBagConstraints2);
            this.alignmentPanel.add((Component)this.getLeftRadioButton(), gridBagConstraints11);
            this.getAlignGroup();
        }
        return this.alignmentPanel;
    }

    private JRadioButton getLeftRadioButton() {
        if (this.leftRadioButton == null) {
            this.leftRadioButton = new JRadioButton();
            this.leftRadioButton.setText("Left");
            this.leftRadioButton.setSelected(true);
            this.leftRadioButton.getModel().addChangeListener((ChangeListener)this.alignMonitor);
        }
        return this.leftRadioButton;
    }

    private JRadioButton getRightRadioButton() {
        if (this.rightRadioButton == null) {
            this.rightRadioButton = new JRadioButton();
            this.rightRadioButton.setText("Right");
            this.rightRadioButton.getModel().addChangeListener((ChangeListener)this.alignMonitor);
        }
        return this.rightRadioButton;
    }

    private JRadioButton getTreeWidthRadioButton() {
        if (this.treeWidthRadioButton == null) {
            this.treeWidthRadioButton = new JRadioButton();
            this.treeWidthRadioButton.setText("Whole tree width (left and right)");
            this.treeWidthRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ScaleBarPanel.this.widthInput.setEnabled(e.getStateChange() != 1);
                }
            });
            this.treeWidthRadioButton.getModel().addChangeListener((ChangeListener)this.alignMonitor);
        }
        return this.treeWidthRadioButton;
    }

    private ButtonGroup getAlignGroup() {
        if (this.alignGroup == null) {
            this.alignGroup = new ButtonGroup();
            this.alignGroup.add(this.getLeftRadioButton());
            this.alignGroup.add(this.getRightRadioButton());
            this.alignGroup.add(this.getTreeWidthRadioButton());
        }
        return this.alignGroup;
    }

    private ScaleBarIntervalKeyListener getSmallIntervalKeyListener() {
        this.getIntervalPanel();
        return this.smallIntervalKeyListener;
    }

    private ScaleBarIntervalKeyListener getLongIntervalKeyListener() {
        this.getIntervalPanel();
        return this.longIntervalKeyListener;
    }

    private JPanel getIntervalPanel() {
        if (this.intervalPanel == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.anchor = 13;
            gridBagConstraints21.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints21.gridy = 3;
            this.longIntervalLengthLabel = new JLabel();
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints12.gridy = 1;
            this.smallIntervalLengthLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            this.intervalPanel = new JPanel();
            this.intervalPanel.setLayout(new GridBagLayout());
            this.intervalPanel.setBorder(BorderFactory.createTitledBorder(null, "Intervals", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.intervalPanel.add((Component)this.smallIntervalLengthLabel, gridBagConstraints12);
            this.intervalPanel.add((Component)this.longIntervalLengthLabel, gridBagConstraints21);
            this.smallIntervalInput = new DecimalInput("Small interval [branch length units]: ", this.intervalPanel, 0, "#.#######");
            this.longIntervalInput = new DecimalInput("Long interval [small intervals]: ", this.intervalPanel, 2, "#");
            this.smallIntervalKeyListener = new ScaleBarIntervalKeyListener(this.owner, this.smallIntervalLengthLabel, this.smallIntervalInput, null);
            this.longIntervalKeyListener = new ScaleBarIntervalKeyListener(this.owner, this.longIntervalLengthLabel, this.smallIntervalInput, this.longIntervalInput);
            this.smallIntervalInput.getTextField().addKeyListener(this.smallIntervalKeyListener);
            this.smallIntervalInput.getTextField().addKeyListener(this.longIntervalKeyListener);
            this.longIntervalInput.getTextField().addKeyListener(this.longIntervalKeyListener);
        }
        return this.intervalPanel;
    }

    private JPanel getDimensionsPanel() {
        if (this.dimensionsPanel == null) {
            this.dimensionsPanel = new JPanel();
            this.dimensionsPanel.setLayout(new GridBagLayout());
            this.dimensionsPanel.setBorder(BorderFactory.createTitledBorder(null, "Dimensions", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.treeDistanceInput = new DistanceValueInput("Distance to tree: ", this.dimensionsPanel, 0);
            this.widthInput = new ScaleValueInput("Width: ", this.dimensionsPanel, 2);
            this.heightInput = new DistanceValueInput("Height (without label text): ", this.dimensionsPanel, 4);
        }
        return this.dimensionsPanel;
    }

    private JPanel getStartPanel() {
        if (this.startPanel == null) {
            GridBagConstraints rightGBC = new GridBagConstraints();
            rightGBC.anchor = 17;
            rightGBC.gridx = 1;
            rightGBC.gridy = 0;
            rightGBC.weightx = 1.0;
            rightGBC.fill = 0;
            GridBagConstraints leftGBC = new GridBagConstraints();
            leftGBC.anchor = 17;
            leftGBC.weightx = 1.0;
            leftGBC.fill = 0;
            leftGBC.gridx = 0;
            leftGBC.gridy = 0;
            this.startPanel = new JPanel();
            this.startPanel.setLayout(new GridBagLayout());
            this.startPanel.setBorder(BorderFactory.createTitledBorder(null, "Start labeling", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.startPanel.add((Component)this.getZeroLeftRadioButton(), leftGBC);
            this.startPanel.add((Component)this.getZeroRightRadioButton(), rightGBC);
            this.getZeroPosGroup();
        }
        return this.startPanel;
    }

    private JRadioButton getZeroLeftRadioButton() {
        if (this.zeroLeftRadioButton == null) {
            this.zeroLeftRadioButton = new JRadioButton();
            this.zeroLeftRadioButton.setText("Zero on the left");
            this.zeroLeftRadioButton.setSelected(true);
            this.zeroLeftRadioButton.addChangeListener((ChangeListener)this.startMonitor);
        }
        return this.zeroLeftRadioButton;
    }

    private JRadioButton getZeroRightRadioButton() {
        if (this.zeroRightRadioButton == null) {
            this.zeroRightRadioButton = new JRadioButton();
            this.zeroRightRadioButton.setText("Zero on the right");
        }
        return this.zeroRightRadioButton;
    }

    private ButtonGroup getZeroPosGroup() {
        if (this.zeroPosGroup == null) {
            this.zeroPosGroup = new ButtonGroup();
            this.zeroPosGroup.add(this.getZeroLeftRadioButton());
            this.zeroPosGroup.add(this.getZeroRightRadioButton());
        }
        return this.zeroPosGroup;
    }

    private JPanel getLabelingPanel() {
        if (this.labelingPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            this.labelingPanel = new JPanel();
            this.labelingPanel.setLayout(new GridBagLayout());
            this.labelingPanel.add((Component)this.getStartPanel(), gridBagConstraints4);
            this.labelingPanel.add((Component)this.getDirectionPanel(), gridBagConstraints5);
        }
        return this.labelingPanel;
    }

    private JPanel getDirectionPanel() {
        if (this.directionPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridy = 0;
            this.directionPanel = new JPanel();
            this.directionPanel.setLayout(new GridBagLayout());
            this.directionPanel.setBorder(BorderFactory.createTitledBorder(null, "Labeling direction", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.directionPanel.add((Component)this.getIncRadioButton(), gridBagConstraints6);
            this.directionPanel.add((Component)this.getDecRadioButton(), gridBagConstraints7);
            this.getIncreaseGroup();
        }
        return this.directionPanel;
    }

    private JRadioButton getIncRadioButton() {
        if (this.incRadioButton == null) {
            this.incRadioButton = new JRadioButton();
            this.incRadioButton.setText("Increasing");
            this.incRadioButton.setSelected(true);
            this.incRadioButton.addChangeListener((ChangeListener)this.increaseMonitor);
        }
        return this.incRadioButton;
    }

    private JRadioButton getDecRadioButton() {
        if (this.decRadioButton == null) {
            this.decRadioButton = new JRadioButton();
            this.decRadioButton.setText("Decreasing");
        }
        return this.decRadioButton;
    }

    private ButtonGroup getIncreaseGroup() {
        if (this.increaseGroup == null) {
            this.increaseGroup = new ButtonGroup();
            this.increaseGroup.add(this.getIncRadioButton());
            this.increaseGroup.add(this.getDecRadioButton());
        }
        return this.increaseGroup;
    }
}

