/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.swing.DecimalInput;
import info.bioinfweb.treegraph.document.format.ScaleValue;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsDialog;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import javax.swing.JLabel;

public class ScaleBarIntervalKeyListener
extends KeyAdapter {
    public static final DecimalFormat LENGTH_FORMAT = new DecimalFormat("#.###");
    private ElementFormatsDialog owner = null;
    private JLabel label = null;
    private DecimalInput smallIntervalInput = null;
    private DecimalInput longIntervalInput = null;

    public ScaleBarIntervalKeyListener(ElementFormatsDialog owner, JLabel label, DecimalInput smallIntervalInput, DecimalInput longIntervalInput) {
        this.owner = owner;
        this.label = label;
        this.smallIntervalInput = smallIntervalInput;
        this.longIntervalInput = longIntervalInput;
    }

    private String getIntervalLabelText(float brLenUnits) {
        if (this.owner.getDocument() != null) {
            float brLenScale = this.owner.getDocument().getTree().getFormats().getBranchLengthScale().getInMillimeters();
            return " = " + LENGTH_FORMAT.format(ScaleValue.unitsToMillimeters(brLenUnits, brLenScale)) + " mm or " + LENGTH_FORMAT.format(ScaleValue.unitsToPoints(brLenUnits, brLenScale)) + " pt";
        }
        return "";
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (Character.isDigit(e.getKeyChar()) || e.getKeyCode() == 127 || e.getKeyCode() == 8) {
            this.refreshText();
        }
    }

    public void refreshText() {
        try {
            float value = this.smallIntervalInput.parseFloat();
            if (this.longIntervalInput != null) {
                value *= this.longIntervalInput.parseFloat();
            }
            this.label.setText(this.getIntervalLabelText(value));
        }
        catch (NumberFormatException ex) {
            this.label.setText("");
        }
    }
}

