/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.document.format.operate.AbstractTextOperator;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.PieChartCaptionTextOperator;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.DecimalFormatPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsDialog;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.FontColorPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.FontFormatsPanel;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PieChartLabelCaptionsTextFormatsDialog
extends OkCancelApplyWikiHelpDialog {
    private List<ElementFormatsTab> tabs;
    private JPanel jContentPane;
    private JTabbedPane tabbedPane;

    public PieChartLabelCaptionsTextFormatsDialog(Dialog owner) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.setHelpCode(92);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    public void resetChangeMonitors() {
        for (ElementFormatsTab tab : this.getTabs()) {
            tab.resetChangeMonitors();
        }
    }

    public boolean execute() {
        boolean result = super.execute();
        if (!result) {
            this.resetChangeMonitors();
        }
        return result;
    }

    protected boolean apply() {
        return ElementFormatsDialog.checkInputs((Component)((Object)this), this.getTabbedPane(), this.getTabs());
    }

    public void addOperators(List<FormatOperator> operators) {
        List<FormatOperator> directOperators = ElementFormatsDialog.getTabOperators(this.getTabs());
        for (FormatOperator directOperator : directOperators) {
            operators.add(new PieChartCaptionTextOperator((AbstractTextOperator)directOperator));
        }
    }

    public void setValues(PieChartLabelFormats f) {
        for (ElementFormatsTab tab : this.getTabs()) {
            if (tab instanceof FontFormatsPanel) {
                ((FontFormatsPanel)tab).setValue(f.getCaptionsTextFormats());
                continue;
            }
            if (tab instanceof FontColorPanel) {
                ((FontColorPanel)tab).setColor(f.getCaptionsTextFormats().getTextColor());
                continue;
            }
            if (!(tab instanceof DecimalFormatPanel)) continue;
            ((DecimalFormatPanel)tab).setValues(f.getCaptionsTextFormats());
        }
    }

    public List<ElementFormatsTab> getTabs() {
        if (this.tabs == null) {
            this.tabs = new ArrayList<ElementFormatsTab>();
            this.tabs.add(new FontFormatsPanel(false));
            this.tabs.add(new FontColorPanel());
            this.tabs.add(new DecimalFormatPanel());
        }
        return this.tabs;
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("Pie chart label captions text formats");
        this.pack();
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add(this.getTabbedPane());
            this.getApplyButton().setVisible(false);
            this.jContentPane.add(this.getButtonsPanel());
        }
        return this.jContentPane;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1);
            for (ElementFormatsTab tab : this.getTabs()) {
                this.tabbedPane.addTab(tab.title(), (Component)((Object)tab));
            }
        }
        return this.tabbedPane;
    }
}

