/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.LeafMarginBottomOperator;
import info.bioinfweb.treegraph.document.format.operate.LeafMarginLeftOperator;
import info.bioinfweb.treegraph.document.format.operate.LeafMarginRightOperator;
import info.bioinfweb.treegraph.document.format.operate.LeafMarginTopOperator;
import info.bioinfweb.treegraph.gui.dialogs.MarginInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class NodeMarginPanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private JPanel marginPanel = null;
    private MarginInput marginInput = null;

    public NodeMarginPanel() {
        this.initialize();
    }

    @Override
    public String title() {
        return "Leaf margin";
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result;
        Node first = selection.getFirstElementOfType(Node.class);
        boolean bl = result = first != null;
        if (result) {
            this.getMarginInput().setValue(first.getFormats().getLeafMargin());
        }
        return result;
    }

    @Override
    public void addError(List<String> list) {
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.getMarginInput().getLeft().getChangeMonitor().hasChanged()) {
            operators.add(new LeafMarginLeftOperator(this.getMarginInput().getLeft().getValue()));
        }
        if (this.getMarginInput().getTop().getChangeMonitor().hasChanged()) {
            operators.add(new LeafMarginTopOperator(this.getMarginInput().getTop().getValue()));
        }
        if (this.getMarginInput().getRight().getChangeMonitor().hasChanged()) {
            operators.add(new LeafMarginRightOperator(this.getMarginInput().getRight().getValue()));
        }
        if (this.getMarginInput().getBottom().getChangeMonitor().hasChanged()) {
            operators.add(new LeafMarginBottomOperator(this.getMarginInput().getBottom().getValue()));
        }
    }

    @Override
    public void resetChangeMonitors() {
        this.getMarginInput().resetChangeMonitors();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getMarginPanel(), null);
    }

    private JPanel getMarginPanel() {
        if (this.marginPanel == null) {
            this.marginPanel = new JPanel();
            this.marginPanel.setLayout(new GridBagLayout());
            this.marginPanel.setBorder(BorderFactory.createTitledBorder(null, "Margin:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.marginInput = new MarginInput("", this.marginPanel, 0);
        }
        return this.marginPanel;
    }

    private MarginInput getMarginInput() {
        this.getMarginPanel();
        return this.marginInput;
    }
}

