/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.treegraph.document.CornerRadiusElement;
import info.bioinfweb.treegraph.document.LineElement;
import info.bioinfweb.treegraph.document.format.operate.CornerRadiusOperator;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.LineColorOperator;
import info.bioinfweb.treegraph.document.format.operate.LineWidthOperator;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class LinePanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private JColorChooser colorChooser = null;
    private SwingChangeMonitor colorMonitor = new SwingChangeMonitor();
    private JPanel lineColorPanel = null;
    private JPanel otherLineFormatsPanel = null;
    private DistanceValueInput lineWidthInput = null;
    private DistanceValueInput cornerRadiusInput = null;

    public LinePanel() {
        this.initialize();
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result;
        LineElement lineElement = selection.getFirstElementOfType(LineElement.class);
        boolean bl = result = lineElement != null;
        if (result) {
            this.getColorChooser().setColor(lineElement.getFormats().getLineColor());
            this.lineWidthInput.setValue(lineElement.getFormats().getLineWidth());
            CornerRadiusElement cornerRadiusElement = selection.getFirstElementOfType(CornerRadiusElement.class);
            this.cornerRadiusInput.setEnabled(cornerRadiusElement != null);
            if (cornerRadiusElement != null) {
                this.cornerRadiusInput.setValue(cornerRadiusElement.getFormats().getCornerRadius());
            }
        }
        return result;
    }

    @Override
    public String title() {
        return "Line formats";
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.colorMonitor.hasChanged()) {
            operators.add(new LineColorOperator(this.getColorChooser().getColor()));
        }
        if (this.lineWidthInput.getChangeMonitor().hasChanged()) {
            operators.add(new LineWidthOperator(this.lineWidthInput.getValue()));
        }
        if (this.cornerRadiusInput.getChangeMonitor().hasChanged()) {
            operators.add(new CornerRadiusOperator(this.cornerRadiusInput.getValue()));
        }
    }

    @Override
    public void addError(List<String> list) {
        if (this.lineWidthInput.getValue().getInMillimeters() < 0.0f) {
            list.add("The line width cannot be less than 0.");
        }
        if (this.cornerRadiusInput.getValue().getInMillimeters() < 0.0f) {
            list.add("The corner radius cannot be less than 0.");
        }
    }

    @Override
    public void resetChangeMonitors() {
        this.colorMonitor.reset();
        this.lineWidthInput.getChangeMonitor().reset();
        this.cornerRadiusInput.getChangeMonitor().reset();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getLineColorPanel(), null);
        this.add((Component)this.getOtherLineFormatsPanel(), null);
    }

    private JColorChooser getColorChooser() {
        if (this.colorChooser == null) {
            this.colorChooser = new JColorChooser(Color.BLACK);
            this.colorChooser.getSelectionModel().addChangeListener((ChangeListener)this.colorMonitor);
        }
        return this.colorChooser;
    }

    private JPanel getLineColorPanel() {
        if (this.lineColorPanel == null) {
            this.lineColorPanel = new JPanel();
            this.lineColorPanel.setLayout(new BoxLayout(this.getLineColorPanel(), 1));
            this.lineColorPanel.setBorder(BorderFactory.createTitledBorder(null, "Line color:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.lineColorPanel.add((Component)this.getColorChooser(), null);
        }
        return this.lineColorPanel;
    }

    private JPanel getOtherLineFormatsPanel() {
        if (this.otherLineFormatsPanel == null) {
            this.otherLineFormatsPanel = new JPanel();
            this.otherLineFormatsPanel.setLayout(new GridBagLayout());
            this.otherLineFormatsPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.lineWidthInput = new DistanceValueInput("Line width: ", this.otherLineFormatsPanel, 0);
            this.cornerRadiusInput = new DistanceValueInput("Corner radius: ", this.otherLineFormatsPanel, 2);
        }
        return this.otherLineFormatsPanel;
    }
}

