/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import info.bioinfweb.treegraph.document.format.LegendStyle;
import info.bioinfweb.treegraph.document.format.TextOrientation;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.LegendMarginBottomOperator;
import info.bioinfweb.treegraph.document.format.operate.LegendMarginLeftOperator;
import info.bioinfweb.treegraph.document.format.operate.LegendMarginRightOperator;
import info.bioinfweb.treegraph.document.format.operate.LegendMarginTopOperator;
import info.bioinfweb.treegraph.document.format.operate.LegendPositionOperator;
import info.bioinfweb.treegraph.document.format.operate.LegendStyleOperator;
import info.bioinfweb.treegraph.document.format.operate.MinTreeDistanceOperator;
import info.bioinfweb.treegraph.document.format.operate.TextOrientationOperator;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.MarginInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;

public class LegendPanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private DecimalFormat decimalFormat = new DecimalFormat("#########");
    private JPanel legendStylePanel = null;
    private JRadioButton bracketRadioButton = null;
    private JRadioButton braceRadioButton = null;
    private JPanel legendOrientationPanel = null;
    private JRadioButton horizontalRadioButton = null;
    private JRadioButton upRadioButton = null;
    private JRadioButton downRadioButton = null;
    private ButtonGroup styleGroup = null;
    private ButtonGroup orientationGroup = null;
    private SwingChangeMonitor styleMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor orientationMonitor = new SwingChangeMonitor();
    private JPanel legendNumbersPanel = null;
    private JFormattedTextField legendPositionTextField = null;
    private SwingChangeMonitor legendPositionMonitor = new SwingChangeMonitor();
    private DistanceValueInput minTreeDistanceInput = null;
    private JLabel legendOrderLabel = null;
    private JPanel marginPanel = null;
    private MarginInput marginInput = null;

    public LegendPanel() {
        this.initialize();
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result;
        Legend first = selection.getFirstElementOfType(Legend.class);
        boolean bl = result = first != null;
        if (result) {
            LegendFormats f = first.getFormats();
            this.getBraceRadioButton().setSelected(f.getLegendStyle().equals((Object)LegendStyle.BRACE));
            this.getBracketRadioButton().setSelected(f.getLegendStyle().equals((Object)LegendStyle.BRACKET));
            this.getHorizontalRadioButton().setSelected(f.getOrientation().equals((Object)TextOrientation.HORIZONTAL));
            this.getUpRadioButton().setSelected(f.getOrientation().equals((Object)TextOrientation.UP));
            this.getDownRadioButton().setSelected(f.getOrientation().equals((Object)TextOrientation.DOWN));
            this.getLegendPositionTextField().setText(this.decimalFormat.format(f.getPosition()));
            this.minTreeDistanceInput.setValue(f.getMinTreeDistance());
            this.getMarginInput().setValue(first.getFormats().getMargin());
        }
        return result;
    }

    @Override
    public String title() {
        return "Legend formats";
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.styleMonitor.hasChanged()) {
            LegendStyle style = LegendStyle.BRACKET;
            if (this.getBraceRadioButton().isSelected()) {
                style = LegendStyle.BRACE;
            }
            operators.add(new LegendStyleOperator(style));
        }
        if (this.orientationMonitor.hasChanged()) {
            TextOrientation orientation = TextOrientation.DOWN;
            if (this.getHorizontalRadioButton().isSelected()) {
                orientation = TextOrientation.HORIZONTAL;
            } else if (this.getUpRadioButton().isSelected()) {
                orientation = TextOrientation.UP;
            }
            operators.add(new TextOrientationOperator(orientation));
        }
        if (this.legendPositionMonitor.hasChanged()) {
            operators.add(new LegendPositionOperator(Integer.parseInt(this.getLegendPositionTextField().getText())));
        }
        if (this.minTreeDistanceInput.getChangeMonitor().hasChanged()) {
            operators.add(new MinTreeDistanceOperator(this.minTreeDistanceInput.getValue()));
        }
        if (this.getMarginInput().getLeft().getChangeMonitor().hasChanged()) {
            operators.add(new LegendMarginLeftOperator(this.getMarginInput().getLeft().getValue()));
        }
        if (this.getMarginInput().getTop().getChangeMonitor().hasChanged()) {
            operators.add(new LegendMarginTopOperator(this.getMarginInput().getTop().getValue()));
        }
        if (this.getMarginInput().getRight().getChangeMonitor().hasChanged()) {
            operators.add(new LegendMarginRightOperator(this.getMarginInput().getRight().getValue()));
        }
        if (this.getMarginInput().getBottom().getChangeMonitor().hasChanged()) {
            operators.add(new LegendMarginBottomOperator(this.getMarginInput().getBottom().getValue()));
        }
    }

    @Override
    public void addError(List<String> list) {
    }

    @Override
    public void resetChangeMonitors() {
        this.styleMonitor.reset();
        this.orientationMonitor.reset();
        this.legendPositionMonitor.reset();
        this.minTreeDistanceInput.getChangeMonitor().reset();
        this.getMarginInput().resetChangeMonitors();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getLegendStylePanel(), null);
        this.add((Component)this.getLegendOrientationPanel(), null);
        this.add((Component)this.getLegendNumbersPanel(), null);
        this.add((Component)this.getMarginPanel(), null);
    }

    private JPanel getLegendStylePanel() {
        if (this.legendStylePanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            this.legendStylePanel = new JPanel();
            this.legendStylePanel.setLayout(new GridBagLayout());
            this.legendStylePanel.setBorder(BorderFactory.createTitledBorder(null, "Style:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.legendStylePanel.add((Component)this.getBracketRadioButton(), gridBagConstraints);
            this.legendStylePanel.add((Component)this.getBraceRadioButton(), gridBagConstraints1);
            this.getStyleGroup();
        }
        return this.legendStylePanel;
    }

    private JRadioButton getBracketRadioButton() {
        if (this.bracketRadioButton == null) {
            this.bracketRadioButton = new JRadioButton();
            this.bracketRadioButton.setText("Edged bracket");
            this.bracketRadioButton.getModel().addChangeListener((ChangeListener)this.styleMonitor);
        }
        return this.bracketRadioButton;
    }

    private JRadioButton getBraceRadioButton() {
        if (this.braceRadioButton == null) {
            this.braceRadioButton = new JRadioButton();
            this.braceRadioButton.setText("Brace");
            this.braceRadioButton.getModel().addChangeListener((ChangeListener)this.styleMonitor);
        }
        return this.braceRadioButton;
    }

    public ButtonGroup getStyleGroup() {
        if (this.styleGroup == null) {
            this.styleGroup = new ButtonGroup();
            this.styleGroup.add(this.getBraceRadioButton());
            this.styleGroup.add(this.getBracketRadioButton());
        }
        return this.styleGroup;
    }

    private JPanel getLegendOrientationPanel() {
        if (this.legendOrientationPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            this.legendOrientationPanel = new JPanel();
            this.legendOrientationPanel.setLayout(new GridBagLayout());
            this.legendOrientationPanel.setBorder(BorderFactory.createTitledBorder(null, "Text orientation:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.legendOrientationPanel.add((Component)this.getHorizontalRadioButton(), gridBagConstraints2);
            this.legendOrientationPanel.add((Component)this.getUpRadioButton(), gridBagConstraints3);
            this.legendOrientationPanel.add((Component)this.getDownRadioButton(), gridBagConstraints4);
            this.getOrientationGroup();
        }
        return this.legendOrientationPanel;
    }

    private JRadioButton getHorizontalRadioButton() {
        if (this.horizontalRadioButton == null) {
            this.horizontalRadioButton = new JRadioButton();
            this.horizontalRadioButton.setText("Horizontal");
            this.horizontalRadioButton.getModel().addChangeListener((ChangeListener)this.orientationMonitor);
        }
        return this.horizontalRadioButton;
    }

    private JRadioButton getUpRadioButton() {
        if (this.upRadioButton == null) {
            this.upRadioButton = new JRadioButton();
            this.upRadioButton.setText("Upwards");
            this.upRadioButton.getModel().addChangeListener((ChangeListener)this.orientationMonitor);
        }
        return this.upRadioButton;
    }

    private JRadioButton getDownRadioButton() {
        if (this.downRadioButton == null) {
            this.downRadioButton = new JRadioButton();
            this.downRadioButton.setText("Downwards");
            this.downRadioButton.getModel().addChangeListener((ChangeListener)this.orientationMonitor);
        }
        return this.downRadioButton;
    }

    public ButtonGroup getOrientationGroup() {
        if (this.orientationGroup == null) {
            this.orientationGroup = new ButtonGroup();
            this.orientationGroup.add(this.getHorizontalRadioButton());
            this.orientationGroup.add(this.getUpRadioButton());
            this.orientationGroup.add(this.getDownRadioButton());
        }
        return this.orientationGroup;
    }

    private JPanel getLegendNumbersPanel() {
        if (this.legendNumbersPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 0;
            this.legendOrderLabel = new JLabel();
            this.legendOrderLabel.setText("Position index (order): ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            this.legendNumbersPanel = new JPanel();
            this.legendNumbersPanel.setLayout(new GridBagLayout());
            this.legendNumbersPanel.setBorder(BorderFactory.createTitledBorder(null, "Position:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.legendNumbersPanel.add((Component)this.getLegendPositionTextField(), gridBagConstraints);
            this.legendNumbersPanel.add((Component)this.legendOrderLabel, gridBagConstraints11);
            this.minTreeDistanceInput = new DistanceValueInput("Minimal distance to the tree: ", this.legendNumbersPanel, 1);
        }
        return this.legendNumbersPanel;
    }

    private JFormattedTextField getLegendPositionTextField() {
        if (this.legendPositionTextField == null) {
            this.legendPositionTextField = new JFormattedTextField(this.decimalFormat);
            this.legendPositionTextField.getDocument().addDocumentListener((DocumentListener)this.legendPositionMonitor);
        }
        return this.legendPositionTextField;
    }

    private JPanel getMarginPanel() {
        if (this.marginPanel == null) {
            this.marginPanel = new JPanel();
            this.marginPanel.setLayout(new GridBagLayout());
            this.marginPanel.setBorder(BorderFactory.createTitledBorder(null, "Margin:", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.marginInput = new MarginInput("", this.marginPanel, 0);
        }
        return this.marginPanel;
    }

    private MarginInput getMarginInput() {
        this.getMarginPanel();
        return this.marginInput;
    }
}

