/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelAboveOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelLineNumberOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelLinePositionOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelMarginBottomOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelMarginLeftOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelMarginRightOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelMarginTopOperator;
import info.bioinfweb.treegraph.gui.dialogs.MarginInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;

public class LabelPanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private JRadioButton aboveRadioButton = null;
    private JRadioButton belowRadioButton = null;
    private JLabel lineNoLabel = null;
    private JFormattedTextField lineNoTextField = null;
    private JLabel linePosLabel = null;
    private JFormattedTextField linePosTextField = null;
    private ButtonGroup aboveBelowGroup = null;
    private SwingChangeMonitor aboveMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor lineNoMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor linePosMonitor = new SwingChangeMonitor();
    private JPanel aboveBelowPanel = null;
    private JPanel labelNumbersPanel = null;
    private JPanel marginPanel = null;
    private MarginInput marginInput = null;

    public LabelPanel() {
        this.initialize();
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result;
        Label first = selection.getFirstElementOfType(Label.class);
        boolean bl = result = first != null;
        if (result) {
            LabelFormats f = first.getFormats();
            this.getAboveRadioButton().setSelected(f.isAbove());
            this.getBelowRadioButton().setSelected(!f.isAbove());
            this.getLineNoTextField().setText(StringUtils.INTEGER_FORMAT.format(f.getLineNumber()));
            this.getLinePosTextField().setText(StringUtils.DOUBLE_FORMAT.format(f.getLinePosition()));
            this.getMarginInput().setValue(f.getMargin());
        }
        return result;
    }

    @Override
    public String title() {
        return "Label formats";
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.aboveMonitor.hasChanged()) {
            operators.add(new LabelAboveOperator(this.getAboveRadioButton().isSelected()));
        }
        if (this.lineNoMonitor.hasChanged()) {
            operators.add(new LabelLineNumberOperator(Integer.parseInt(this.getLineNoTextField().getText())));
        }
        if (this.linePosMonitor.hasChanged()) {
            operators.add(new LabelLinePositionOperator(Math2.parseDouble(this.getLinePosTextField().getText())));
        }
        if (this.getMarginInput().getLeft().getChangeMonitor().hasChanged()) {
            operators.add(new LabelMarginLeftOperator(this.getMarginInput().getLeft().getValue()));
        }
        if (this.getMarginInput().getTop().getChangeMonitor().hasChanged()) {
            operators.add(new LabelMarginTopOperator(this.getMarginInput().getTop().getValue()));
        }
        if (this.getMarginInput().getRight().getChangeMonitor().hasChanged()) {
            operators.add(new LabelMarginRightOperator(this.getMarginInput().getRight().getValue()));
        }
        if (this.getMarginInput().getBottom().getChangeMonitor().hasChanged()) {
            operators.add(new LabelMarginBottomOperator(this.getMarginInput().getBottom().getValue()));
        }
    }

    @Override
    public void addError(List<String> list) {
    }

    @Override
    public void resetChangeMonitors() {
        this.aboveMonitor.reset();
        this.lineNoMonitor.reset();
        this.linePosMonitor.reset();
        this.getMarginInput().resetChangeMonitors();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getAboveBelowPanel(), null);
        this.add((Component)this.getLabelNumbersPanel(), null);
        this.add((Component)this.getMarginPanel(), null);
    }

    private JPanel getAboveBelowPanel() {
        if (this.aboveBelowPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridy = 0;
            this.aboveBelowPanel = new JPanel();
            this.aboveBelowPanel.setLayout(new GridBagLayout());
            this.aboveBelowPanel.setBorder(BorderFactory.createTitledBorder(null, "Position to branch", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.aboveBelowPanel.add((Component)this.getAboveRadioButton(), gridBagConstraints6);
            this.aboveBelowPanel.add((Component)this.getBelowRadioButton(), gridBagConstraints7);
            this.getAboveBelowGroup();
        }
        return this.aboveBelowPanel;
    }

    public ButtonGroup getAboveBelowGroup() {
        if (this.aboveBelowGroup == null) {
            this.aboveBelowGroup = new ButtonGroup();
            this.aboveBelowGroup.add(this.getAboveRadioButton());
            this.aboveBelowGroup.add(this.getBelowRadioButton());
        }
        return this.aboveBelowGroup;
    }

    private JRadioButton getAboveRadioButton() {
        if (this.aboveRadioButton == null) {
            this.aboveRadioButton = new JRadioButton();
            this.aboveRadioButton.setText("Above the branch");
            this.aboveRadioButton.getModel().addItemListener((ItemListener)this.aboveMonitor);
        }
        return this.aboveRadioButton;
    }

    private JRadioButton getBelowRadioButton() {
        if (this.belowRadioButton == null) {
            this.belowRadioButton = new JRadioButton();
            this.belowRadioButton.setText("Below the branch");
            this.belowRadioButton.getModel().addItemListener((ItemListener)this.aboveMonitor);
        }
        return this.belowRadioButton;
    }

    private JPanel getLabelNumbersPanel() {
        if (this.labelNumbersPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 3;
            GridBagConstraints linePosLabelGBC = new GridBagConstraints();
            linePosLabelGBC.gridx = 2;
            linePosLabelGBC.anchor = 17;
            linePosLabelGBC.gridy = 0;
            this.linePosLabel = new JLabel();
            this.linePosLabel.setText("Line position: ");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints lineNoLabelGBC = new GridBagConstraints();
            lineNoLabelGBC.gridx = 0;
            lineNoLabelGBC.anchor = 17;
            lineNoLabelGBC.gridy = 0;
            this.lineNoLabel = new JLabel();
            this.lineNoLabel.setText("Line number: ");
            this.labelNumbersPanel = new JPanel();
            this.labelNumbersPanel.setLayout(new GridBagLayout());
            this.labelNumbersPanel.setBorder(BorderFactory.createTitledBorder(null, "Line position", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.labelNumbersPanel.add((Component)this.lineNoLabel, lineNoLabelGBC);
            this.labelNumbersPanel.add((Component)this.getLineNoTextField(), gridBagConstraints1);
            this.labelNumbersPanel.add((Component)this.linePosLabel, linePosLabelGBC);
            this.labelNumbersPanel.add((Component)this.getLinePosTextField(), gridBagConstraints3);
        }
        return this.labelNumbersPanel;
    }

    private JFormattedTextField getLineNoTextField() {
        if (this.lineNoTextField == null) {
            NumberFormatter format = new NumberFormatter(StringUtils.INTEGER_FORMAT);
            format.setValueClass(Integer.class);
            format.setMinimum(new Integer(0));
            format.setAllowsInvalid(false);
            this.lineNoTextField = new JFormattedTextField(format);
            this.lineNoTextField.getDocument().addDocumentListener((DocumentListener)this.lineNoMonitor);
        }
        return this.lineNoTextField;
    }

    private JFormattedTextField getLinePosTextField() {
        if (this.linePosTextField == null) {
            this.linePosTextField = new JFormattedTextField(StringUtils.DOUBLE_FORMAT);
            this.linePosTextField.getDocument().addDocumentListener((DocumentListener)this.linePosMonitor);
        }
        return this.linePosTextField;
    }

    private JPanel getMarginPanel() {
        if (this.marginPanel == null) {
            this.marginPanel = new JPanel();
            this.marginPanel.setLayout(new GridBagLayout());
            this.marginPanel.setBorder(BorderFactory.createTitledBorder(null, "Margin", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.marginInput = new MarginInput("", this.marginPanel, 0);
        }
        return this.marginPanel;
    }

    private MarginInput getMarginInput() {
        this.getMarginPanel();
        return this.marginInput;
    }
}

