/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.changemonitor.ChangeMonitor;
import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.IconLabel;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.format.GraphicalLabelFormats;
import info.bioinfweb.treegraph.document.format.IconLabelFormats;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionContentType;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionLinkType;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.IconFilledOperator;
import info.bioinfweb.treegraph.document.format.operate.IconOperator;
import info.bioinfweb.treegraph.document.format.operate.InternalPieChartLinesOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelHeightOperator;
import info.bioinfweb.treegraph.document.format.operate.LabelWidthOperator;
import info.bioinfweb.treegraph.document.format.operate.PieChartCaptionsContentTypeOperator;
import info.bioinfweb.treegraph.document.format.operate.PieChartCaptionsLinkTypeOperator;
import info.bioinfweb.treegraph.document.format.operate.PieColorOperator;
import info.bioinfweb.treegraph.document.format.operate.ShowPieChartLinesForZeroOperator;
import info.bioinfweb.treegraph.document.format.operate.ShowPieChartTitleOperator;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.IconPreviewPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.LabelIconComboBoxModel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.PieChartLabelCaptionsTextFormatsDialog;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.piecolor.PieColorCellRenderer;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.piecolor.PieColorListEntry;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.wikihelp.client.JHTMLLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class IconPieChartLabelPanel
extends JPanel
implements ElementFormatsTab {
    public static final int PREVIEW_SIZE = 50;
    private PieChartLabelCaptionsTextFormatsDialog captionsDialog = null;
    private SwingChangeMonitor iconMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor iconFilledMonitor = new SwingChangeMonitor();
    private ChangeMonitor pieColorMonitor = new ChangeMonitor();
    private SwingChangeMonitor internalLinesMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor linesForZerosMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor showTitleMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor captionsContentTypeMonitor = new SwingChangeMonitor();
    private SwingChangeMonitor captionsLinkTypeMonitor = new SwingChangeMonitor();
    private JPanel iconPanel = null;
    private JComboBox<String> iconComboBox = null;
    private IconPreviewPanel iconPreviewPanel = null;
    private DistanceValueInput iconWidthInput = null;
    private DistanceValueInput iconHeightInput = null;
    private JCheckBox iconFilledCheckBox = null;
    private JPanel dimensionPanel = null;
    private JPanel pieChartPanel = null;
    private JLabel previewLabel = null;
    private JScrollPane colorListScrollPane = null;
    private JList<PieColorListEntry> colorList = null;
    private JLabel colorListLabel = null;
    private JCheckBox showInternalLinesCheckBox = null;
    private JCheckBox showNullLinesCheckBox = null;
    private JCheckBox showTitleCheckBox;
    private JButton captionsTextFormatsButton;
    private JPanel chartCaptionsPanel;
    private JLabel captionsContentTypeLabel;
    private JComboBox<PieChartLabelCaptionContentType> captionsContentTypeComboBox;
    private JLabel captionsLinkTypeLabel;
    private JComboBox<PieChartLabelCaptionLinkType> captionsLinkTypeComboBox;
    private JHTMLLabel captionLinkHelpLabel;
    private JLabel captionsTextFormatsLabel;

    public IconPieChartLabelPanel() {
        this.initialize();
        this.setIconValues(new IconLabelFormats(null));
    }

    @Override
    public void addError(List<String> list) {
    }

    @Override
    public String title() {
        return "Icon/pie chart label formats";
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        IconLabel iconLabel = selection.getFirstElementOfType(IconLabel.class);
        PieChartLabel pieChartLabel = selection.getFirstElementOfType(PieChartLabel.class);
        boolean iconLabelSel = iconLabel != null;
        boolean pieChartLabelSel = pieChartLabel != null;
        this.getIconComboBox().setEnabled(iconLabelSel);
        this.getIconFilledCheckBox().setEnabled(iconLabelSel);
        if (iconLabelSel) {
            this.setIconValues(iconLabel.getFormats());
        }
        this.getPieChartPanel().setEnabled(pieChartLabelSel);
        this.getColorListLabel().setEnabled(pieChartLabelSel);
        this.getColorList().setEnabled(pieChartLabelSel);
        this.getShowInternalLinesCheckBox().setEnabled(pieChartLabelSel);
        this.getShowNullLinesCheckBox().setEnabled(pieChartLabelSel);
        this.getShowTitleCheckBox().setEnabled(pieChartLabelSel);
        this.getCaptionsContentTypeLabel().setEnabled(pieChartLabelSel);
        this.getCaptionsContentTypeComboBox().setEnabled(pieChartLabelSel);
        this.getCaptionsLinkTypeLabel().setEnabled(pieChartLabelSel);
        this.getCaptionsLinkTypeComboBox().setEnabled(pieChartLabelSel);
        this.getCaptionLinkHelpLabel().setEnabled(pieChartLabelSel);
        this.getCaptionsTextFormatsButton().setEnabled(pieChartLabelSel);
        this.getCaptionsTextFormatsLabel().setEnabled(pieChartLabelSel);
        if (pieChartLabelSel) {
            PieChartLabelFormats f = pieChartLabel.getFormats();
            if (!iconLabelSel) {
                this.getWidthInput().setValue(f.getWidth());
                this.getHeightInput().setValue(f.getHeight());
            }
            this.getColorListModel().clear();
            int i = 0;
            while (i < pieChartLabel.getSectionDataList().size()) {
                this.getColorListModel().addElement(new PieColorListEntry(pieChartLabel.getSectionDataList().get(i).toString(), f.getPieColor(i)));
                ++i;
            }
            this.getShowInternalLinesCheckBox().setSelected(f.isShowInternalLines());
            this.getShowNullLinesCheckBox().setSelected(f.isShowLinesForZero());
            this.getShowTitleCheckBox().setSelected(f.isShowTitle());
            this.getCaptionsContentTypeComboBox().setSelectedItem((Object)f.getCaptionsContentType());
            this.getCaptionsLinkTypeComboBox().setSelectedItem((Object)f.getCaptionsLinkType());
            this.getCaptionsDialog().setValues(f);
        }
        return iconLabelSel || pieChartLabelSel;
    }

    private void setIconValues(IconLabelFormats f) {
        this.getWidthInput().setValue(f.getWidth());
        this.getHeightInput().setValue(f.getHeight());
        this.getIconComboBox().setSelectedItem(f.getIcon());
        this.getIconFilledCheckBox().setSelected(f.getIconFilled());
    }

    private Color[] getColorArray() {
        Color[] colors = new Color[this.getColorListModel().size()];
        int i = 0;
        while (i < colors.length) {
            colors[i] = this.getColorListEntry(i).getColor();
            ++i;
        }
        return colors;
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.iconMonitor.hasChanged()) {
            operators.add(new IconOperator(this.getIconComboBoxModel().getSelectedItem()));
        }
        if (this.getWidthInput().getChangeMonitor().hasChanged()) {
            operators.add(new LabelWidthOperator(this.getWidthInput().getValue()));
        }
        if (this.getHeightInput().getChangeMonitor().hasChanged()) {
            operators.add(new LabelHeightOperator(this.getHeightInput().getValue()));
        }
        if (this.iconFilledMonitor.hasChanged()) {
            operators.add(new IconFilledOperator(this.getIconFilledCheckBox().isSelected()));
        }
        if (this.pieColorMonitor.hasChanged()) {
            operators.add(new PieColorOperator(this.getColorArray()));
        }
        if (this.internalLinesMonitor.hasChanged()) {
            operators.add(new InternalPieChartLinesOperator(this.getShowInternalLinesCheckBox().isSelected()));
        }
        if (this.linesForZerosMonitor.hasChanged()) {
            operators.add(new ShowPieChartLinesForZeroOperator(this.getShowNullLinesCheckBox().isSelected()));
        }
        if (this.showTitleMonitor.hasChanged()) {
            operators.add(new ShowPieChartTitleOperator(this.getShowTitleCheckBox().isSelected()));
        }
        if (this.captionsContentTypeMonitor.hasChanged()) {
            operators.add(new PieChartCaptionsContentTypeOperator((PieChartLabelCaptionContentType)((Object)this.getCaptionsContentTypeComboBox().getSelectedItem())));
        }
        if (this.captionsLinkTypeMonitor.hasChanged()) {
            operators.add(new PieChartCaptionsLinkTypeOperator((PieChartLabelCaptionLinkType)((Object)this.getCaptionsLinkTypeComboBox().getSelectedItem())));
        }
        this.getCaptionsDialog().addOperators(operators);
    }

    @Override
    public void resetChangeMonitors() {
        this.iconMonitor.reset();
        this.getWidthInput().getChangeMonitor().reset();
        this.getHeightInput().getChangeMonitor().reset();
        this.iconFilledMonitor.reset();
        this.pieColorMonitor.reset();
        this.internalLinesMonitor.reset();
        this.linesForZerosMonitor.reset();
        this.showTitleMonitor.reset();
        this.captionsContentTypeMonitor.reset();
        this.captionsLinkTypeMonitor.reset();
        this.getCaptionsDialog().resetChangeMonitors();
    }

    public void setLabelFormats(GraphicalLabelFormats f) {
        f.getWidth().assign(this.getWidthInput().getValue());
        f.getHeight().assign(this.getHeightInput().getValue());
        if (f instanceof IconLabelFormats) {
            IconLabelFormats iconFormats = (IconLabelFormats)f;
            iconFormats.setIcon(this.getIconComboBoxModel().getSelectedItem());
            iconFormats.setIconFilled(this.getIconFilledCheckBox().isSelected());
        } else if (f instanceof PieChartLabelFormats) {
            PieChartLabelFormats pieChartFormats = (PieChartLabelFormats)f;
            Color[] colors = this.getColorArray();
            int i = 0;
            while (i < colors.length) {
                pieChartFormats.setPieColor(i, colors[i]);
                ++i;
            }
            pieChartFormats.setShowInternalLines(this.getShowInternalLinesCheckBox().isSelected());
            pieChartFormats.setShowLinesForZero(this.getShowNullLinesCheckBox().isSelected());
        }
    }

    public void setPieChartElementsVisible(boolean visible) {
        this.getPieChartPanel().setVisible(visible);
    }

    private void paintIconPreview() {
        this.getIconPreviewPanel().setIcon(this.getIconComboBoxModel().getSelectedItem());
        this.getIconPreviewPanel().setIconFilled(this.getIconFilledCheckBox().isSelected());
        this.getIconPreviewPanel().repaint();
    }

    private PieChartLabelCaptionsTextFormatsDialog getCaptionsDialog() {
        if (this.captionsDialog == null) {
            this.captionsDialog = new PieChartLabelCaptionsTextFormatsDialog((Dialog)SwingUtilities.windowForComponent(this));
        }
        return this.captionsDialog;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getDimensionPanel(), null);
        this.add((Component)this.getIconPanel(), null);
        this.add((Component)this.getPieChartPanel(), null);
    }

    private JPanel getIconPanel() {
        if (this.iconPanel == null) {
            this.iconPanel = new JPanel();
            GridBagLayout gbl_iconPanel = new GridBagLayout();
            gbl_iconPanel.rowWeights = new double[]{1.0, 1.0};
            this.iconPanel.setLayout(gbl_iconPanel);
            this.iconPanel.setBorder(BorderFactory.createTitledBorder(null, "Icon", 0, 0, null, null));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridx = 0;
            this.iconPanel.add(this.getIconComboBox(), gridBagConstraints4);
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridheight = 2;
            gridBagConstraints11.insets = new Insets(0, 5, 5, 2);
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 0;
            this.previewLabel = new JLabel();
            this.previewLabel.setText("Preview: ");
            this.iconPanel.add((Component)this.previewLabel, gridBagConstraints11);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(3, 3, 5, 0);
            this.iconPanel.add((Component)this.getIconPreviewPanel(), gridBagConstraints);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 1;
            this.iconPanel.add((Component)this.getIconFilledCheckBox(), gridBagConstraints8);
            this.iconPanel.setMaximumSize(new Dimension(this.iconPanel.getMaximumSize().width, this.iconPanel.getMinimumSize().height));
        }
        return this.iconPanel;
    }

    private DistanceValueInput getWidthInput() {
        this.getIconPanel();
        return this.iconWidthInput;
    }

    private DistanceValueInput getHeightInput() {
        this.getIconPanel();
        return this.iconHeightInput;
    }

    private JComboBox<String> getIconComboBox() {
        if (this.iconComboBox == null) {
            this.iconComboBox = new JComboBox<String>(new LabelIconComboBoxModel());
            this.iconComboBox.addItemListener((ItemListener)this.iconMonitor);
            this.iconComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (IconPieChartLabelPanel.this.getIconComboBoxModel().getSelectedItem() != null) {
                        IconPieChartLabelPanel.this.paintIconPreview();
                    }
                }
            });
        }
        return this.iconComboBox;
    }

    private LabelIconComboBoxModel getIconComboBoxModel() {
        return (LabelIconComboBoxModel)this.getIconComboBox().getModel();
    }

    private IconPreviewPanel getIconPreviewPanel() {
        if (this.iconPreviewPanel == null) {
            this.iconPreviewPanel = new IconPreviewPanel();
            this.iconPreviewPanel.setMinimumSize(new Dimension(50, 50));
        }
        return this.iconPreviewPanel;
    }

    private JCheckBox getIconFilledCheckBox() {
        if (this.iconFilledCheckBox == null) {
            this.iconFilledCheckBox = new JCheckBox();
            this.iconFilledCheckBox.setText("Fill icon");
            this.iconFilledCheckBox.addChangeListener((ChangeListener)this.iconFilledMonitor);
            this.iconFilledCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    IconPieChartLabelPanel.this.paintIconPreview();
                }
            });
        }
        return this.iconFilledCheckBox;
    }

    private JPanel getDimensionPanel() {
        if (this.dimensionPanel == null) {
            this.dimensionPanel = new JPanel();
            this.dimensionPanel.setLayout(new GridBagLayout());
            this.dimensionPanel.setBorder(BorderFactory.createTitledBorder(null, "Dimensions", 0, 0, null, null));
            this.iconWidthInput = new DistanceValueInput("Width: ", this.dimensionPanel, 1, 1);
            this.iconHeightInput = new DistanceValueInput("Height: ", this.dimensionPanel, 1, 3);
            this.dimensionPanel.setMaximumSize(new Dimension(this.dimensionPanel.getMaximumSize().width, this.dimensionPanel.getMinimumSize().height));
        }
        return this.dimensionPanel;
    }

    private JPanel getPieChartPanel() {
        if (this.pieChartPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = 0;
            this.pieChartPanel = new JPanel();
            GridBagLayout gbl_pieChartPanel = new GridBagLayout();
            gbl_pieChartPanel.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0};
            gbl_pieChartPanel.columnWeights = new double[]{1.0, 0.0};
            this.pieChartPanel.setLayout(gbl_pieChartPanel);
            this.pieChartPanel.setBorder(BorderFactory.createTitledBorder(null, "Pie chart", 0, 0, null, null));
            GridBagConstraints gbc_chartCaptionsPanel = new GridBagConstraints();
            gbc_chartCaptionsPanel.gridheight = 4;
            gbc_chartCaptionsPanel.fill = 1;
            gbc_chartCaptionsPanel.gridx = 1;
            gbc_chartCaptionsPanel.gridy = 0;
            this.pieChartPanel.add((Component)this.getChartCaptionsPanel(), gbc_chartCaptionsPanel);
            this.pieChartPanel.add((Component)this.getColorListScrollPane(), gridBagConstraints1);
            this.pieChartPanel.add((Component)this.getColorListLabel(), gridBagConstraints2);
        }
        return this.pieChartPanel;
    }

    private JLabel getColorListLabel() {
        if (this.colorListLabel == null) {
            this.colorListLabel = new JLabel();
            this.colorListLabel.setText("Sector colors: (Double click an entry to change a color.)");
        }
        return this.colorListLabel;
    }

    private JScrollPane getColorListScrollPane() {
        if (this.colorListScrollPane == null) {
            this.colorListScrollPane = new JScrollPane();
            this.colorListScrollPane.setViewportView(this.getColorList());
        }
        return this.colorListScrollPane;
    }

    private JList<PieColorListEntry> getColorList() {
        if (this.colorList == null) {
            this.colorList = new JList(new DefaultListModel());
            this.colorList.setCellRenderer(new PieColorCellRenderer());
            this.colorList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index;
                    if (e.getClickCount() >= 2 && (index = IconPieChartLabelPanel.this.getColorList().getSelectedIndex()) != -1) {
                        PieColorListEntry entry = IconPieChartLabelPanel.this.getColorListEntry(index);
                        Color color = JColorChooser.showDialog(IconPieChartLabelPanel.this.getTopLevelAncestor(), "Choose pie color", entry.getColor());
                        if (color != null) {
                            entry.setColor(color);
                            IconPieChartLabelPanel.this.getColorListModel().set(index, entry);
                            IconPieChartLabelPanel.this.pieColorMonitor.registerChange();
                        }
                    }
                }
            });
        }
        return this.colorList;
    }

    private DefaultListModel<PieColorListEntry> getColorListModel() {
        return (DefaultListModel)this.getColorList().getModel();
    }

    private PieColorListEntry getColorListEntry(int index) {
        return this.getColorListModel().get(index);
    }

    private JCheckBox getShowInternalLinesCheckBox() {
        if (this.showInternalLinesCheckBox == null) {
            this.showInternalLinesCheckBox = new JCheckBox();
            this.showInternalLinesCheckBox.setText("Show internal lines");
            this.showInternalLinesCheckBox.addItemListener((ItemListener)this.internalLinesMonitor);
        }
        return this.showInternalLinesCheckBox;
    }

    private JCheckBox getShowNullLinesCheckBox() {
        if (this.showNullLinesCheckBox == null) {
            this.showNullLinesCheckBox = new JCheckBox();
            this.showNullLinesCheckBox.setText("Show sectors with a value of 0");
            this.showNullLinesCheckBox.addItemListener((ItemListener)this.linesForZerosMonitor);
        }
        return this.showNullLinesCheckBox;
    }

    private JCheckBox getShowTitleCheckBox() {
        if (this.showTitleCheckBox == null) {
            this.showTitleCheckBox = new JCheckBox("Show title");
            this.showTitleCheckBox.addItemListener((ItemListener)this.showTitleMonitor);
        }
        return this.showTitleCheckBox;
    }

    private JButton getCaptionsTextFormatsButton() {
        if (this.captionsTextFormatsButton == null) {
            this.captionsTextFormatsButton = new JButton("Change caption text formats...");
            this.captionsTextFormatsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IconPieChartLabelPanel.this.getCaptionsDialog().execute();
                }
            });
        }
        return this.captionsTextFormatsButton;
    }

    private JLabel getCaptionsTextFormatsLabel() {
        if (this.captionsTextFormatsLabel == null) {
            this.captionsTextFormatsLabel = new JLabel("<html>(Use the botton above to format captions and<br>the tabs in this dialog to format headings.)</html>");
        }
        return this.captionsTextFormatsLabel;
    }

    private JPanel getChartCaptionsPanel() {
        if (this.chartCaptionsPanel == null) {
            this.chartCaptionsPanel = new JPanel();
            GridBagLayout gbl_chartCaptionsPanel = new GridBagLayout();
            this.chartCaptionsPanel.setLayout(gbl_chartCaptionsPanel);
            GridBagConstraints gbc_showInternalLinesCheckBox = new GridBagConstraints();
            gbc_showInternalLinesCheckBox.anchor = 17;
            gbc_showInternalLinesCheckBox.insets = new Insets(0, 0, 5, 0);
            gbc_showInternalLinesCheckBox.gridx = 0;
            gbc_showInternalLinesCheckBox.gridy = 0;
            this.chartCaptionsPanel.add((Component)this.getShowInternalLinesCheckBox(), gbc_showInternalLinesCheckBox);
            GridBagConstraints gbc_showNullLinesCheckBox = new GridBagConstraints();
            gbc_showNullLinesCheckBox.anchor = 17;
            gbc_showNullLinesCheckBox.insets = new Insets(0, 0, 5, 0);
            gbc_showNullLinesCheckBox.gridx = 0;
            gbc_showNullLinesCheckBox.gridy = 1;
            this.chartCaptionsPanel.add((Component)this.getShowNullLinesCheckBox(), gbc_showNullLinesCheckBox);
            GridBagConstraints gbc_showTitleCheckBox = new GridBagConstraints();
            gbc_showTitleCheckBox.anchor = 17;
            gbc_showTitleCheckBox.insets = new Insets(0, 0, 10, 0);
            gbc_showTitleCheckBox.gridx = 0;
            gbc_showTitleCheckBox.gridy = 2;
            this.chartCaptionsPanel.add((Component)this.getShowTitleCheckBox(), gbc_showTitleCheckBox);
            GridBagConstraints gbc_captionsContentTypeLabel = new GridBagConstraints();
            gbc_captionsContentTypeLabel.anchor = 17;
            gbc_captionsContentTypeLabel.insets = new Insets(0, 3, 5, 0);
            gbc_captionsContentTypeLabel.gridx = 0;
            gbc_captionsContentTypeLabel.gridy = 3;
            this.chartCaptionsPanel.add((Component)this.getCaptionsContentTypeLabel(), gbc_captionsContentTypeLabel);
            GridBagConstraints gbc_captionsContentTypeComboBox = new GridBagConstraints();
            gbc_captionsContentTypeComboBox.insets = new Insets(0, 3, 10, 0);
            gbc_captionsContentTypeComboBox.fill = 2;
            gbc_captionsContentTypeComboBox.gridx = 0;
            gbc_captionsContentTypeComboBox.gridy = 4;
            this.chartCaptionsPanel.add(this.getCaptionsContentTypeComboBox(), gbc_captionsContentTypeComboBox);
            GridBagConstraints gbc_captionsLinkTypeLabel = new GridBagConstraints();
            gbc_captionsLinkTypeLabel.anchor = 17;
            gbc_captionsLinkTypeLabel.insets = new Insets(0, 3, 5, 0);
            gbc_captionsLinkTypeLabel.gridx = 0;
            gbc_captionsLinkTypeLabel.gridy = 5;
            this.chartCaptionsPanel.add((Component)this.getCaptionsLinkTypeLabel(), gbc_captionsLinkTypeLabel);
            GridBagConstraints gbc_captionsLinkTypeComboBox = new GridBagConstraints();
            gbc_captionsLinkTypeComboBox.insets = new Insets(0, 3, 0, 0);
            gbc_captionsLinkTypeComboBox.fill = 2;
            gbc_captionsLinkTypeComboBox.gridx = 0;
            gbc_captionsLinkTypeComboBox.gridy = 6;
            this.chartCaptionsPanel.add(this.getCaptionsLinkTypeComboBox(), gbc_captionsLinkTypeComboBox);
            GridBagConstraints gbc_captionLinkHelpLabel = new GridBagConstraints();
            gbc_captionLinkHelpLabel.anchor = 17;
            gbc_captionLinkHelpLabel.insets = new Insets(2, 3, 10, 0);
            gbc_captionLinkHelpLabel.gridx = 0;
            gbc_captionLinkHelpLabel.gridy = 7;
            this.chartCaptionsPanel.add((Component)this.getCaptionLinkHelpLabel(), gbc_captionLinkHelpLabel);
            GridBagConstraints gbc_captionsFontButton = new GridBagConstraints();
            gbc_captionsFontButton.fill = 2;
            gbc_captionsFontButton.insets = new Insets(0, 3, 0, 0);
            gbc_captionsFontButton.gridx = 0;
            gbc_captionsFontButton.gridy = 8;
            this.chartCaptionsPanel.add((Component)this.getCaptionsTextFormatsButton(), gbc_captionsFontButton);
            GridBagConstraints gbc_captionsFontButtonLabel = new GridBagConstraints();
            gbc_captionsFontButtonLabel.anchor = 17;
            gbc_captionsFontButtonLabel.insets = new Insets(2, 3, 0, 0);
            gbc_captionsFontButtonLabel.gridx = 0;
            gbc_captionsFontButtonLabel.gridy = 9;
            this.chartCaptionsPanel.add((Component)this.getCaptionsTextFormatsLabel(), gbc_captionsFontButtonLabel);
        }
        return this.chartCaptionsPanel;
    }

    private JLabel getCaptionsContentTypeLabel() {
        if (this.captionsContentTypeLabel == null) {
            this.captionsContentTypeLabel = new JLabel("Show captions:");
        }
        return this.captionsContentTypeLabel;
    }

    private JComboBox<PieChartLabelCaptionContentType> getCaptionsContentTypeComboBox() {
        if (this.captionsContentTypeComboBox == null) {
            this.captionsContentTypeComboBox = new JComboBox<PieChartLabelCaptionContentType>(PieChartLabelCaptionContentType.values());
            this.captionsContentTypeComboBox.setEditable(false);
            this.captionsContentTypeComboBox.addItemListener((ItemListener)this.captionsContentTypeMonitor);
        }
        return this.captionsContentTypeComboBox;
    }

    private JLabel getCaptionsLinkTypeLabel() {
        if (this.captionsLinkTypeLabel == null) {
            this.captionsLinkTypeLabel = new JLabel("Caption link type:");
        }
        return this.captionsLinkTypeLabel;
    }

    private JComboBox<PieChartLabelCaptionLinkType> getCaptionsLinkTypeComboBox() {
        if (this.captionsLinkTypeComboBox == null) {
            this.captionsLinkTypeComboBox = new JComboBox<PieChartLabelCaptionLinkType>(PieChartLabelCaptionLinkType.values());
            this.captionsLinkTypeComboBox.setEditable(false);
            this.captionsLinkTypeComboBox.addItemListener((ItemListener)this.captionsLinkTypeMonitor);
        }
        return this.captionsLinkTypeComboBox;
    }

    private JHTMLLabel getCaptionLinkHelpLabel() {
        if (this.captionLinkHelpLabel == null) {
            this.captionLinkHelpLabel = new JHTMLLabel(Main.getInstance().getWikiHelp());
            this.captionLinkHelpLabel.setHTMLContent("<a href='wikihelp://93'>Which link type should I choose?</a>");
        }
        return this.captionLinkHelpLabel;
    }
}

