/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.changemonitor.ChangeMonitor;
import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.format.ConcreteTextFormats;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.document.format.operate.FontNameOperator;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.TextHeightOperator;
import info.bioinfweb.treegraph.document.format.operate.TextStyleOperator;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontFormatsPanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private static final int VISIBLE_ROW_COUNT = 8;
    private JPanel fontFamilyPanel = null;
    private JPanel fontStylePanel = null;
    private JPanel fontHeightPanel = null;
    private JPanel previewPanel = null;
    private JCheckBox boldCheckBox = null;
    private JCheckBox italicCheckBox = null;
    private JCheckBox underlineCheckBox = null;
    private DistanceValueInput fontHeightInput = null;
    private JTextField previewTextField = null;
    private JList<String> fontFamilyList = null;
    private JTextField fontFamilyTextField = null;
    private SwingChangeMonitor fontFamilyMonitor = new SwingChangeMonitor();
    private ChangeMonitor boldMonitor = new ChangeMonitor();
    private ChangeMonitor italicMonitor = new ChangeMonitor();
    private ChangeMonitor underlineMonitor = new ChangeMonitor();

    public FontFormatsPanel(boolean showTextHeightInput) {
        this.initialize(showTextHeightInput);
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result;
        TextElement first = selection.getFirstElementOfType(TextElement.class);
        boolean bl = result = first != null;
        if (result) {
            this.setValue(first.getFormats());
        }
        return result;
    }

    @Override
    public String title() {
        return "Font formats";
    }

    @Override
    public void addOperators(List<FormatOperator> list) {
        if (this.fontFamilyMonitor.hasChanged()) {
            list.add(new FontNameOperator(this.getFontFamilyTextField().getText()));
        }
        if (this.boldMonitor.hasChanged()) {
            list.add(new TextStyleOperator(this.getBoldCheckBox().isSelected(), 1));
        }
        if (this.italicMonitor.hasChanged()) {
            list.add(new TextStyleOperator(this.getItalicCheckBox().isSelected(), 2));
        }
        if (this.underlineMonitor.hasChanged()) {
            list.add(new TextStyleOperator(this.getUnderlineCheckBox().isSelected(), 4));
        }
        if (this.fontHeightInput != null && this.fontHeightInput.getChangeMonitor().hasChanged()) {
            list.add(new TextHeightOperator(this.getFontHeightInput().getValue()));
        }
    }

    @Override
    public void addError(List<String> list) {
        if (this.fontHeightInput != null && this.fontHeightInput.getValue().getInMillimeters() < 0.0f) {
            list.add("The font height cannot be less than 0.");
        }
    }

    private DistanceValueInput getFontHeightInput() {
        return this.fontHeightInput;
    }

    public void setValue(TextFormats f) {
        this.getFontFamilyTextField().setText(f.getFontName());
        this.selectInFontList(f.getFontName());
        if (this.getFontHeightInput() != null) {
            this.getFontHeightInput().setValue(f.getTextHeight());
        }
        this.getBoldCheckBox().getModel().setSelected(f.hasTextStyle(1));
        this.getItalicCheckBox().getModel().setSelected(f.hasTextStyle(2));
        this.getUnderlineCheckBox().getModel().setSelected(f.hasTextStyle(4));
    }

    public void assignValue(TextFormats f) {
        f.setFontName(this.getFontFamilyTextField().getText());
        f.setTextStyle(0);
        if (this.getFontHeightInput() != null) {
            this.getFontHeightInput().assignValueTo(f.getTextHeight());
        }
        if (this.getBoldCheckBox().getModel().isSelected()) {
            f.addTextStyle(1);
        }
        if (this.getItalicCheckBox().getModel().isSelected()) {
            f.addTextStyle(2);
        }
        if (this.getUnderlineCheckBox().getModel().isSelected()) {
            f.addTextStyle(4);
        }
    }

    @Override
    public void resetChangeMonitors() {
        this.fontFamilyMonitor.reset();
        if (this.fontHeightInput != null) {
            this.fontHeightInput.getChangeMonitor().reset();
        }
        this.boldMonitor.reset();
        this.italicMonitor.reset();
        this.underlineMonitor.reset();
    }

    public void preview() {
        ConcreteTextFormats f = new ConcreteTextFormats();
        this.assignValue(f);
        this.getPreviewTextField().setFont(f.getFont(2.8346457f));
    }

    private void selectInFontList(String value) {
        if (this.getFontFamilyList().getModel().getSize() > 0) {
            int pos = 0;
            while (pos < this.getFontFamilyList().getModel().getSize() && this.getFontFamilyList().getModel().getElementAt(pos).toString().compareToIgnoreCase(value) < 0) {
                ++pos;
            }
            this.getFontFamilyList().setSelectedIndex(pos);
            this.getFontFamilyList().ensureIndexIsVisible(pos);
        } else {
            this.getFontFamilyList().clearSelection();
        }
    }

    private void initialize(boolean showTextHeightInput) {
        this.setSize(300, 200);
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getFontFamilyPanel(), null);
        this.add((Component)this.getFontStylePanel(), null);
        if (showTextHeightInput) {
            this.add((Component)this.getFontHeightPanel(), null);
        }
        this.add((Component)this.getPreviewPanel(), null);
    }

    private JPanel getFontFamilyPanel() {
        if (this.fontFamilyPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.fontFamilyPanel = new JPanel();
            this.fontFamilyPanel.setLayout(new GridBagLayout());
            this.fontFamilyPanel.setBorder(BorderFactory.createTitledBorder(null, "Font family", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.fontFamilyPanel.add((Component)this.getFontFamilyTextField(), gridBagConstraints11);
            this.fontFamilyPanel.add((Component)new JScrollPane(this.getFontFamilyList()), gridBagConstraints2);
        }
        return this.fontFamilyPanel;
    }

    private JPanel getFontStylePanel() {
        if (this.fontStylePanel == null) {
            this.fontStylePanel = new JPanel();
            this.fontStylePanel.setLayout(new FlowLayout());
            this.fontStylePanel.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.fontStylePanel.add((Component)this.getBoldCheckBox(), null);
            this.fontStylePanel.add((Component)this.getItalicCheckBox(), null);
            this.fontStylePanel.add((Component)this.getUnderlineCheckBox(), null);
            this.fontStylePanel.setMaximumSize(new Dimension(this.fontStylePanel.getMaximumSize().width, this.fontStylePanel.getMinimumSize().height));
        }
        return this.fontStylePanel;
    }

    private JPanel getFontHeightPanel() {
        if (this.fontHeightPanel == null) {
            this.fontHeightPanel = new JPanel();
            this.fontHeightPanel.setLayout(new GridBagLayout());
            this.fontHeightPanel.setBorder(BorderFactory.createTitledBorder(null, "Font height", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.fontHeightInput = new DistanceValueInput("", this.fontHeightPanel, 0);
            this.fontHeightPanel.setMaximumSize(new Dimension(this.fontHeightPanel.getMaximumSize().width, this.fontHeightPanel.getMinimumSize().height));
        }
        return this.fontHeightPanel;
    }

    private JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            this.previewPanel = new JPanel();
            this.previewPanel.setLayout(new GridBagLayout());
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.previewPanel.add((Component)this.getPreviewTextField(), gridBagConstraints1);
            this.previewPanel.setMaximumSize(new Dimension(this.previewPanel.getMaximumSize().width, this.previewPanel.getMinimumSize().height));
        }
        return this.previewPanel;
    }

    private JCheckBox getBoldCheckBox() {
        if (this.boldCheckBox == null) {
            this.boldCheckBox = new JCheckBox();
            this.boldCheckBox.setText("Bold");
            this.boldCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FontFormatsPanel.this.boldMonitor.registerChange();
                    FontFormatsPanel.this.preview();
                }
            });
        }
        return this.boldCheckBox;
    }

    private JCheckBox getItalicCheckBox() {
        if (this.italicCheckBox == null) {
            this.italicCheckBox = new JCheckBox();
            this.italicCheckBox.setText("Italic");
            this.italicCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FontFormatsPanel.this.italicMonitor.registerChange();
                    FontFormatsPanel.this.preview();
                }
            });
        }
        return this.italicCheckBox;
    }

    private JCheckBox getUnderlineCheckBox() {
        if (this.underlineCheckBox == null) {
            this.underlineCheckBox = new JCheckBox();
            this.underlineCheckBox.setText("Underline");
            this.underlineCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FontFormatsPanel.this.underlineMonitor.registerChange();
                }
            });
        }
        return this.underlineCheckBox;
    }

    private JTextField getPreviewTextField() {
        if (this.previewTextField == null) {
            this.previewTextField = new JTextField();
            this.previewTextField.setText("abcdefghijklmnopqrstuvwxyz0123456789");
            this.previewTextField.setEditable(false);
        }
        return this.previewTextField;
    }

    private JList<String> getFontFamilyList() {
        if (this.fontFamilyList == null) {
            this.fontFamilyList = new JList<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            this.fontFamilyList.setVisibleRowCount(8);
            this.fontFamilyList.setSelectionMode(0);
            this.fontFamilyList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && FontFormatsPanel.this.getFontFamilyList().isFocusOwner()) {
                        FontFormatsPanel.this.getFontFamilyTextField().setText(((String)FontFormatsPanel.this.fontFamilyList.getModel().getElementAt(FontFormatsPanel.this.fontFamilyList.getSelectedIndex())).toString());
                        FontFormatsPanel.this.preview();
                    }
                }
            });
        }
        return this.fontFamilyList;
    }

    private JTextField getFontFamilyTextField() {
        if (this.fontFamilyTextField == null) {
            this.fontFamilyTextField = new JTextField();
            this.fontFamilyTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    FontFormatsPanel.this.selectInFontList(FontFormatsPanel.this.getFontFamilyTextField().getText());
                }
            });
            this.fontFamilyTextField.getDocument().addDocumentListener((DocumentListener)this.fontFamilyMonitor);
        }
        return this.fontFamilyTextField;
    }
}

