/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.TextColorOperator;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.event.ChangeListener;

public class FontColorPanel
extends JColorChooser
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private SwingChangeMonitor colorMonitor = new SwingChangeMonitor();

    public FontColorPanel() {
        this.getSelectionModel().addChangeListener((ChangeListener)this.colorMonitor);
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result;
        TextElement first = selection.getFirstElementOfType(TextElement.class);
        boolean bl = result = first != null;
        if (result) {
            this.setColor(first.getFormats().getTextColor());
        }
        return result;
    }

    @Override
    public String title() {
        return "Font color";
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.colorMonitor.hasChanged()) {
            operators.add(new TextColorOperator(this.getColor()));
        }
    }

    @Override
    public void addError(List<String> list) {
    }

    @Override
    public void resetChangeMonitors() {
        this.colorMonitor.reset();
    }
}

