/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.undo.format.OperatorsEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.BranchPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.DecimalFormatPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.FontColorPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.FontFormatsPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.IconPieChartLabelPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.LabelPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.LegendPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.LinePanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.NodeMarginPanel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ScaleBarPanel;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ElementFormatsDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTabbedPane formatsTabbedPane = null;
    private List<ElementFormatsTab> tabs = null;

    public ElementFormatsDialog(Frame owner) {
        super(owner);
        this.setHelpCode(49);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    public Document getDocument() {
        return super.getDocument();
    }

    private void resetChangeMonitors() {
        int i = 0;
        while (i < this.getTabs().size()) {
            this.getTabs().get(i).resetChangeMonitors();
            ++i;
        }
    }

    public static boolean checkInputs(Component dialogParent, JTabbedPane pane, List<ElementFormatsTab> tabs) {
        boolean result;
        ArrayList<String> errors = new ArrayList<String>();
        int i = 0;
        while (i < tabs.size()) {
            if (pane.isEnabledAt(i)) {
                tabs.get(i).addError(errors);
            }
            ++i;
        }
        boolean bl = result = errors.size() == 0;
        if (!result) {
            String text = "One or more of your inputs are invalid:\n\n";
            int i2 = 0;
            while (i2 < errors.size()) {
                text = String.valueOf(text) + "- " + (String)errors.get(i2) + "\n";
                ++i2;
            }
            JOptionPane.showMessageDialog(dialogParent, text, "Invalid inputs", 0);
        }
        return result;
    }

    @Override
    protected boolean onExecute() {
        boolean result;
        boolean bl = result = !this.getSelection().isEmpty();
        if (result) {
            int i = 0;
            while (i < this.getFormatsTabbedPane().getTabCount()) {
                this.getFormatsTabbedPane().setEnabledAt(i, this.getTabs().get(i).setValues(this.getSelection()));
                ++i;
            }
            if (!this.getFormatsTabbedPane().isEnabledAt(this.getFormatsTabbedPane().getSelectedIndex())) {
                int index = 0;
                while (!this.getFormatsTabbedPane().isEnabledAt(index)) {
                    ++index;
                }
                this.getFormatsTabbedPane().setSelectedIndex(index);
            }
            this.resetChangeMonitors();
        }
        return result;
    }

    public static List<FormatOperator> getTabOperators(List<ElementFormatsTab> tabs) {
        ArrayList<FormatOperator> result = new ArrayList<FormatOperator>();
        for (ElementFormatsTab tab : tabs) {
            tab.addOperators(result);
        }
        return result;
    }

    protected boolean apply() {
        List<FormatOperator> operators;
        boolean result = ElementFormatsDialog.checkInputs((Component)((Object)this), this.getFormatsTabbedPane(), this.getTabs());
        if (result && (operators = ElementFormatsDialog.getTabOperators(this.getTabs())).size() > 0) {
            this.getDocument().executeEdit(new OperatorsEdit(this.getDocument(), this.getSelection().toArray(new AbstractPaintableElement[this.getSelection().size()]), operators.toArray(new FormatOperator[operators.size()])));
            this.resetChangeMonitors();
        }
        return result;
    }

    public List<ElementFormatsTab> getTabs() {
        if (this.tabs == null) {
            this.tabs = new ArrayList<ElementFormatsTab>();
            this.tabs.add(new LinePanel());
            this.tabs.add(new FontFormatsPanel(true));
            this.tabs.add(new FontColorPanel());
            this.tabs.add(new DecimalFormatPanel());
            this.tabs.add(new NodeMarginPanel());
            this.tabs.add(new BranchPanel());
            this.tabs.add(new LabelPanel());
            this.tabs.add(new IconPieChartLabelPanel());
            this.tabs.add(new LegendPanel());
            this.tabs.add(new ScaleBarPanel(this));
        }
        return this.tabs;
    }

    private void initialize() {
        this.setTitle("Element formats");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getFormatsTabbedPane(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JTabbedPane getFormatsTabbedPane() {
        if (this.formatsTabbedPane == null) {
            this.formatsTabbedPane = new JTabbedPane();
            int i = 0;
            while (i < this.getTabs().size()) {
                this.formatsTabbedPane.addTab(this.getTabs().get(i).title(), (Component)((Object)this.getTabs().get(i)));
                ++i;
            }
        }
        return this.formatsTabbedPane;
    }
}

