/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DecimalFormatsTableModel
extends AbstractTableModel {
    private Vector<String[]> entries = new Vector();

    public DecimalFormatsTableModel() {
        this.fillEntryList();
    }

    private void addEntry(String description, String format) {
        String[] entry = new String[]{description, format};
        this.entries.add(entry);
    }

    private void fillEntryList() {
        this.addEntry("Integer", "0");
        this.addEntry("Always one decimal place", "0.0");
        this.addEntry("Always two decimal places", "0.00");
        this.addEntry("Up to seven decimal places", "0.#######");
        this.addEntry("Integer with grouping separator at thousand", "#,###");
        this.addEntry("Decimal places and grouping separator at thousand", "#,###.#######");
        this.addEntry("Scientific notation", "0.#######E0");
        this.addEntry("Scientific notation with two decimal places", "0.00E0");
        this.addEntry("Percent", "#%");
        this.addEntry("Percent with one decimal place", "#.0%");
        this.addEntry("Integer in brackets", "[0];[-0]");
        this.addEntry("Always one decimal place in brackets", "[0.0];[-0.0]");
        this.addEntry("Always two decimal places in brackets", "[0.00];[-0.00]");
        this.addEntry("Up to seven decimal places in brackets", "[0.#######];[-0.#######]");
        this.addEntry("Scientific notation in brackets", "[0.#######E0];[-0.#######E0]");
        this.addEntry("Scientific notation (two decimal places, brackets)", "[0.00E0];[-0.00E0]");
        this.addEntry("Percent in brackets", "[#%];[-#%]");
        this.addEntry("Percent with one decimal place in brackets", "[#.0%];[-#.0%]");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Description";
        }
        return "Format";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.entries.get(row)[col];
    }
}

