/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.swing.LocaleComboBoxModel;
import info.bioinfweb.commons.swing.SwingChangeMonitor;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.document.format.operate.DecimalFormatOperator;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.DecimalFormatsTableModel;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DecimalFormatPanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    public static final double FORMAT_EXAMPLE = 1125024.87356218;
    private JPanel formatPanel = null;
    private JPanel examplePanel = null;
    private JLabel formatLabel = null;
    private JTextField formatTextField = null;
    private JTable predifinedTable = null;
    private JComboBox localeComboBox = null;
    private JLabel localeLabel = null;
    private SwingChangeMonitor changeMonitor = new SwingChangeMonitor();
    private JScrollPane tableScrollPane = null;
    private JLabel positiveExampleLabel = null;
    private JLabel negativeExampleLabel = null;
    private JLabel hintLabel = null;

    public DecimalFormatPanel() {
        this.initialize();
    }

    private Locale getLocaleValue() {
        return ((LocaleComboBoxModel)this.getLocaleComboBox().getModel()).getSelectedLocale();
    }

    private DecimalFormat getDecimalFormat() {
        DecimalFormat result;
        try {
            result = new DecimalFormat(this.getFormatTextField().getText());
        }
        catch (IllegalArgumentException e) {
            result = new DecimalFormat();
            JOptionPane.showMessageDialog(null, "The pattern \"" + this.getFormatTextField().getText() + "\" is invalid.", "Invalid pattern", 0);
        }
        result.setDecimalFormatSymbols(new DecimalFormatSymbols(this.getLocaleValue()));
        return result;
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.changeMonitor.hasChanged()) {
            operators.add(new DecimalFormatOperator(this.getDecimalFormat(), this.getLocaleValue()));
        }
    }

    @Override
    public void addError(List<String> list) {
    }

    @Override
    public void resetChangeMonitors() {
        this.changeMonitor.reset();
    }

    public void setValues(TextFormats f) {
        this.getFormatTextField().setText(f.getDecimalFormat().toPattern());
        this.getLocaleComboBox().getModel().setSelectedItem(f.getLocale().getDisplayName());
        this.updateExample();
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result = selection.containsType(TextElement.class);
        if (result) {
            this.setValues(selection.getFirstElementOfType(TextElement.class).getFormats());
        }
        return result;
    }

    @Override
    public String title() {
        return "Decimal format";
    }

    private void updateExample() {
        DecimalFormat f = this.getDecimalFormat();
        this.getPositiveExampleLabel().setText(f.format(1125024.87356218));
        this.getNegativeExampleLabel().setText(f.format(-1125024.87356218));
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getFormatPanel(), null);
        this.add((Component)this.getExamplePanel(), null);
    }

    private JPanel getFormatPanel() {
        if (this.formatPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(7, 0, 3, 0);
            gridBagConstraints7.gridy = 3;
            this.hintLabel = new JLabel();
            this.hintLabel.setText("A definition of the format string syntax can be found in the help (button below).");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 2;
            this.localeLabel = new JLabel();
            this.localeLabel.setText("Locale: ");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(2, 0, 0, 0);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 0;
            this.formatLabel = new JLabel();
            this.formatLabel.setText("Format:");
            this.formatPanel = new JPanel();
            this.formatPanel.setLayout(new GridBagLayout());
            this.formatPanel.setBorder(BorderFactory.createTitledBorder(null, "Format", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.formatPanel.add((Component)this.formatLabel, gridBagConstraints1);
            this.formatPanel.add((Component)this.getFormatTextField(), gridBagConstraints2);
            this.formatPanel.add((Component)this.getLocaleComboBox(), gridBagConstraints4);
            this.formatPanel.add((Component)this.localeLabel, gridBagConstraints5);
            this.formatPanel.add((Component)this.getTableScrollPane(), gridBagConstraints6);
            this.formatPanel.add((Component)this.hintLabel, gridBagConstraints7);
        }
        return this.formatPanel;
    }

    private JPanel getExamplePanel() {
        if (this.examplePanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.gridy = 0;
            this.negativeExampleLabel = new JLabel();
            this.negativeExampleLabel.setText(" ");
            this.positiveExampleLabel = new JLabel();
            this.positiveExampleLabel.setText(" ");
            this.examplePanel = new JPanel();
            this.examplePanel.setLayout(new GridBagLayout());
            this.examplePanel.setBorder(BorderFactory.createTitledBorder(null, "Example", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.examplePanel.add((Component)this.positiveExampleLabel, gridBagConstraints3);
            this.examplePanel.add((Component)this.negativeExampleLabel, gridBagConstraints);
        }
        return this.examplePanel;
    }

    private JLabel getPositiveExampleLabel() {
        this.getExamplePanel();
        return this.positiveExampleLabel;
    }

    private JLabel getNegativeExampleLabel() {
        this.getExamplePanel();
        return this.negativeExampleLabel;
    }

    private JTextField getFormatTextField() {
        if (this.formatTextField == null) {
            this.formatTextField = new JTextField();
            this.formatTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DecimalFormatPanel.this.updateExample();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DecimalFormatPanel.this.updateExample();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DecimalFormatPanel.this.updateExample();
                }
            });
            this.formatTextField.getDocument().addDocumentListener((DocumentListener)this.changeMonitor);
        }
        return this.formatTextField;
    }

    private JTable getPredifinedTable() {
        if (this.predifinedTable == null) {
            this.predifinedTable = new JTable(new DecimalFormatsTableModel());
            this.predifinedTable.setColumnSelectionAllowed(false);
            this.predifinedTable.setRowSelectionAllowed(true);
            this.predifinedTable.getTableHeader().setReorderingAllowed(false);
            this.predifinedTable.getSelectionModel().setSelectionMode(0);
            this.predifinedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DecimalFormatPanel.this.getFormatTextField().setText(DecimalFormatPanel.this.getPredifinedTable().getModel().getValueAt(DecimalFormatPanel.this.getPredifinedTable().getSelectedRows()[DecimalFormatPanel.this.getPredifinedTable().getSelectedRowCount() - 1], 1).toString());
                }
            });
        }
        return this.predifinedTable;
    }

    private JComboBox getLocaleComboBox() {
        if (this.localeComboBox == null) {
            this.localeComboBox = new JComboBox(new LocaleComboBoxModel(DecimalFormatSymbols.getAvailableLocales()));
            this.localeComboBox.addItemListener((ItemListener)this.changeMonitor);
            this.localeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DecimalFormatPanel.this.updateExample();
                }
            });
        }
        return this.localeComboBox;
    }

    private JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane();
            this.tableScrollPane.setViewportView(this.getPredifinedTable());
        }
        return this.tableScrollPane;
    }
}

