/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.elementformats;

import info.bioinfweb.commons.changemonitor.ChangeMonitor;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.format.BranchFormats;
import info.bioinfweb.treegraph.document.format.operate.ConstantWidthOperator;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.format.operate.MinLengthOperator;
import info.bioinfweb.treegraph.document.format.operate.MinSpaceAboveOperator;
import info.bioinfweb.treegraph.document.format.operate.MinSpaceBelowOperator;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.elementformats.ElementFormatsTab;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BranchPanel
extends JPanel
implements ElementFormatsTab {
    private static final long serialVersionUID = 1L;
    private DistanceValueInput minLengthInput = null;
    private DistanceValueInput spaceAboveInput = null;
    private DistanceValueInput spaceBelowInput = null;
    private JLabel spacer = null;
    private JCheckBox constantWidthCheckBox = null;
    private ChangeMonitor constantWidthMonitor = new ChangeMonitor();

    public BranchPanel() {
        this.initialize();
    }

    @Override
    public boolean setValues(TreeSelection selection) {
        boolean result;
        Branch first = selection.getFirstElementOfType(Branch.class);
        boolean bl = result = first != null;
        if (result) {
            BranchFormats f = first.getFormats();
            this.minLengthInput.setValue(f.getMinLength());
            this.spaceAboveInput.setValue(f.getMinSpaceAbove());
            this.spaceBelowInput.setValue(f.getMinSpaceBelow());
            this.getConstantWidthCheckBox().setSelected(f.isConstantWidth());
        }
        return result;
    }

    @Override
    public String title() {
        return "Branch formats";
    }

    @Override
    public void addOperators(List<FormatOperator> operators) {
        if (this.minLengthInput.getChangeMonitor().hasChanged()) {
            operators.add(new MinLengthOperator(this.minLengthInput.getValue()));
        }
        if (this.spaceAboveInput.getChangeMonitor().hasChanged()) {
            operators.add(new MinSpaceAboveOperator(this.spaceAboveInput.getValue()));
        }
        if (this.spaceBelowInput.getChangeMonitor().hasChanged()) {
            operators.add(new MinSpaceBelowOperator(this.spaceBelowInput.getValue()));
        }
        if (this.constantWidthMonitor.hasChanged()) {
            operators.add(new ConstantWidthOperator(this.getConstantWidthCheckBox().isSelected()));
        }
    }

    @Override
    public void addError(List<String> list) {
        if (this.minLengthInput.getValue().getInMillimeters() < 0.0f) {
            list.add("The minimal length of a branch cannot be less than 0.");
        }
        if (this.spaceAboveInput.getValue().getInMillimeters() < 0.0f) {
            list.add("The minimal Minimal space above a branch cannot be less than 0.");
        }
        if (this.spaceBelowInput.getValue().getInMillimeters() < 0.0f) {
            list.add("The minimal Minimal space below a branch cannot be less than 0.");
        }
    }

    @Override
    public void resetChangeMonitors() {
        this.minLengthInput.getChangeMonitor().reset();
        this.spaceAboveInput.getChangeMonitor().reset();
        this.spaceBelowInput.getChangeMonitor().reset();
        this.constantWidthMonitor.reset();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 7;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.spacer = new JLabel();
        this.spacer.setText(" ");
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Distances", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.spacer, gridBagConstraints);
        this.add((Component)this.getConstantWidthCheckBox(), gridBagConstraints2);
        this.minLengthInput = new DistanceValueInput("Minimal length: ", this, 0);
        this.spaceAboveInput = new DistanceValueInput("Minimal space above: ", this, 2);
        this.spaceBelowInput = new DistanceValueInput("Minimal space below: ", this, 4);
    }

    private JCheckBox getConstantWidthCheckBox() {
        if (this.constantWidthCheckBox == null) {
            this.constantWidthCheckBox = new JCheckBox();
            this.constantWidthCheckBox.setText("Use constant line width (don't taper to parent nodes line width)");
            this.constantWidthCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BranchPanel.this.constantWidthMonitor.registerChange();
                }
            });
        }
        return this.constantWidthCheckBox;
    }
}

